/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.HDInsightActivityDebugInfoOption;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HDInsightMapReduceActivity
extends ExecutionActivity {
    private String type = "HDInsightMapReduce";
    private List<LinkedServiceReference> storageLinkedServices;
    private List<Object> arguments;
    private HDInsightActivityDebugInfoOption getDebugInfo;
    private Object className;
    private Object jarFilePath;
    private LinkedServiceReference jarLinkedService;
    private List<Object> jarLibs;
    private Map<String, Object> defines;

    @Override
    public String getType() {
        return this.type;
    }

    public List<LinkedServiceReference> getStorageLinkedServices() {
        return this.storageLinkedServices;
    }

    public HDInsightMapReduceActivity setStorageLinkedServices(List<LinkedServiceReference> storageLinkedServices) {
        this.storageLinkedServices = storageLinkedServices;
        return this;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public HDInsightMapReduceActivity setArguments(List<Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public HDInsightActivityDebugInfoOption getGetDebugInfo() {
        return this.getDebugInfo;
    }

    public HDInsightMapReduceActivity setGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        this.getDebugInfo = getDebugInfo;
        return this;
    }

    public Object getClassName() {
        return this.className;
    }

    public HDInsightMapReduceActivity setClassName(Object className) {
        this.className = className;
        return this;
    }

    public Object getJarFilePath() {
        return this.jarFilePath;
    }

    public HDInsightMapReduceActivity setJarFilePath(Object jarFilePath) {
        this.jarFilePath = jarFilePath;
        return this;
    }

    public LinkedServiceReference getJarLinkedService() {
        return this.jarLinkedService;
    }

    public HDInsightMapReduceActivity setJarLinkedService(LinkedServiceReference jarLinkedService) {
        this.jarLinkedService = jarLinkedService;
        return this;
    }

    public List<Object> getJarLibs() {
        return this.jarLibs;
    }

    public HDInsightMapReduceActivity setJarLibs(List<Object> jarLibs) {
        this.jarLibs = jarLibs;
        return this;
    }

    public Map<String, Object> getDefines() {
        return this.defines;
    }

    public HDInsightMapReduceActivity setDefines(Map<String, Object> defines) {
        this.defines = defines;
        return this;
    }

    @Override
    public HDInsightMapReduceActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public HDInsightMapReduceActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.storageLinkedServices != null || this.arguments != null || this.getDebugInfo != null || this.className != null || this.jarFilePath != null || this.jarLinkedService != null || this.jarLibs != null || this.defines != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeArrayField("storageLinkedServices", this.storageLinkedServices, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeStringField("getDebugInfo", this.getDebugInfo == null ? null : this.getDebugInfo.toString());
            jsonWriter.writeUntypedField("className", this.className);
            jsonWriter.writeUntypedField("jarFilePath", this.jarFilePath);
            jsonWriter.writeJsonField("jarLinkedService", (JsonSerializable)this.jarLinkedService);
            jsonWriter.writeArrayField("jarLibs", this.jarLibs, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeMapField("defines", this.defines, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HDInsightMapReduceActivity fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightMapReduceActivity)jsonReader.readObject(reader -> {
            HDInsightMapReduceActivity deserializedHDInsightMapReduceActivity = new HDInsightMapReduceActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedHDInsightMapReduceActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHDInsightMapReduceActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedHDInsightMapReduceActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedHDInsightMapReduceActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedHDInsightMapReduceActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedHDInsightMapReduceActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedHDInsightMapReduceActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedHDInsightMapReduceActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHDInsightMapReduceActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("storageLinkedServices".equals(fieldName)) {
                            List storageLinkedServices;
                            deserializedHDInsightMapReduceActivity.storageLinkedServices = storageLinkedServices = reader.readArray(reader1 -> LinkedServiceReference.fromJson(reader1));
                            continue;
                        }
                        if ("arguments".equals(fieldName)) {
                            List arguments;
                            deserializedHDInsightMapReduceActivity.arguments = arguments = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("getDebugInfo".equals(fieldName)) {
                            deserializedHDInsightMapReduceActivity.getDebugInfo = HDInsightActivityDebugInfoOption.fromString(reader.getString());
                            continue;
                        }
                        if ("className".equals(fieldName)) {
                            deserializedHDInsightMapReduceActivity.className = reader.readUntyped();
                            continue;
                        }
                        if ("jarFilePath".equals(fieldName)) {
                            deserializedHDInsightMapReduceActivity.jarFilePath = reader.readUntyped();
                            continue;
                        }
                        if ("jarLinkedService".equals(fieldName)) {
                            deserializedHDInsightMapReduceActivity.jarLinkedService = LinkedServiceReference.fromJson(reader);
                            continue;
                        }
                        if ("jarLibs".equals(fieldName)) {
                            List jarLibs;
                            deserializedHDInsightMapReduceActivity.jarLibs = jarLibs = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("defines".equals(fieldName)) {
                            Map defines;
                            deserializedHDInsightMapReduceActivity.defines = defines = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHDInsightMapReduceActivity.setAdditionalProperties(additionalProperties);
            return deserializedHDInsightMapReduceActivity;
        });
    }
}

