/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.GoogleBigQueryV2AuthenticationType;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GoogleBigQueryV2LinkedService
extends LinkedService {
    private String type = "GoogleBigQueryV2";
    private Object projectId;
    private GoogleBigQueryV2AuthenticationType authenticationType;
    private Object clientId;
    private SecretBase clientSecret;
    private SecretBase refreshToken;
    private SecretBase keyFileContent;
    private String encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getProjectId() {
        return this.projectId;
    }

    public GoogleBigQueryV2LinkedService setProjectId(Object projectId) {
        this.projectId = projectId;
        return this;
    }

    public GoogleBigQueryV2AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public GoogleBigQueryV2LinkedService setAuthenticationType(GoogleBigQueryV2AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public GoogleBigQueryV2LinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase getClientSecret() {
        return this.clientSecret;
    }

    public GoogleBigQueryV2LinkedService setClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public SecretBase getRefreshToken() {
        return this.refreshToken;
    }

    public GoogleBigQueryV2LinkedService setRefreshToken(SecretBase refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public SecretBase getKeyFileContent() {
        return this.keyFileContent;
    }

    public GoogleBigQueryV2LinkedService setKeyFileContent(SecretBase keyFileContent) {
        this.keyFileContent = keyFileContent;
        return this;
    }

    public String getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public GoogleBigQueryV2LinkedService setEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public GoogleBigQueryV2LinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public GoogleBigQueryV2LinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public GoogleBigQueryV2LinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public GoogleBigQueryV2LinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public GoogleBigQueryV2LinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.projectId != null || this.authenticationType != null || this.clientId != null || this.clientSecret != null || this.refreshToken != null || this.keyFileContent != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("projectId", this.projectId);
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.clientId != null) {
                jsonWriter.writeUntypedField("clientId", this.clientId);
            }
            jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
            jsonWriter.writeJsonField("refreshToken", (JsonSerializable)this.refreshToken);
            jsonWriter.writeJsonField("keyFileContent", (JsonSerializable)this.keyFileContent);
            jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GoogleBigQueryV2LinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleBigQueryV2LinkedService)jsonReader.readObject(reader -> {
            GoogleBigQueryV2LinkedService deserializedGoogleBigQueryV2LinkedService = new GoogleBigQueryV2LinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedGoogleBigQueryV2LinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedGoogleBigQueryV2LinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGoogleBigQueryV2LinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedGoogleBigQueryV2LinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedGoogleBigQueryV2LinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGoogleBigQueryV2LinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("projectId".equals(fieldName)) {
                            deserializedGoogleBigQueryV2LinkedService.projectId = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedGoogleBigQueryV2LinkedService.authenticationType = GoogleBigQueryV2AuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedGoogleBigQueryV2LinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("clientSecret".equals(fieldName)) {
                            deserializedGoogleBigQueryV2LinkedService.clientSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("refreshToken".equals(fieldName)) {
                            deserializedGoogleBigQueryV2LinkedService.refreshToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("keyFileContent".equals(fieldName)) {
                            deserializedGoogleBigQueryV2LinkedService.keyFileContent = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedGoogleBigQueryV2LinkedService.encryptedCredential = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGoogleBigQueryV2LinkedService.setAdditionalProperties(additionalProperties);
            return deserializedGoogleBigQueryV2LinkedService;
        });
    }
}

