/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ExpressionType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Expression
implements JsonSerializable<Expression> {
    private ExpressionType type;
    private String value;

    public ExpressionType getType() {
        return this.type;
    }

    public Expression setType(ExpressionType type) {
        this.type = type;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Expression setValue(String value) {
        this.value = value;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static Expression fromJson(JsonReader jsonReader) throws IOException {
        return (Expression)jsonReader.readObject(reader -> {
            Expression deserializedExpression = new Expression();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedExpression.type = ExpressionType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedExpression.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpression;
        });
    }
}

