/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DynamicsAXLinkedService
extends LinkedService {
    private String type = "DynamicsAX";
    private Object url;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object aadResourceId;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getUrl() {
        return this.url;
    }

    public DynamicsAXLinkedService setUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public DynamicsAXLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public DynamicsAXLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public DynamicsAXLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getAadResourceId() {
        return this.aadResourceId;
    }

    public DynamicsAXLinkedService setAadResourceId(Object aadResourceId) {
        this.aadResourceId = aadResourceId;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public DynamicsAXLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public DynamicsAXLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public DynamicsAXLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public DynamicsAXLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public DynamicsAXLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public DynamicsAXLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.url != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.tenant != null || this.aadResourceId != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("url", this.url);
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            jsonWriter.writeUntypedField("tenant", this.tenant);
            jsonWriter.writeUntypedField("aadResourceId", this.aadResourceId);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DynamicsAXLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (DynamicsAXLinkedService)jsonReader.readObject(reader -> {
            DynamicsAXLinkedService deserializedDynamicsAXLinkedService = new DynamicsAXLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedDynamicsAXLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedDynamicsAXLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDynamicsAXLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedDynamicsAXLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedDynamicsAXLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDynamicsAXLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("url".equals(fieldName)) {
                            deserializedDynamicsAXLinkedService.url = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedDynamicsAXLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedDynamicsAXLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedDynamicsAXLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("aadResourceId".equals(fieldName)) {
                            deserializedDynamicsAXLinkedService.aadResourceId = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedDynamicsAXLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDynamicsAXLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedDynamicsAXLinkedService;
        });
    }
}

