/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DatabricksSparkJarActivity
extends ExecutionActivity {
    private String type = "DatabricksSparkJar";
    private Object mainClassName;
    private List<Object> parameters;
    private List<Map<String, Object>> libraries;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getMainClassName() {
        return this.mainClassName;
    }

    public DatabricksSparkJarActivity setMainClassName(Object mainClassName) {
        this.mainClassName = mainClassName;
        return this;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public DatabricksSparkJarActivity setParameters(List<Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<Map<String, Object>> getLibraries() {
        return this.libraries;
    }

    public DatabricksSparkJarActivity setLibraries(List<Map<String, Object>> libraries) {
        this.libraries = libraries;
        return this;
    }

    @Override
    public DatabricksSparkJarActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public DatabricksSparkJarActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public DatabricksSparkJarActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public DatabricksSparkJarActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public DatabricksSparkJarActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public DatabricksSparkJarActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public DatabricksSparkJarActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public DatabricksSparkJarActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.mainClassName != null || this.parameters != null || this.libraries != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("mainClassName", this.mainClassName);
            jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeArrayField("libraries", this.libraries, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeUntyped(element1)));
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DatabricksSparkJarActivity fromJson(JsonReader jsonReader) throws IOException {
        return (DatabricksSparkJarActivity)jsonReader.readObject(reader -> {
            DatabricksSparkJarActivity deserializedDatabricksSparkJarActivity = new DatabricksSparkJarActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDatabricksSparkJarActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDatabricksSparkJarActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDatabricksSparkJarActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedDatabricksSparkJarActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedDatabricksSparkJarActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedDatabricksSparkJarActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedDatabricksSparkJarActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedDatabricksSparkJarActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDatabricksSparkJarActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("mainClassName".equals(fieldName)) {
                            deserializedDatabricksSparkJarActivity.mainClassName = reader.readUntyped();
                            continue;
                        }
                        if ("parameters".equals(fieldName)) {
                            List parameters;
                            deserializedDatabricksSparkJarActivity.parameters = parameters = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("libraries".equals(fieldName)) {
                            List libraries;
                            deserializedDatabricksSparkJarActivity.libraries = libraries = reader.readArray(reader1 -> reader1.readMap(reader2 -> reader2.readUntyped()));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDatabricksSparkJarActivity.setAdditionalProperties(additionalProperties);
            return deserializedDatabricksSparkJarActivity;
        });
    }
}

