/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DataFlowReference;
import com.azure.analytics.synapse.artifacts.models.DatasetReference;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.Transformation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DataFlowSource
extends Transformation {
    private LinkedServiceReference schemaLinkedService;

    public LinkedServiceReference getSchemaLinkedService() {
        return this.schemaLinkedService;
    }

    public DataFlowSource setSchemaLinkedService(LinkedServiceReference schemaLinkedService) {
        this.schemaLinkedService = schemaLinkedService;
        return this;
    }

    @Override
    public DataFlowSource setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public DataFlowSource setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public DataFlowSource setDataset(DatasetReference dataset) {
        super.setDataset(dataset);
        return this;
    }

    @Override
    public DataFlowSource setLinkedService(LinkedServiceReference linkedService) {
        super.setLinkedService(linkedService);
        return this;
    }

    @Override
    public DataFlowSource setFlowlet(DataFlowReference flowlet) {
        super.setFlowlet(flowlet);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.getDataset());
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.getLinkedService());
        jsonWriter.writeJsonField("flowlet", (JsonSerializable)this.getFlowlet());
        jsonWriter.writeJsonField("schemaLinkedService", (JsonSerializable)this.schemaLinkedService);
        return jsonWriter.writeEndObject();
    }

    public static DataFlowSource fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowSource)jsonReader.readObject(reader -> {
            DataFlowSource deserializedDataFlowSource = new DataFlowSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDataFlowSource.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDataFlowSource.setDescription(reader.getString());
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    deserializedDataFlowSource.setDataset(DatasetReference.fromJson(reader));
                    continue;
                }
                if ("linkedService".equals(fieldName)) {
                    deserializedDataFlowSource.setLinkedService(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("flowlet".equals(fieldName)) {
                    deserializedDataFlowSource.setFlowlet(DataFlowReference.fromJson(reader));
                    continue;
                }
                if ("schemaLinkedService".equals(fieldName)) {
                    deserializedDataFlowSource.schemaLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowSource;
        });
    }
}

