/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.MultiplePipelineTrigger;
import com.azure.analytics.synapse.artifacts.models.TriggerPipelineReference;
import com.azure.analytics.synapse.artifacts.models.TriggerRuntimeState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CustomEventsTrigger
extends MultiplePipelineTrigger {
    private String type = "CustomEventsTrigger";
    private String subjectBeginsWith;
    private String subjectEndsWith;
    private List<Object> events;
    private String scope;

    @Override
    public String getType() {
        return this.type;
    }

    public String getSubjectBeginsWith() {
        return this.subjectBeginsWith;
    }

    public CustomEventsTrigger setSubjectBeginsWith(String subjectBeginsWith) {
        this.subjectBeginsWith = subjectBeginsWith;
        return this;
    }

    public String getSubjectEndsWith() {
        return this.subjectEndsWith;
    }

    public CustomEventsTrigger setSubjectEndsWith(String subjectEndsWith) {
        this.subjectEndsWith = subjectEndsWith;
        return this;
    }

    public List<Object> getEvents() {
        return this.events;
    }

    public CustomEventsTrigger setEvents(List<Object> events) {
        this.events = events;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public CustomEventsTrigger setScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public CustomEventsTrigger setPipelines(List<TriggerPipelineReference> pipelines) {
        super.setPipelines(pipelines);
        return this;
    }

    @Override
    public CustomEventsTrigger setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CustomEventsTrigger setAnnotations(List<Object> annotations) {
        super.setAnnotations((List)annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("pipelines", this.getPipelines(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.subjectBeginsWith != null || this.subjectEndsWith != null || this.events != null || this.scope != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeStringField("subjectBeginsWith", this.subjectBeginsWith);
            jsonWriter.writeStringField("subjectEndsWith", this.subjectEndsWith);
            jsonWriter.writeArrayField("events", this.events, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeStringField("scope", this.scope);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CustomEventsTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (CustomEventsTrigger)jsonReader.readObject(reader -> {
            CustomEventsTrigger deserializedCustomEventsTrigger = new CustomEventsTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedCustomEventsTrigger.setDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedCustomEventsTrigger.setRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedCustomEventsTrigger.setAnnotations(annotations);
                    continue;
                }
                if ("pipelines".equals(fieldName)) {
                    List pipelines = reader.readArray(reader1 -> TriggerPipelineReference.fromJson(reader1));
                    deserializedCustomEventsTrigger.setPipelines(pipelines);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomEventsTrigger.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("subjectBeginsWith".equals(fieldName)) {
                            deserializedCustomEventsTrigger.subjectBeginsWith = reader.getString();
                            continue;
                        }
                        if ("subjectEndsWith".equals(fieldName)) {
                            deserializedCustomEventsTrigger.subjectEndsWith = reader.getString();
                            continue;
                        }
                        if ("events".equals(fieldName)) {
                            List events;
                            deserializedCustomEventsTrigger.events = events = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("scope".equals(fieldName)) {
                            deserializedCustomEventsTrigger.scope = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCustomEventsTrigger.setAdditionalProperties(additionalProperties);
            return deserializedCustomEventsTrigger;
        });
    }
}

