/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AutoPauseProperties;
import com.azure.analytics.synapse.artifacts.models.AutoScaleProperties;
import com.azure.analytics.synapse.artifacts.models.DynamicExecutorAllocation;
import com.azure.analytics.synapse.artifacts.models.LibraryInfo;
import com.azure.analytics.synapse.artifacts.models.LibraryRequirements;
import com.azure.analytics.synapse.artifacts.models.NodeSize;
import com.azure.analytics.synapse.artifacts.models.NodeSizeFamily;
import com.azure.analytics.synapse.artifacts.models.TrackedResource;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public class BigDataPoolResourceInfo
extends TrackedResource {
    private String provisioningState;
    private AutoScaleProperties autoScale;
    private OffsetDateTime creationDate;
    private AutoPauseProperties autoPause;
    private Boolean isComputeIsolationEnabled;
    private Boolean sessionLevelPackagesEnabled;
    private Integer cacheSize;
    private DynamicExecutorAllocation dynamicExecutorAllocation;
    private String sparkEventsFolder;
    private Integer nodeCount;
    private LibraryRequirements libraryRequirements;
    private List<LibraryInfo> customLibraries;
    private LibraryRequirements sparkConfigProperties;
    private String sparkVersion;
    private String defaultSparkLogFolder;
    private NodeSize nodeSize;
    private NodeSizeFamily nodeSizeFamily;
    private OffsetDateTime lastSucceededTimestamp;
    private String type;
    private String name;
    private String id;

    public String getProvisioningState() {
        return this.provisioningState;
    }

    public BigDataPoolResourceInfo setProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public AutoScaleProperties getAutoScale() {
        return this.autoScale;
    }

    public BigDataPoolResourceInfo setAutoScale(AutoScaleProperties autoScale) {
        this.autoScale = autoScale;
        return this;
    }

    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public BigDataPoolResourceInfo setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public AutoPauseProperties getAutoPause() {
        return this.autoPause;
    }

    public BigDataPoolResourceInfo setAutoPause(AutoPauseProperties autoPause) {
        this.autoPause = autoPause;
        return this;
    }

    public Boolean isComputeIsolationEnabled() {
        return this.isComputeIsolationEnabled;
    }

    public BigDataPoolResourceInfo setIsComputeIsolationEnabled(Boolean isComputeIsolationEnabled) {
        this.isComputeIsolationEnabled = isComputeIsolationEnabled;
        return this;
    }

    public Boolean isSessionLevelPackagesEnabled() {
        return this.sessionLevelPackagesEnabled;
    }

    public BigDataPoolResourceInfo setSessionLevelPackagesEnabled(Boolean sessionLevelPackagesEnabled) {
        this.sessionLevelPackagesEnabled = sessionLevelPackagesEnabled;
        return this;
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public BigDataPoolResourceInfo setCacheSize(Integer cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public DynamicExecutorAllocation getDynamicExecutorAllocation() {
        return this.dynamicExecutorAllocation;
    }

    public BigDataPoolResourceInfo setDynamicExecutorAllocation(DynamicExecutorAllocation dynamicExecutorAllocation) {
        this.dynamicExecutorAllocation = dynamicExecutorAllocation;
        return this;
    }

    public String getSparkEventsFolder() {
        return this.sparkEventsFolder;
    }

    public BigDataPoolResourceInfo setSparkEventsFolder(String sparkEventsFolder) {
        this.sparkEventsFolder = sparkEventsFolder;
        return this;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public BigDataPoolResourceInfo setNodeCount(Integer nodeCount) {
        this.nodeCount = nodeCount;
        return this;
    }

    public LibraryRequirements getLibraryRequirements() {
        return this.libraryRequirements;
    }

    public BigDataPoolResourceInfo setLibraryRequirements(LibraryRequirements libraryRequirements) {
        this.libraryRequirements = libraryRequirements;
        return this;
    }

    public List<LibraryInfo> getCustomLibraries() {
        return this.customLibraries;
    }

    public BigDataPoolResourceInfo setCustomLibraries(List<LibraryInfo> customLibraries) {
        this.customLibraries = customLibraries;
        return this;
    }

    public LibraryRequirements getSparkConfigProperties() {
        return this.sparkConfigProperties;
    }

    public BigDataPoolResourceInfo setSparkConfigProperties(LibraryRequirements sparkConfigProperties) {
        this.sparkConfigProperties = sparkConfigProperties;
        return this;
    }

    public String getSparkVersion() {
        return this.sparkVersion;
    }

    public BigDataPoolResourceInfo setSparkVersion(String sparkVersion) {
        this.sparkVersion = sparkVersion;
        return this;
    }

    public String getDefaultSparkLogFolder() {
        return this.defaultSparkLogFolder;
    }

    public BigDataPoolResourceInfo setDefaultSparkLogFolder(String defaultSparkLogFolder) {
        this.defaultSparkLogFolder = defaultSparkLogFolder;
        return this;
    }

    public NodeSize getNodeSize() {
        return this.nodeSize;
    }

    public BigDataPoolResourceInfo setNodeSize(NodeSize nodeSize) {
        this.nodeSize = nodeSize;
        return this;
    }

    public NodeSizeFamily getNodeSizeFamily() {
        return this.nodeSizeFamily;
    }

    public BigDataPoolResourceInfo setNodeSizeFamily(NodeSizeFamily nodeSizeFamily) {
        this.nodeSizeFamily = nodeSizeFamily;
        return this;
    }

    public OffsetDateTime getLastSucceededTimestamp() {
        return this.lastSucceededTimestamp;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public BigDataPoolResourceInfo setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public BigDataPoolResourceInfo setLocation(String location) {
        super.setLocation(location);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.getLocation());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        if (this.provisioningState != null || this.autoScale != null || this.creationDate != null || this.autoPause != null || this.isComputeIsolationEnabled != null || this.sessionLevelPackagesEnabled != null || this.cacheSize != null || this.dynamicExecutorAllocation != null || this.sparkEventsFolder != null || this.nodeCount != null || this.libraryRequirements != null || this.customLibraries != null || this.sparkConfigProperties != null || this.sparkVersion != null || this.defaultSparkLogFolder != null || this.nodeSize != null || this.nodeSizeFamily != null || this.lastSucceededTimestamp != null) {
            jsonWriter.writeStartObject("properties");
            jsonWriter.writeStringField("provisioningState", this.provisioningState);
            jsonWriter.writeJsonField("autoScale", (JsonSerializable)this.autoScale);
            jsonWriter.writeStringField("creationDate", this.creationDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationDate));
            jsonWriter.writeJsonField("autoPause", (JsonSerializable)this.autoPause);
            jsonWriter.writeBooleanField("isComputeIsolationEnabled", this.isComputeIsolationEnabled);
            jsonWriter.writeBooleanField("sessionLevelPackagesEnabled", this.sessionLevelPackagesEnabled);
            jsonWriter.writeNumberField("cacheSize", (Number)this.cacheSize);
            jsonWriter.writeJsonField("dynamicExecutorAllocation", (JsonSerializable)this.dynamicExecutorAllocation);
            jsonWriter.writeStringField("sparkEventsFolder", this.sparkEventsFolder);
            jsonWriter.writeNumberField("nodeCount", (Number)this.nodeCount);
            jsonWriter.writeJsonField("libraryRequirements", (JsonSerializable)this.libraryRequirements);
            jsonWriter.writeArrayField("customLibraries", this.customLibraries, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeJsonField("sparkConfigProperties", (JsonSerializable)this.sparkConfigProperties);
            jsonWriter.writeStringField("sparkVersion", this.sparkVersion);
            jsonWriter.writeStringField("defaultSparkLogFolder", this.defaultSparkLogFolder);
            jsonWriter.writeStringField("nodeSize", this.nodeSize == null ? null : this.nodeSize.toString());
            jsonWriter.writeStringField("nodeSizeFamily", this.nodeSizeFamily == null ? null : this.nodeSizeFamily.toString());
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static BigDataPoolResourceInfo fromJson(JsonReader jsonReader) throws IOException {
        return (BigDataPoolResourceInfo)jsonReader.readObject(reader -> {
            BigDataPoolResourceInfo deserializedBigDataPoolResourceInfo = new BigDataPoolResourceInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedBigDataPoolResourceInfo.setLocation(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedBigDataPoolResourceInfo.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBigDataPoolResourceInfo.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBigDataPoolResourceInfo.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBigDataPoolResourceInfo.setTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("provisioningState".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.provisioningState = reader.getString();
                            continue;
                        }
                        if ("autoScale".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.autoScale = AutoScaleProperties.fromJson(reader);
                            continue;
                        }
                        if ("creationDate".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                            continue;
                        }
                        if ("autoPause".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.autoPause = AutoPauseProperties.fromJson(reader);
                            continue;
                        }
                        if ("isComputeIsolationEnabled".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.isComputeIsolationEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("sessionLevelPackagesEnabled".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.sessionLevelPackagesEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("cacheSize".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.cacheSize = (Integer)reader.getNullable(JsonReader::getInt);
                            continue;
                        }
                        if ("dynamicExecutorAllocation".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.dynamicExecutorAllocation = DynamicExecutorAllocation.fromJson(reader);
                            continue;
                        }
                        if ("sparkEventsFolder".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.sparkEventsFolder = reader.getString();
                            continue;
                        }
                        if ("nodeCount".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.nodeCount = (Integer)reader.getNullable(JsonReader::getInt);
                            continue;
                        }
                        if ("libraryRequirements".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.libraryRequirements = LibraryRequirements.fromJson(reader);
                            continue;
                        }
                        if ("customLibraries".equals(fieldName)) {
                            List customLibraries;
                            deserializedBigDataPoolResourceInfo.customLibraries = customLibraries = reader.readArray(reader1 -> LibraryInfo.fromJson(reader1));
                            continue;
                        }
                        if ("sparkConfigProperties".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.sparkConfigProperties = LibraryRequirements.fromJson(reader);
                            continue;
                        }
                        if ("sparkVersion".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.sparkVersion = reader.getString();
                            continue;
                        }
                        if ("defaultSparkLogFolder".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.defaultSparkLogFolder = reader.getString();
                            continue;
                        }
                        if ("nodeSize".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.nodeSize = NodeSize.fromString(reader.getString());
                            continue;
                        }
                        if ("nodeSizeFamily".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.nodeSizeFamily = NodeSizeFamily.fromString(reader.getString());
                            continue;
                        }
                        if ("lastSucceededTimestamp".equals(fieldName)) {
                            deserializedBigDataPoolResourceInfo.lastSucceededTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBigDataPoolResourceInfo;
        });
    }
}

