/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SqlPartitionSettings;
import com.azure.analytics.synapse.artifacts.models.TabularSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureSqlSource
extends TabularSource {
    private String type = "AzureSqlSource";
    private Object sqlReaderQuery;
    private Object sqlReaderStoredProcedureName;
    private Object storedProcedureParameters;
    private Object isolationLevel;
    private Object produceAdditionalTypes;
    private Object partitionOption;
    private SqlPartitionSettings partitionSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getSqlReaderQuery() {
        return this.sqlReaderQuery;
    }

    public AzureSqlSource setSqlReaderQuery(Object sqlReaderQuery) {
        this.sqlReaderQuery = sqlReaderQuery;
        return this;
    }

    public Object getSqlReaderStoredProcedureName() {
        return this.sqlReaderStoredProcedureName;
    }

    public AzureSqlSource setSqlReaderStoredProcedureName(Object sqlReaderStoredProcedureName) {
        this.sqlReaderStoredProcedureName = sqlReaderStoredProcedureName;
        return this;
    }

    public Object getStoredProcedureParameters() {
        return this.storedProcedureParameters;
    }

    public AzureSqlSource setStoredProcedureParameters(Object storedProcedureParameters) {
        this.storedProcedureParameters = storedProcedureParameters;
        return this;
    }

    public Object getIsolationLevel() {
        return this.isolationLevel;
    }

    public AzureSqlSource setIsolationLevel(Object isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public Object getProduceAdditionalTypes() {
        return this.produceAdditionalTypes;
    }

    public AzureSqlSource setProduceAdditionalTypes(Object produceAdditionalTypes) {
        this.produceAdditionalTypes = produceAdditionalTypes;
        return this;
    }

    public Object getPartitionOption() {
        return this.partitionOption;
    }

    public AzureSqlSource setPartitionOption(Object partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public SqlPartitionSettings getPartitionSettings() {
        return this.partitionSettings;
    }

    public AzureSqlSource setPartitionSettings(SqlPartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    @Override
    public AzureSqlSource setQueryTimeout(Object queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public AzureSqlSource setAdditionalColumns(Object additionalColumns) {
        super.setAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public AzureSqlSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AzureSqlSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AzureSqlSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getQueryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.getQueryTimeout());
        }
        if (this.getAdditionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.getAdditionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.sqlReaderQuery != null) {
            jsonWriter.writeUntypedField("sqlReaderQuery", this.sqlReaderQuery);
        }
        if (this.sqlReaderStoredProcedureName != null) {
            jsonWriter.writeUntypedField("sqlReaderStoredProcedureName", this.sqlReaderStoredProcedureName);
        }
        if (this.storedProcedureParameters != null) {
            jsonWriter.writeUntypedField("storedProcedureParameters", this.storedProcedureParameters);
        }
        if (this.isolationLevel != null) {
            jsonWriter.writeUntypedField("isolationLevel", this.isolationLevel);
        }
        if (this.produceAdditionalTypes != null) {
            jsonWriter.writeUntypedField("produceAdditionalTypes", this.produceAdditionalTypes);
        }
        if (this.partitionOption != null) {
            jsonWriter.writeUntypedField("partitionOption", this.partitionOption);
        }
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureSqlSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSqlSource)jsonReader.readObject(reader -> {
            AzureSqlSource deserializedAzureSqlSource = new AzureSqlSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAzureSqlSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAzureSqlSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureSqlSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedAzureSqlSource.setQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedAzureSqlSource.setAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureSqlSource.type = reader.getString();
                    continue;
                }
                if ("sqlReaderQuery".equals(fieldName)) {
                    deserializedAzureSqlSource.sqlReaderQuery = reader.readUntyped();
                    continue;
                }
                if ("sqlReaderStoredProcedureName".equals(fieldName)) {
                    deserializedAzureSqlSource.sqlReaderStoredProcedureName = reader.readUntyped();
                    continue;
                }
                if ("storedProcedureParameters".equals(fieldName)) {
                    deserializedAzureSqlSource.storedProcedureParameters = reader.readUntyped();
                    continue;
                }
                if ("isolationLevel".equals(fieldName)) {
                    deserializedAzureSqlSource.isolationLevel = reader.readUntyped();
                    continue;
                }
                if ("produceAdditionalTypes".equals(fieldName)) {
                    deserializedAzureSqlSource.produceAdditionalTypes = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedAzureSqlSource.partitionOption = reader.readUntyped();
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedAzureSqlSource.partitionSettings = SqlPartitionSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureSqlSource.setAdditionalProperties(additionalProperties);
            return deserializedAzureSqlSource;
        });
    }
}

