/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.AzureSqlDWAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.SqlServerBaseLinkedServiceTypeProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureSqlDWLinkedServiceTypeProperties
extends SqlServerBaseLinkedServiceTypeProperties {
    private Object connectionString;
    private AzureSqlDWAuthenticationType authenticationType;
    private Object userName;
    private AzureKeyVaultSecretReference password;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private Object tenant;
    private Object azureCloudType;
    private Object encryptedCredential;
    private CredentialReference credential;

    public Object getConnectionString() {
        return this.connectionString;
    }

    public AzureSqlDWLinkedServiceTypeProperties setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureSqlDWAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public AzureSqlDWLinkedServiceTypeProperties setAuthenticationType(AzureSqlDWAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public AzureSqlDWLinkedServiceTypeProperties setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public AzureKeyVaultSecretReference getPassword() {
        return this.password;
    }

    public AzureSqlDWLinkedServiceTypeProperties setPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureSqlDWLinkedServiceTypeProperties setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureSqlDWLinkedServiceTypeProperties setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getServicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public AzureSqlDWLinkedServiceTypeProperties setServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase getServicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public AzureSqlDWLinkedServiceTypeProperties setServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public AzureSqlDWLinkedServiceTypeProperties setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getAzureCloudType() {
        return this.azureCloudType;
    }

    public AzureSqlDWLinkedServiceTypeProperties setAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureSqlDWLinkedServiceTypeProperties setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureSqlDWLinkedServiceTypeProperties setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setServer(Object server) {
        super.setServer(server);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setDatabase(Object database) {
        super.setDatabase(database);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setEncrypt(Object encrypt) {
        super.setEncrypt(encrypt);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setTrustServerCertificate(Object trustServerCertificate) {
        super.setTrustServerCertificate(trustServerCertificate);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setHostNameInCertificate(Object hostNameInCertificate) {
        super.setHostNameInCertificate(hostNameInCertificate);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setApplicationIntent(Object applicationIntent) {
        super.setApplicationIntent(applicationIntent);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setConnectTimeout(Object connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setConnectRetryCount(Object connectRetryCount) {
        super.setConnectRetryCount(connectRetryCount);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setConnectRetryInterval(Object connectRetryInterval) {
        super.setConnectRetryInterval(connectRetryInterval);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setLoadBalanceTimeout(Object loadBalanceTimeout) {
        super.setLoadBalanceTimeout(loadBalanceTimeout);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setCommandTimeout(Object commandTimeout) {
        super.setCommandTimeout(commandTimeout);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setIntegratedSecurity(Object integratedSecurity) {
        super.setIntegratedSecurity(integratedSecurity);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setFailoverPartner(Object failoverPartner) {
        super.setFailoverPartner(failoverPartner);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setMaxPoolSize(Object maxPoolSize) {
        super.setMaxPoolSize(maxPoolSize);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setMinPoolSize(Object minPoolSize) {
        super.setMinPoolSize(minPoolSize);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setMultipleActiveResultSets(Object multipleActiveResultSets) {
        super.setMultipleActiveResultSets(multipleActiveResultSets);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setMultiSubnetFailover(Object multiSubnetFailover) {
        super.setMultiSubnetFailover(multiSubnetFailover);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setPacketSize(Object packetSize) {
        super.setPacketSize(packetSize);
        return this;
    }

    @Override
    public AzureSqlDWLinkedServiceTypeProperties setPooling(Object pooling) {
        super.setPooling(pooling);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getServer() != null) {
            jsonWriter.writeUntypedField("server", this.getServer());
        }
        if (this.getDatabase() != null) {
            jsonWriter.writeUntypedField("database", this.getDatabase());
        }
        if (this.getEncrypt() != null) {
            jsonWriter.writeUntypedField("encrypt", this.getEncrypt());
        }
        if (this.getTrustServerCertificate() != null) {
            jsonWriter.writeUntypedField("trustServerCertificate", this.getTrustServerCertificate());
        }
        if (this.getHostNameInCertificate() != null) {
            jsonWriter.writeUntypedField("hostNameInCertificate", this.getHostNameInCertificate());
        }
        if (this.getApplicationIntent() != null) {
            jsonWriter.writeUntypedField("applicationIntent", this.getApplicationIntent());
        }
        if (this.getConnectTimeout() != null) {
            jsonWriter.writeUntypedField("connectTimeout", this.getConnectTimeout());
        }
        if (this.getConnectRetryCount() != null) {
            jsonWriter.writeUntypedField("connectRetryCount", this.getConnectRetryCount());
        }
        if (this.getConnectRetryInterval() != null) {
            jsonWriter.writeUntypedField("connectRetryInterval", this.getConnectRetryInterval());
        }
        if (this.getLoadBalanceTimeout() != null) {
            jsonWriter.writeUntypedField("loadBalanceTimeout", this.getLoadBalanceTimeout());
        }
        if (this.getCommandTimeout() != null) {
            jsonWriter.writeUntypedField("commandTimeout", this.getCommandTimeout());
        }
        if (this.getIntegratedSecurity() != null) {
            jsonWriter.writeUntypedField("integratedSecurity", this.getIntegratedSecurity());
        }
        if (this.getFailoverPartner() != null) {
            jsonWriter.writeUntypedField("failoverPartner", this.getFailoverPartner());
        }
        if (this.getMaxPoolSize() != null) {
            jsonWriter.writeUntypedField("maxPoolSize", this.getMaxPoolSize());
        }
        if (this.getMinPoolSize() != null) {
            jsonWriter.writeUntypedField("minPoolSize", this.getMinPoolSize());
        }
        if (this.getMultipleActiveResultSets() != null) {
            jsonWriter.writeUntypedField("multipleActiveResultSets", this.getMultipleActiveResultSets());
        }
        if (this.getMultiSubnetFailover() != null) {
            jsonWriter.writeUntypedField("multiSubnetFailover", this.getMultiSubnetFailover());
        }
        if (this.getPacketSize() != null) {
            jsonWriter.writeUntypedField("packetSize", this.getPacketSize());
        }
        if (this.getPooling() != null) {
            jsonWriter.writeUntypedField("pooling", this.getPooling());
        }
        if (this.connectionString != null) {
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
        }
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.userName != null) {
            jsonWriter.writeUntypedField("userName", this.userName);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.servicePrincipalCredentialType != null) {
            jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        }
        jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
        if (this.tenant != null) {
            jsonWriter.writeUntypedField("tenant", this.tenant);
        }
        if (this.azureCloudType != null) {
            jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
        }
        if (this.encryptedCredential != null) {
            jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
        }
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static AzureSqlDWLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSqlDWLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureSqlDWLinkedServiceTypeProperties deserializedAzureSqlDWLinkedServiceTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setServer(reader.readUntyped());
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setDatabase(reader.readUntyped());
                    continue;
                }
                if ("encrypt".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setEncrypt(reader.readUntyped());
                    continue;
                }
                if ("trustServerCertificate".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setTrustServerCertificate(reader.readUntyped());
                    continue;
                }
                if ("hostNameInCertificate".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setHostNameInCertificate(reader.readUntyped());
                    continue;
                }
                if ("applicationIntent".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setApplicationIntent(reader.readUntyped());
                    continue;
                }
                if ("connectTimeout".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setConnectTimeout(reader.readUntyped());
                    continue;
                }
                if ("connectRetryCount".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setConnectRetryCount(reader.readUntyped());
                    continue;
                }
                if ("connectRetryInterval".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setConnectRetryInterval(reader.readUntyped());
                    continue;
                }
                if ("loadBalanceTimeout".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setLoadBalanceTimeout(reader.readUntyped());
                    continue;
                }
                if ("commandTimeout".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setCommandTimeout(reader.readUntyped());
                    continue;
                }
                if ("integratedSecurity".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setIntegratedSecurity(reader.readUntyped());
                    continue;
                }
                if ("failoverPartner".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setFailoverPartner(reader.readUntyped());
                    continue;
                }
                if ("maxPoolSize".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setMaxPoolSize(reader.readUntyped());
                    continue;
                }
                if ("minPoolSize".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setMinPoolSize(reader.readUntyped());
                    continue;
                }
                if ("multipleActiveResultSets".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setMultipleActiveResultSets(reader.readUntyped());
                    continue;
                }
                if ("multiSubnetFailover".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setMultiSubnetFailover(reader.readUntyped());
                    continue;
                }
                if ("packetSize".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setPacketSize(reader.readUntyped());
                    continue;
                }
                if ("pooling".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.setPooling(reader.readUntyped());
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.authenticationType = AzureSqlDWAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.userName = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.password = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredential".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.servicePrincipalCredential = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("azureCloudType".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.azureCloudType = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.encryptedCredential = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureSqlDWLinkedServiceTypeProperties;
        });
    }
}

