/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureDataLakeAnalyticsLinkedService
extends LinkedService {
    private String type = "AzureDataLakeAnalytics";
    private Object accountName;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object subscriptionId;
    private Object resourceGroupName;
    private Object dataLakeAnalyticsUri;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getAccountName() {
        return this.accountName;
    }

    public AzureDataLakeAnalyticsLinkedService setAccountName(Object accountName) {
        this.accountName = accountName;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureDataLakeAnalyticsLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureDataLakeAnalyticsLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public AzureDataLakeAnalyticsLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getSubscriptionId() {
        return this.subscriptionId;
    }

    public AzureDataLakeAnalyticsLinkedService setSubscriptionId(Object subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public Object getResourceGroupName() {
        return this.resourceGroupName;
    }

    public AzureDataLakeAnalyticsLinkedService setResourceGroupName(Object resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public Object getDataLakeAnalyticsUri() {
        return this.dataLakeAnalyticsUri;
    }

    public AzureDataLakeAnalyticsLinkedService setDataLakeAnalyticsUri(Object dataLakeAnalyticsUri) {
        this.dataLakeAnalyticsUri = dataLakeAnalyticsUri;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureDataLakeAnalyticsLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public AzureDataLakeAnalyticsLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureDataLakeAnalyticsLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureDataLakeAnalyticsLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureDataLakeAnalyticsLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureDataLakeAnalyticsLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.accountName != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.tenant != null || this.subscriptionId != null || this.resourceGroupName != null || this.dataLakeAnalyticsUri != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("accountName", this.accountName);
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            jsonWriter.writeUntypedField("tenant", this.tenant);
            if (this.subscriptionId != null) {
                jsonWriter.writeUntypedField("subscriptionId", this.subscriptionId);
            }
            if (this.resourceGroupName != null) {
                jsonWriter.writeUntypedField("resourceGroupName", this.resourceGroupName);
            }
            if (this.dataLakeAnalyticsUri != null) {
                jsonWriter.writeUntypedField("dataLakeAnalyticsUri", this.dataLakeAnalyticsUri);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDataLakeAnalyticsLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataLakeAnalyticsLinkedService)jsonReader.readObject(reader -> {
            AzureDataLakeAnalyticsLinkedService deserializedAzureDataLakeAnalyticsLinkedService = new AzureDataLakeAnalyticsLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureDataLakeAnalyticsLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureDataLakeAnalyticsLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("accountName".equals(fieldName)) {
                            deserializedAzureDataLakeAnalyticsLinkedService.accountName = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedAzureDataLakeAnalyticsLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedAzureDataLakeAnalyticsLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedAzureDataLakeAnalyticsLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("subscriptionId".equals(fieldName)) {
                            deserializedAzureDataLakeAnalyticsLinkedService.subscriptionId = reader.readUntyped();
                            continue;
                        }
                        if ("resourceGroupName".equals(fieldName)) {
                            deserializedAzureDataLakeAnalyticsLinkedService.resourceGroupName = reader.readUntyped();
                            continue;
                        }
                        if ("dataLakeAnalyticsUri".equals(fieldName)) {
                            deserializedAzureDataLakeAnalyticsLinkedService.dataLakeAnalyticsUri = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzureDataLakeAnalyticsLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDataLakeAnalyticsLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureDataLakeAnalyticsLinkedService;
        });
    }
}

