/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.ErrorContractException;
import com.azure.analytics.synapse.artifacts.models.KqlScriptResource;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class KqlScriptsOperationsImpl {
    private final KqlScriptsService service;
    private final ArtifactsClientImpl client;

    KqlScriptsOperationsImpl(ArtifactsClientImpl client) {
        this.service = (KqlScriptsService)RestProxy.create(KqlScriptsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KqlScriptResource>> createOrUpdateWithResponseAsync(String kqlScriptName, KqlScriptResource kqlScript) {
        return FluxUtil.withContext(context -> this.createOrUpdateWithResponseAsync(kqlScriptName, kqlScript, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KqlScriptResource>> createOrUpdateWithResponseAsync(String kqlScriptName, KqlScriptResource kqlScript, Context context) {
        String apiVersion = "2021-11-01-preview";
        String accept = "application/json";
        return this.service.createOrUpdate(this.client.getEndpoint(), kqlScriptName, "2021-11-01-preview", kqlScript, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KqlScriptResource> createOrUpdateAsync(String kqlScriptName, KqlScriptResource kqlScript) {
        return this.createOrUpdateWithResponseAsync(kqlScriptName, kqlScript).flatMap(res -> Mono.justOrEmpty((Object)((KqlScriptResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KqlScriptResource> createOrUpdateAsync(String kqlScriptName, KqlScriptResource kqlScript, Context context) {
        return this.createOrUpdateWithResponseAsync(kqlScriptName, kqlScript, context).flatMap(res -> Mono.justOrEmpty((Object)((KqlScriptResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KqlScriptResource> createOrUpdateWithResponse(String kqlScriptName, KqlScriptResource kqlScript, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(kqlScriptName, kqlScript, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KqlScriptResource createOrUpdate(String kqlScriptName, KqlScriptResource kqlScript) {
        return (KqlScriptResource)this.createOrUpdateWithResponse(kqlScriptName, kqlScript, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KqlScriptResource>> getByNameWithResponseAsync(String kqlScriptName) {
        return FluxUtil.withContext(context -> this.getByNameWithResponseAsync(kqlScriptName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KqlScriptResource>> getByNameWithResponseAsync(String kqlScriptName, Context context) {
        String apiVersion = "2021-11-01-preview";
        String accept = "application/json";
        return this.service.getByName(this.client.getEndpoint(), kqlScriptName, "2021-11-01-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KqlScriptResource> getByNameAsync(String kqlScriptName) {
        return this.getByNameWithResponseAsync(kqlScriptName).flatMap(res -> Mono.justOrEmpty((Object)((KqlScriptResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KqlScriptResource> getByNameAsync(String kqlScriptName, Context context) {
        return this.getByNameWithResponseAsync(kqlScriptName, context).flatMap(res -> Mono.justOrEmpty((Object)((KqlScriptResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KqlScriptResource> getByNameWithResponse(String kqlScriptName, Context context) {
        return (Response)this.getByNameWithResponseAsync(kqlScriptName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KqlScriptResource getByName(String kqlScriptName) {
        return (KqlScriptResource)this.getByNameWithResponse(kqlScriptName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteByNameWithResponseAsync(String kqlScriptName) {
        return FluxUtil.withContext(context -> this.deleteByNameWithResponseAsync(kqlScriptName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteByNameWithResponseAsync(String kqlScriptName, Context context) {
        String apiVersion = "2021-11-01-preview";
        String accept = "application/json";
        return this.service.deleteByName(this.client.getEndpoint(), kqlScriptName, "2021-11-01-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteByNameAsync(String kqlScriptName) {
        return this.deleteByNameWithResponseAsync(kqlScriptName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteByNameAsync(String kqlScriptName, Context context) {
        return this.deleteByNameWithResponseAsync(kqlScriptName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteByNameWithResponse(String kqlScriptName, Context context) {
        return (Response)this.deleteByNameWithResponseAsync(kqlScriptName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteByName(String kqlScriptName) {
        this.deleteByNameWithResponse(kqlScriptName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameWithResponseAsync(String kqlScriptName, ArtifactRenameRequest renameRequest) {
        return FluxUtil.withContext(context -> this.renameWithResponseAsync(kqlScriptName, renameRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameWithResponseAsync(String kqlScriptName, ArtifactRenameRequest renameRequest, Context context) {
        String apiVersion = "2021-11-01-preview";
        String accept = "application/json";
        return this.service.rename(this.client.getEndpoint(), kqlScriptName, "2021-11-01-preview", renameRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameAsync(String kqlScriptName, ArtifactRenameRequest renameRequest) {
        return this.renameWithResponseAsync(kqlScriptName, renameRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameAsync(String kqlScriptName, ArtifactRenameRequest renameRequest, Context context) {
        return this.renameWithResponseAsync(kqlScriptName, renameRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameWithResponse(String kqlScriptName, ArtifactRenameRequest renameRequest, Context context) {
        return (Response)this.renameWithResponseAsync(kqlScriptName, renameRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rename(String kqlScriptName, ArtifactRenameRequest renameRequest) {
        this.renameWithResponse(kqlScriptName, renameRequest, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientKqlScriptsOperations")
    public static interface KqlScriptsService {
        @Put(value="/kqlScripts/{kqlScriptName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<KqlScriptResource>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="kqlScriptName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") KqlScriptResource var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/kqlScripts/{kqlScriptName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<KqlScriptResource>> getByName(@HostParam(value="endpoint") String var1, @PathParam(value="kqlScriptName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/kqlScripts/{kqlScriptName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<Void>> deleteByName(@HostParam(value="endpoint") String var1, @PathParam(value="kqlScriptName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/kqlScripts/{kqlScriptName}/rename")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<Void>> rename(@HostParam(value="endpoint") String var1, @PathParam(value="kqlScriptName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ArtifactRenameRequest var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

