/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.TriggersImpl;
import com.azure.analytics.synapse.artifacts.models.TriggerResource;
import com.azure.analytics.synapse.artifacts.models.TriggerSubscriptionOperationStatus;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class TriggerClient {
    private final TriggersImpl serviceClient;

    TriggerClient(TriggersImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TriggerResource> getTriggersByWorkspace() {
        return this.serviceClient.getTriggersByWorkspace();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TriggerResource> getTriggersByWorkspace(Context context) {
        return this.serviceClient.getTriggersByWorkspace(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerResource> createOrUpdateTriggerWithResponse(String triggerName, TriggerResource trigger, String ifMatch, Context context) {
        return this.serviceClient.createOrUpdateTriggerWithResponse(triggerName, trigger, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerResource createOrUpdateTrigger(String triggerName, TriggerResource trigger, String ifMatch) {
        return this.serviceClient.createOrUpdateTrigger(triggerName, trigger, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerResource createOrUpdateTrigger(String triggerName, TriggerResource trigger) {
        return this.serviceClient.createOrUpdateTrigger(triggerName, trigger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerResource> getTriggerWithResponse(String triggerName, String ifNoneMatch, Context context) {
        return this.serviceClient.getTriggerWithResponse(triggerName, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerResource getTrigger(String triggerName, String ifNoneMatch) {
        return this.serviceClient.getTrigger(triggerName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerResource getTrigger(String triggerName) {
        return this.serviceClient.getTrigger(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTriggerWithResponse(String triggerName, Context context) {
        return this.serviceClient.deleteTriggerWithResponse(triggerName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTrigger(String triggerName) {
        this.serviceClient.deleteTrigger(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerSubscriptionOperationStatus> subscribeTriggerToEventsWithResponse(String triggerName, Context context) {
        return this.serviceClient.subscribeTriggerToEventsWithResponse(triggerName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerSubscriptionOperationStatus subscribeTriggerToEvents(String triggerName) {
        return this.serviceClient.subscribeTriggerToEvents(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerSubscriptionOperationStatus> getEventSubscriptionStatusWithResponse(String triggerName, Context context) {
        return this.serviceClient.getEventSubscriptionStatusWithResponse(triggerName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerSubscriptionOperationStatus getEventSubscriptionStatus(String triggerName) {
        return this.serviceClient.getEventSubscriptionStatus(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerSubscriptionOperationStatus> unsubscribeTriggerFromEventsWithResponse(String triggerName, Context context) {
        return this.serviceClient.unsubscribeTriggerFromEventsWithResponse(triggerName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerSubscriptionOperationStatus unsubscribeTriggerFromEvents(String triggerName) {
        return this.serviceClient.unsubscribeTriggerFromEvents(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startTriggerWithResponse(String triggerName, Context context) {
        return this.serviceClient.startTriggerWithResponse(triggerName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startTrigger(String triggerName) {
        this.serviceClient.startTrigger(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopTriggerWithResponse(String triggerName, Context context) {
        return this.serviceClient.stopTriggerWithResponse(triggerName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopTrigger(String triggerName) {
        this.serviceClient.stopTrigger(triggerName);
    }
}

