/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.TriggersImpl;
import com.azure.analytics.synapse.artifacts.models.TriggerResource;
import com.azure.analytics.synapse.artifacts.models.TriggerSubscriptionOperationStatus;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class TriggerAsyncClient {
    private final TriggersImpl serviceClient;

    TriggerAsyncClient(TriggersImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TriggerResource> getTriggersByWorkspace() {
        return this.serviceClient.getTriggersByWorkspaceAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerResource>> createOrUpdateTriggerWithResponse(String triggerName, TriggerResource trigger, String ifMatch) {
        return this.serviceClient.createOrUpdateTriggerWithResponseAsync(triggerName, trigger, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerResource> createOrUpdateTrigger(String triggerName, TriggerResource trigger, String ifMatch) {
        return this.serviceClient.createOrUpdateTriggerAsync(triggerName, trigger, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerResource> createOrUpdateTrigger(String triggerName, TriggerResource trigger) {
        return this.serviceClient.createOrUpdateTriggerAsync(triggerName, trigger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerResource>> getTriggerWithResponse(String triggerName, String ifNoneMatch) {
        return this.serviceClient.getTriggerWithResponseAsync(triggerName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerResource> getTrigger(String triggerName, String ifNoneMatch) {
        return this.serviceClient.getTriggerAsync(triggerName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerResource> getTrigger(String triggerName) {
        return this.serviceClient.getTriggerAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTriggerWithResponse(String triggerName) {
        return this.serviceClient.deleteTriggerWithResponseAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTrigger(String triggerName) {
        return this.serviceClient.deleteTriggerAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerSubscriptionOperationStatus>> subscribeTriggerToEventsWithResponse(String triggerName) {
        return this.serviceClient.subscribeTriggerToEventsWithResponseAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerSubscriptionOperationStatus> subscribeTriggerToEvents(String triggerName) {
        return this.serviceClient.subscribeTriggerToEventsAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerSubscriptionOperationStatus>> getEventSubscriptionStatusWithResponse(String triggerName) {
        return this.serviceClient.getEventSubscriptionStatusWithResponseAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerSubscriptionOperationStatus> getEventSubscriptionStatus(String triggerName) {
        return this.serviceClient.getEventSubscriptionStatusAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerSubscriptionOperationStatus>> unsubscribeTriggerFromEventsWithResponse(String triggerName) {
        return this.serviceClient.unsubscribeTriggerFromEventsWithResponseAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerSubscriptionOperationStatus> unsubscribeTriggerFromEvents(String triggerName) {
        return this.serviceClient.unsubscribeTriggerFromEventsAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startTriggerWithResponse(String triggerName) {
        return this.serviceClient.startTriggerWithResponseAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startTrigger(String triggerName) {
        return this.serviceClient.startTriggerAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopTriggerWithResponse(String triggerName) {
        return this.serviceClient.stopTriggerWithResponseAsync(triggerName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopTrigger(String triggerName) {
        return this.serviceClient.stopTriggerAsync(triggerName);
    }
}

