/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.SparkConfigurationsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.SparkConfigurationResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class SparkConfigurationAsyncClient {
    private final SparkConfigurationsImpl serviceClient;

    SparkConfigurationAsyncClient(SparkConfigurationsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SparkConfigurationResource> getSparkConfigurationsByWorkspace() {
        return this.serviceClient.getSparkConfigurationsByWorkspaceAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkConfigurationResource>> createOrUpdateSparkConfigurationWithResponse(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration, String ifMatch) {
        return this.serviceClient.createOrUpdateSparkConfigurationWithResponseAsync(sparkConfigurationName, sparkConfiguration, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkConfigurationResource> createOrUpdateSparkConfiguration(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration, String ifMatch) {
        return this.serviceClient.createOrUpdateSparkConfigurationAsync(sparkConfigurationName, sparkConfiguration, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkConfigurationResource> createOrUpdateSparkConfiguration(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration) {
        return this.serviceClient.createOrUpdateSparkConfigurationAsync(sparkConfigurationName, sparkConfiguration);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkConfigurationResource>> getSparkConfigurationWithResponse(String sparkConfigurationName, String ifNoneMatch) {
        return this.serviceClient.getSparkConfigurationWithResponseAsync(sparkConfigurationName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkConfigurationResource> getSparkConfiguration(String sparkConfigurationName, String ifNoneMatch) {
        return this.serviceClient.getSparkConfigurationAsync(sparkConfigurationName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkConfigurationResource> getSparkConfiguration(String sparkConfigurationName) {
        return this.serviceClient.getSparkConfigurationAsync(sparkConfigurationName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSparkConfigurationWithResponse(String sparkConfigurationName) {
        return this.serviceClient.deleteSparkConfigurationWithResponseAsync(sparkConfigurationName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSparkConfiguration(String sparkConfigurationName) {
        return this.serviceClient.deleteSparkConfigurationAsync(sparkConfigurationName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameSparkConfigurationWithResponse(String sparkConfigurationName, ArtifactRenameRequest request) {
        return this.serviceClient.renameSparkConfigurationWithResponseAsync(sparkConfigurationName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameSparkConfiguration(String sparkConfigurationName, ArtifactRenameRequest request) {
        return this.serviceClient.renameSparkConfigurationAsync(sparkConfigurationName, request);
    }
}

