/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.RunNotebooksImpl;
import com.azure.analytics.synapse.artifacts.models.RunNotebookRequest;
import com.azure.analytics.synapse.artifacts.models.RunNotebookResponse;
import com.azure.analytics.synapse.artifacts.models.RunNotebookSnapshotResponse;
import com.azure.analytics.synapse.artifacts.models.RunNotebooksCreateRunHeaders;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class RunNotebookClient {
    private final RunNotebooksImpl serviceClient;

    RunNotebookClient(RunNotebooksImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<RunNotebooksCreateRunHeaders, RunNotebookResponse> createRunWithResponse(String runId, RunNotebookRequest runNotebookRequest, Context context) {
        return this.serviceClient.createRunWithResponse(runId, runNotebookRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunNotebookResponse createRun(String runId, RunNotebookRequest runNotebookRequest) {
        return this.serviceClient.createRun(runId, runNotebookRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunNotebookResponse> createRunNoCustomHeadersWithResponse(String runId, RunNotebookRequest runNotebookRequest, Context context) {
        return this.serviceClient.createRunNoCustomHeadersWithResponse(runId, runNotebookRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunNotebookResponse> getStatusWithResponse(String runId, Context context) {
        return this.serviceClient.getStatusWithResponse(runId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunNotebookResponse getStatus(String runId) {
        return this.serviceClient.getStatus(runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunNotebookResponse> cancelRunWithResponse(String runId, Context context) {
        return this.serviceClient.cancelRunWithResponse(runId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunNotebookResponse cancelRun(String runId) {
        return this.serviceClient.cancelRun(runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunNotebookSnapshotResponse> getSnapshotWithResponse(String runId, Context context) {
        return this.serviceClient.getSnapshotWithResponse(runId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunNotebookSnapshotResponse getSnapshot(String runId) {
        return this.serviceClient.getSnapshot(runId);
    }
}

