/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SuggestOptions
implements JsonSerializable<SuggestOptions> {
    private String keywords;
    private Integer limit;
    private BinaryData filter;

    public String getKeywords() {
        return this.keywords;
    }

    public SuggestOptions setKeywords(String keywords) {
        this.keywords = keywords;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SuggestOptions setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public BinaryData getFilter() {
        return this.filter;
    }

    public SuggestOptions setFilter(BinaryData filter) {
        this.filter = filter;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keywords", this.keywords);
        jsonWriter.writeNumberField("limit", (Number)this.limit);
        if (this.filter != null) {
            jsonWriter.writeFieldName("filter");
            this.filter.writeTo(jsonWriter);
        }
        return jsonWriter.writeEndObject();
    }

    public static SuggestOptions fromJson(JsonReader jsonReader) throws IOException {
        return (SuggestOptions)jsonReader.readObject(reader -> {
            SuggestOptions deserializedSuggestOptions = new SuggestOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keywords".equals(fieldName)) {
                    deserializedSuggestOptions.keywords = reader.getString();
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedSuggestOptions.limit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedSuggestOptions.filter = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSuggestOptions;
        });
    }
}

