/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.analytics.purview.datamap.models.SearchFacetResultValue;
import com.azure.analytics.purview.datamap.models.SearchResultValue;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class QueryResult
implements JsonSerializable<QueryResult> {
    private Integer searchCount;
    private Boolean searchCountApproximate;
    private String continuationToken;
    private SearchFacetResultValue searchFacets;
    private List<SearchResultValue> value;

    private QueryResult() {
    }

    public Integer getSearchCount() {
        return this.searchCount;
    }

    public Boolean isSearchCountApproximate() {
        return this.searchCountApproximate;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public SearchFacetResultValue getSearchFacets() {
        return this.searchFacets;
    }

    public List<SearchResultValue> getValue() {
        return this.value;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("@search.count", (Number)this.searchCount);
        jsonWriter.writeBooleanField("@search.count.approximate", this.searchCountApproximate);
        jsonWriter.writeStringField("continuationToken", this.continuationToken);
        jsonWriter.writeJsonField("@search.facets", (JsonSerializable)this.searchFacets);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static QueryResult fromJson(JsonReader jsonReader) throws IOException {
        return (QueryResult)jsonReader.readObject(reader -> {
            QueryResult deserializedQueryResult = new QueryResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@search.count".equals(fieldName)) {
                    deserializedQueryResult.searchCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("@search.count.approximate".equals(fieldName)) {
                    deserializedQueryResult.searchCountApproximate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("continuationToken".equals(fieldName)) {
                    deserializedQueryResult.continuationToken = reader.getString();
                    continue;
                }
                if ("@search.facets".equals(fieldName)) {
                    deserializedQueryResult.searchFacets = SearchFacetResultValue.fromJson(reader);
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedQueryResult.value = value = reader.readArray(reader1 -> SearchResultValue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryResult;
        });
    }
}

