/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.analytics.purview.datamap.models.AtlasEntityHeader;
import com.azure.analytics.purview.datamap.models.LineageDirection;
import com.azure.analytics.purview.datamap.models.LineageRelation;
import com.azure.analytics.purview.datamap.models.ParentRelation;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AtlasLineageInfo
implements JsonSerializable<AtlasLineageInfo> {
    private String baseEntityGuid;
    private Map<String, AtlasEntityHeader> guidEntityMap;
    private Map<String, Map<String, BinaryData>> widthCounts;
    private Integer lineageDepth;
    private Integer lineageWidth;
    private Integer childrenCount;
    private LineageDirection lineageDirection;
    private List<ParentRelation> parentRelations;
    private List<LineageRelation> relations;

    private AtlasLineageInfo() {
    }

    public String getBaseEntityGuid() {
        return this.baseEntityGuid;
    }

    public Map<String, AtlasEntityHeader> getGuidEntityMap() {
        return this.guidEntityMap;
    }

    public Map<String, Map<String, BinaryData>> getWidthCounts() {
        return this.widthCounts;
    }

    public Integer getLineageDepth() {
        return this.lineageDepth;
    }

    public Integer getLineageWidth() {
        return this.lineageWidth;
    }

    public Integer getChildrenCount() {
        return this.childrenCount;
    }

    public LineageDirection getLineageDirection() {
        return this.lineageDirection;
    }

    public List<ParentRelation> getParentRelations() {
        return this.parentRelations;
    }

    public List<LineageRelation> getRelations() {
        return this.relations;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("baseEntityGuid", this.baseEntityGuid);
        jsonWriter.writeMapField("guidEntityMap", this.guidEntityMap, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("widthCounts", this.widthCounts, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeUntyped(element1 == null ? null : element1.toObject(Object.class))));
        jsonWriter.writeNumberField("lineageDepth", (Number)this.lineageDepth);
        jsonWriter.writeNumberField("lineageWidth", (Number)this.lineageWidth);
        jsonWriter.writeNumberField("childrenCount", (Number)this.childrenCount);
        jsonWriter.writeStringField("lineageDirection", this.lineageDirection == null ? null : this.lineageDirection.toString());
        jsonWriter.writeArrayField("parentRelations", this.parentRelations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("relations", this.relations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AtlasLineageInfo fromJson(JsonReader jsonReader) throws IOException {
        return (AtlasLineageInfo)jsonReader.readObject(reader -> {
            AtlasLineageInfo deserializedAtlasLineageInfo = new AtlasLineageInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("baseEntityGuid".equals(fieldName)) {
                    deserializedAtlasLineageInfo.baseEntityGuid = reader.getString();
                    continue;
                }
                if ("guidEntityMap".equals(fieldName)) {
                    Map guidEntityMap;
                    deserializedAtlasLineageInfo.guidEntityMap = guidEntityMap = reader.readMap(reader1 -> AtlasEntityHeader.fromJson(reader1));
                    continue;
                }
                if ("widthCounts".equals(fieldName)) {
                    Map widthCounts;
                    deserializedAtlasLineageInfo.widthCounts = widthCounts = reader.readMap(reader1 -> reader1.readMap(reader2 -> (BinaryData)reader2.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()))));
                    continue;
                }
                if ("lineageDepth".equals(fieldName)) {
                    deserializedAtlasLineageInfo.lineageDepth = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("lineageWidth".equals(fieldName)) {
                    deserializedAtlasLineageInfo.lineageWidth = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("childrenCount".equals(fieldName)) {
                    deserializedAtlasLineageInfo.childrenCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("lineageDirection".equals(fieldName)) {
                    deserializedAtlasLineageInfo.lineageDirection = LineageDirection.fromString(reader.getString());
                    continue;
                }
                if ("parentRelations".equals(fieldName)) {
                    List parentRelations;
                    deserializedAtlasLineageInfo.parentRelations = parentRelations = reader.readArray(reader1 -> ParentRelation.fromJson(reader1));
                    continue;
                }
                if ("relations".equals(fieldName)) {
                    List relations;
                    deserializedAtlasLineageInfo.relations = relations = reader.readArray(reader1 -> LineageRelation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAtlasLineageInfo;
        });
    }
}

