/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.analytics.purview.datamap.models.AtlasClassification;
import com.azure.analytics.purview.datamap.models.AtlasGlossaryHeader;
import com.azure.analytics.purview.datamap.models.AtlasRelatedObjectId;
import com.azure.analytics.purview.datamap.models.AtlasRelatedTermHeader;
import com.azure.analytics.purview.datamap.models.AtlasTermCategorizationHeader;
import com.azure.analytics.purview.datamap.models.ContactInfo;
import com.azure.analytics.purview.datamap.models.PurviewObjectId;
import com.azure.analytics.purview.datamap.models.ResourceLink;
import com.azure.analytics.purview.datamap.models.TermStatus;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AtlasGlossaryTerm
implements JsonSerializable<AtlasGlossaryTerm> {
    private String guid;
    private List<AtlasClassification> classifications;
    private String longDescription;
    private String name;
    private String qualifiedName;
    private String shortDescription;
    private String lastModifiedTS;
    private Long createTime;
    private String createdBy;
    private Long updateTime;
    private String updatedBy;
    private String abbreviation;
    private List<BinaryData> templateName;
    private AtlasGlossaryHeader anchor;
    private List<AtlasRelatedTermHeader> antonyms;
    private TermStatus status;
    private String nickName;
    private List<PurviewObjectId> hierarchyInfo;
    private List<ResourceLink> resources;
    private Map<String, List<ContactInfo>> contacts;
    private Map<String, Map<String, BinaryData>> attributes;
    private List<AtlasRelatedObjectId> assignedEntities;
    private List<AtlasTermCategorizationHeader> categories;
    private List<AtlasRelatedTermHeader> classifies;
    private List<String> examples;
    private List<AtlasRelatedTermHeader> isA;
    private List<AtlasRelatedTermHeader> preferredTerms;
    private List<AtlasRelatedTermHeader> preferredToTerms;
    private List<AtlasRelatedTermHeader> replacedBy;
    private List<AtlasRelatedTermHeader> replacementTerms;
    private List<AtlasRelatedTermHeader> seeAlso;
    private List<AtlasRelatedTermHeader> synonyms;
    private List<AtlasRelatedTermHeader> translatedTerms;
    private List<AtlasRelatedTermHeader> translationTerms;
    private String usage;
    private List<AtlasRelatedTermHeader> validValues;
    private List<AtlasRelatedTermHeader> validValuesFor;

    public String getGuid() {
        return this.guid;
    }

    public AtlasGlossaryTerm setGuid(String guid) {
        this.guid = guid;
        return this;
    }

    public List<AtlasClassification> getClassifications() {
        return this.classifications;
    }

    public AtlasGlossaryTerm setClassifications(List<AtlasClassification> classifications) {
        this.classifications = classifications;
        return this;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public AtlasGlossaryTerm setLongDescription(String longDescription) {
        this.longDescription = longDescription;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public AtlasGlossaryTerm setName(String name) {
        this.name = name;
        return this;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public AtlasGlossaryTerm setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
        return this;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public AtlasGlossaryTerm setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
        return this;
    }

    public String getLastModifiedTS() {
        return this.lastModifiedTS;
    }

    public AtlasGlossaryTerm setLastModifiedTS(String lastModifiedTS) {
        this.lastModifiedTS = lastModifiedTS;
        return this;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public AtlasGlossaryTerm setCreateTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public AtlasGlossaryTerm setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public AtlasGlossaryTerm setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public AtlasGlossaryTerm setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public AtlasGlossaryTerm setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
        return this;
    }

    public List<BinaryData> getTemplateName() {
        return this.templateName;
    }

    public AtlasGlossaryTerm setTemplateName(List<BinaryData> templateName) {
        this.templateName = templateName;
        return this;
    }

    public AtlasGlossaryHeader getAnchor() {
        return this.anchor;
    }

    public AtlasGlossaryTerm setAnchor(AtlasGlossaryHeader anchor) {
        this.anchor = anchor;
        return this;
    }

    public List<AtlasRelatedTermHeader> getAntonyms() {
        return this.antonyms;
    }

    public AtlasGlossaryTerm setAntonyms(List<AtlasRelatedTermHeader> antonyms) {
        this.antonyms = antonyms;
        return this;
    }

    public TermStatus getStatus() {
        return this.status;
    }

    public AtlasGlossaryTerm setStatus(TermStatus status) {
        this.status = status;
        return this;
    }

    public String getNickName() {
        return this.nickName;
    }

    public AtlasGlossaryTerm setNickName(String nickName) {
        this.nickName = nickName;
        return this;
    }

    public List<PurviewObjectId> getHierarchyInfo() {
        return this.hierarchyInfo;
    }

    public AtlasGlossaryTerm setHierarchyInfo(List<PurviewObjectId> hierarchyInfo) {
        this.hierarchyInfo = hierarchyInfo;
        return this;
    }

    public List<ResourceLink> getResources() {
        return this.resources;
    }

    public AtlasGlossaryTerm setResources(List<ResourceLink> resources) {
        this.resources = resources;
        return this;
    }

    public Map<String, List<ContactInfo>> getContacts() {
        return this.contacts;
    }

    public AtlasGlossaryTerm setContacts(Map<String, List<ContactInfo>> contacts) {
        this.contacts = contacts;
        return this;
    }

    public Map<String, Map<String, BinaryData>> getAttributes() {
        return this.attributes;
    }

    public AtlasGlossaryTerm setAttributes(Map<String, Map<String, BinaryData>> attributes) {
        this.attributes = attributes;
        return this;
    }

    public List<AtlasRelatedObjectId> getAssignedEntities() {
        return this.assignedEntities;
    }

    public AtlasGlossaryTerm setAssignedEntities(List<AtlasRelatedObjectId> assignedEntities) {
        this.assignedEntities = assignedEntities;
        return this;
    }

    public List<AtlasTermCategorizationHeader> getCategories() {
        return this.categories;
    }

    public AtlasGlossaryTerm setCategories(List<AtlasTermCategorizationHeader> categories) {
        this.categories = categories;
        return this;
    }

    public List<AtlasRelatedTermHeader> getClassifies() {
        return this.classifies;
    }

    public AtlasGlossaryTerm setClassifies(List<AtlasRelatedTermHeader> classifies) {
        this.classifies = classifies;
        return this;
    }

    public List<String> getExamples() {
        return this.examples;
    }

    public AtlasGlossaryTerm setExamples(List<String> examples) {
        this.examples = examples;
        return this;
    }

    public List<AtlasRelatedTermHeader> getIsA() {
        return this.isA;
    }

    public AtlasGlossaryTerm setIsA(List<AtlasRelatedTermHeader> isA) {
        this.isA = isA;
        return this;
    }

    public List<AtlasRelatedTermHeader> getPreferredTerms() {
        return this.preferredTerms;
    }

    public AtlasGlossaryTerm setPreferredTerms(List<AtlasRelatedTermHeader> preferredTerms) {
        this.preferredTerms = preferredTerms;
        return this;
    }

    public List<AtlasRelatedTermHeader> getPreferredToTerms() {
        return this.preferredToTerms;
    }

    public AtlasGlossaryTerm setPreferredToTerms(List<AtlasRelatedTermHeader> preferredToTerms) {
        this.preferredToTerms = preferredToTerms;
        return this;
    }

    public List<AtlasRelatedTermHeader> getReplacedBy() {
        return this.replacedBy;
    }

    public AtlasGlossaryTerm setReplacedBy(List<AtlasRelatedTermHeader> replacedBy) {
        this.replacedBy = replacedBy;
        return this;
    }

    public List<AtlasRelatedTermHeader> getReplacementTerms() {
        return this.replacementTerms;
    }

    public AtlasGlossaryTerm setReplacementTerms(List<AtlasRelatedTermHeader> replacementTerms) {
        this.replacementTerms = replacementTerms;
        return this;
    }

    public List<AtlasRelatedTermHeader> getSeeAlso() {
        return this.seeAlso;
    }

    public AtlasGlossaryTerm setSeeAlso(List<AtlasRelatedTermHeader> seeAlso) {
        this.seeAlso = seeAlso;
        return this;
    }

    public List<AtlasRelatedTermHeader> getSynonyms() {
        return this.synonyms;
    }

    public AtlasGlossaryTerm setSynonyms(List<AtlasRelatedTermHeader> synonyms) {
        this.synonyms = synonyms;
        return this;
    }

    public List<AtlasRelatedTermHeader> getTranslatedTerms() {
        return this.translatedTerms;
    }

    public AtlasGlossaryTerm setTranslatedTerms(List<AtlasRelatedTermHeader> translatedTerms) {
        this.translatedTerms = translatedTerms;
        return this;
    }

    public List<AtlasRelatedTermHeader> getTranslationTerms() {
        return this.translationTerms;
    }

    public AtlasGlossaryTerm setTranslationTerms(List<AtlasRelatedTermHeader> translationTerms) {
        this.translationTerms = translationTerms;
        return this;
    }

    public String getUsage() {
        return this.usage;
    }

    public AtlasGlossaryTerm setUsage(String usage) {
        this.usage = usage;
        return this;
    }

    public List<AtlasRelatedTermHeader> getValidValues() {
        return this.validValues;
    }

    public AtlasGlossaryTerm setValidValues(List<AtlasRelatedTermHeader> validValues) {
        this.validValues = validValues;
        return this;
    }

    public List<AtlasRelatedTermHeader> getValidValuesFor() {
        return this.validValuesFor;
    }

    public AtlasGlossaryTerm setValidValuesFor(List<AtlasRelatedTermHeader> validValuesFor) {
        this.validValuesFor = validValuesFor;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("guid", this.guid);
        jsonWriter.writeArrayField("classifications", this.classifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("longDescription", this.longDescription);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("qualifiedName", this.qualifiedName);
        jsonWriter.writeStringField("shortDescription", this.shortDescription);
        jsonWriter.writeStringField("lastModifiedTS", this.lastModifiedTS);
        jsonWriter.writeNumberField("createTime", (Number)this.createTime);
        jsonWriter.writeStringField("createdBy", this.createdBy);
        jsonWriter.writeNumberField("updateTime", (Number)this.updateTime);
        jsonWriter.writeStringField("updatedBy", this.updatedBy);
        jsonWriter.writeStringField("abbreviation", this.abbreviation);
        jsonWriter.writeArrayField("templateName", this.templateName, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeJsonField("anchor", (JsonSerializable)this.anchor);
        jsonWriter.writeArrayField("antonyms", this.antonyms, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("nickName", this.nickName);
        jsonWriter.writeArrayField("hierarchyInfo", this.hierarchyInfo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("contacts", this.contacts, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
        jsonWriter.writeMapField("attributes", this.attributes, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeUntyped(element1 == null ? null : element1.toObject(Object.class))));
        jsonWriter.writeArrayField("assignedEntities", this.assignedEntities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("categories", this.categories, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("classifies", this.classifies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("examples", this.examples, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("isA", this.isA, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("preferredTerms", this.preferredTerms, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("preferredToTerms", this.preferredToTerms, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("replacedBy", this.replacedBy, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("replacementTerms", this.replacementTerms, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("seeAlso", this.seeAlso, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("synonyms", this.synonyms, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("translatedTerms", this.translatedTerms, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("translationTerms", this.translationTerms, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("usage", this.usage);
        jsonWriter.writeArrayField("validValues", this.validValues, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("validValuesFor", this.validValuesFor, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AtlasGlossaryTerm fromJson(JsonReader jsonReader) throws IOException {
        return (AtlasGlossaryTerm)jsonReader.readObject(reader -> {
            AtlasGlossaryTerm deserializedAtlasGlossaryTerm = new AtlasGlossaryTerm();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("guid".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.guid = reader.getString();
                    continue;
                }
                if ("classifications".equals(fieldName)) {
                    List classifications;
                    deserializedAtlasGlossaryTerm.classifications = classifications = reader.readArray(reader1 -> AtlasClassification.fromJson(reader1));
                    continue;
                }
                if ("longDescription".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.longDescription = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.name = reader.getString();
                    continue;
                }
                if ("qualifiedName".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.qualifiedName = reader.getString();
                    continue;
                }
                if ("shortDescription".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.shortDescription = reader.getString();
                    continue;
                }
                if ("lastModifiedTS".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.lastModifiedTS = reader.getString();
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.createTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.createdBy = reader.getString();
                    continue;
                }
                if ("updateTime".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.updateTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updatedBy".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.updatedBy = reader.getString();
                    continue;
                }
                if ("abbreviation".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.abbreviation = reader.getString();
                    continue;
                }
                if ("templateName".equals(fieldName)) {
                    List templateName;
                    deserializedAtlasGlossaryTerm.templateName = templateName = reader.readArray(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("anchor".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.anchor = AtlasGlossaryHeader.fromJson(reader);
                    continue;
                }
                if ("antonyms".equals(fieldName)) {
                    List antonyms;
                    deserializedAtlasGlossaryTerm.antonyms = antonyms = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.status = TermStatus.fromString(reader.getString());
                    continue;
                }
                if ("nickName".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.nickName = reader.getString();
                    continue;
                }
                if ("hierarchyInfo".equals(fieldName)) {
                    List hierarchyInfo;
                    deserializedAtlasGlossaryTerm.hierarchyInfo = hierarchyInfo = reader.readArray(reader1 -> PurviewObjectId.fromJson(reader1));
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    List resources;
                    deserializedAtlasGlossaryTerm.resources = resources = reader.readArray(reader1 -> ResourceLink.fromJson(reader1));
                    continue;
                }
                if ("contacts".equals(fieldName)) {
                    Map contacts;
                    deserializedAtlasGlossaryTerm.contacts = contacts = reader.readMap(reader1 -> reader1.readArray(reader2 -> ContactInfo.fromJson(reader2)));
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    Map attributes;
                    deserializedAtlasGlossaryTerm.attributes = attributes = reader.readMap(reader1 -> reader1.readMap(reader2 -> (BinaryData)reader2.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()))));
                    continue;
                }
                if ("assignedEntities".equals(fieldName)) {
                    List assignedEntities;
                    deserializedAtlasGlossaryTerm.assignedEntities = assignedEntities = reader.readArray(reader1 -> AtlasRelatedObjectId.fromJson(reader1));
                    continue;
                }
                if ("categories".equals(fieldName)) {
                    List categories;
                    deserializedAtlasGlossaryTerm.categories = categories = reader.readArray(reader1 -> AtlasTermCategorizationHeader.fromJson(reader1));
                    continue;
                }
                if ("classifies".equals(fieldName)) {
                    List classifies;
                    deserializedAtlasGlossaryTerm.classifies = classifies = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("examples".equals(fieldName)) {
                    List examples;
                    deserializedAtlasGlossaryTerm.examples = examples = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isA".equals(fieldName)) {
                    List isA;
                    deserializedAtlasGlossaryTerm.isA = isA = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("preferredTerms".equals(fieldName)) {
                    List preferredTerms;
                    deserializedAtlasGlossaryTerm.preferredTerms = preferredTerms = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("preferredToTerms".equals(fieldName)) {
                    List preferredToTerms;
                    deserializedAtlasGlossaryTerm.preferredToTerms = preferredToTerms = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("replacedBy".equals(fieldName)) {
                    List replacedBy;
                    deserializedAtlasGlossaryTerm.replacedBy = replacedBy = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("replacementTerms".equals(fieldName)) {
                    List replacementTerms;
                    deserializedAtlasGlossaryTerm.replacementTerms = replacementTerms = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("seeAlso".equals(fieldName)) {
                    List seeAlso;
                    deserializedAtlasGlossaryTerm.seeAlso = seeAlso = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("synonyms".equals(fieldName)) {
                    List synonyms;
                    deserializedAtlasGlossaryTerm.synonyms = synonyms = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("translatedTerms".equals(fieldName)) {
                    List translatedTerms;
                    deserializedAtlasGlossaryTerm.translatedTerms = translatedTerms = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("translationTerms".equals(fieldName)) {
                    List translationTerms;
                    deserializedAtlasGlossaryTerm.translationTerms = translationTerms = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    deserializedAtlasGlossaryTerm.usage = reader.getString();
                    continue;
                }
                if ("validValues".equals(fieldName)) {
                    List validValues;
                    deserializedAtlasGlossaryTerm.validValues = validValues = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("validValuesFor".equals(fieldName)) {
                    List validValuesFor;
                    deserializedAtlasGlossaryTerm.validValuesFor = validValuesFor = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAtlasGlossaryTerm;
        });
    }
}

