/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.analytics.purview.datamap.models.AtlasClassification;
import com.azure.analytics.purview.datamap.models.AtlasTermAssignmentHeader;
import com.azure.analytics.purview.datamap.models.EntityStatus;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AtlasEntityHeader
implements JsonSerializable<AtlasEntityHeader> {
    private Map<String, BinaryData> attributes;
    private String typeName;
    private String lastModifiedTS;
    private List<String> classificationNames;
    private List<AtlasClassification> classifications;
    private String displayText;
    private String guid;
    private Boolean isIncomplete;
    private List<String> labels;
    private List<String> meaningNames;
    private List<AtlasTermAssignmentHeader> meanings;
    private EntityStatus status;

    public Map<String, BinaryData> getAttributes() {
        return this.attributes;
    }

    public AtlasEntityHeader setAttributes(Map<String, BinaryData> attributes) {
        this.attributes = attributes;
        return this;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public AtlasEntityHeader setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String getLastModifiedTS() {
        return this.lastModifiedTS;
    }

    public AtlasEntityHeader setLastModifiedTS(String lastModifiedTS) {
        this.lastModifiedTS = lastModifiedTS;
        return this;
    }

    public List<String> getClassificationNames() {
        return this.classificationNames;
    }

    public AtlasEntityHeader setClassificationNames(List<String> classificationNames) {
        this.classificationNames = classificationNames;
        return this;
    }

    public List<AtlasClassification> getClassifications() {
        return this.classifications;
    }

    public AtlasEntityHeader setClassifications(List<AtlasClassification> classifications) {
        this.classifications = classifications;
        return this;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public AtlasEntityHeader setDisplayText(String displayText) {
        this.displayText = displayText;
        return this;
    }

    public String getGuid() {
        return this.guid;
    }

    public AtlasEntityHeader setGuid(String guid) {
        this.guid = guid;
        return this;
    }

    public Boolean isIncomplete() {
        return this.isIncomplete;
    }

    public AtlasEntityHeader setIsIncomplete(Boolean isIncomplete) {
        this.isIncomplete = isIncomplete;
        return this;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public AtlasEntityHeader setLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public List<String> getMeaningNames() {
        return this.meaningNames;
    }

    public AtlasEntityHeader setMeaningNames(List<String> meaningNames) {
        this.meaningNames = meaningNames;
        return this;
    }

    public List<AtlasTermAssignmentHeader> getMeanings() {
        return this.meanings;
    }

    public AtlasEntityHeader setMeanings(List<AtlasTermAssignmentHeader> meanings) {
        this.meanings = meanings;
        return this;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public AtlasEntityHeader setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("attributes", this.attributes, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("lastModifiedTS", this.lastModifiedTS);
        jsonWriter.writeArrayField("classificationNames", this.classificationNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("classifications", this.classifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("displayText", this.displayText);
        jsonWriter.writeStringField("guid", this.guid);
        jsonWriter.writeBooleanField("isIncomplete", this.isIncomplete);
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("meaningNames", this.meaningNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("meanings", this.meanings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static AtlasEntityHeader fromJson(JsonReader jsonReader) throws IOException {
        return (AtlasEntityHeader)jsonReader.readObject(reader -> {
            AtlasEntityHeader deserializedAtlasEntityHeader = new AtlasEntityHeader();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("attributes".equals(fieldName)) {
                    Map attributes;
                    deserializedAtlasEntityHeader.attributes = attributes = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("typeName".equals(fieldName)) {
                    deserializedAtlasEntityHeader.typeName = reader.getString();
                    continue;
                }
                if ("lastModifiedTS".equals(fieldName)) {
                    deserializedAtlasEntityHeader.lastModifiedTS = reader.getString();
                    continue;
                }
                if ("classificationNames".equals(fieldName)) {
                    List classificationNames;
                    deserializedAtlasEntityHeader.classificationNames = classificationNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("classifications".equals(fieldName)) {
                    List classifications;
                    deserializedAtlasEntityHeader.classifications = classifications = reader.readArray(reader1 -> AtlasClassification.fromJson(reader1));
                    continue;
                }
                if ("displayText".equals(fieldName)) {
                    deserializedAtlasEntityHeader.displayText = reader.getString();
                    continue;
                }
                if ("guid".equals(fieldName)) {
                    deserializedAtlasEntityHeader.guid = reader.getString();
                    continue;
                }
                if ("isIncomplete".equals(fieldName)) {
                    deserializedAtlasEntityHeader.isIncomplete = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    List labels;
                    deserializedAtlasEntityHeader.labels = labels = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("meaningNames".equals(fieldName)) {
                    List meaningNames;
                    deserializedAtlasEntityHeader.meaningNames = meaningNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("meanings".equals(fieldName)) {
                    List meanings;
                    deserializedAtlasEntityHeader.meanings = meanings = reader.readArray(reader1 -> AtlasTermAssignmentHeader.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAtlasEntityHeader.status = EntityStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAtlasEntityHeader;
        });
    }
}

