/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.implementation;

import com.azure.analytics.purview.datamap.PurviewDataMapServiceVersion;
import com.azure.analytics.purview.datamap.implementation.DataMapClientImpl;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class EntitiesImpl {
    private final EntitiesService service;
    private final DataMapClientImpl client;

    EntitiesImpl(DataMapClientImpl client) {
        this.service = (EntitiesService)RestProxy.create(EntitiesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public PurviewDataMapServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateWithResponseAsync(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateWithResponse(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getByIdsWithResponseAsync(List<String> guid, RequestOptions requestOptions) {
        String accept = "application/json";
        List guidConverted = guid.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return FluxUtil.withContext(context -> this.service.getByIds(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), guidConverted, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getByIdsWithResponse(List<String> guid, RequestOptions requestOptions) {
        String accept = "application/json";
        List<String> guidConverted = guid.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return this.service.getByIdsSync(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), guidConverted, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> batchCreateOrUpdateWithResponseAsync(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.batchCreateOrUpdate(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> batchCreateOrUpdateWithResponse(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.batchCreateOrUpdateSync(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> batchDeleteWithResponseAsync(List<String> guid, RequestOptions requestOptions) {
        String accept = "application/json";
        List guidConverted = guid.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return FluxUtil.withContext(context -> this.service.batchDelete(this.client.getEndpoint(), guidConverted, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> batchDeleteWithResponse(List<String> guid, RequestOptions requestOptions) {
        String accept = "application/json";
        List<String> guidConverted = guid.stream().map(item -> Objects.toString(item, "")).collect(Collectors.toList());
        return this.service.batchDeleteSync(this.client.getEndpoint(), guidConverted, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addClassificationWithResponseAsync(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addClassification(this.client.getEndpoint(), "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addClassificationWithResponse(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.addClassificationSync(this.client.getEndpoint(), "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getWithResponseAsync(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), guid, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getWithResponse(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), guid, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateAttributeByIdWithResponseAsync(String guid, String name, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAttributeById(this.client.getEndpoint(), guid, name, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateAttributeByIdWithResponse(String guid, String name, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateAttributeByIdSync(this.client.getEndpoint(), guid, name, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteWithResponseAsync(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), guid, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteWithResponse(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), guid, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getClassificationWithResponseAsync(String guid, String classificationName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getClassification(this.client.getEndpoint(), guid, classificationName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getClassificationWithResponse(String guid, String classificationName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getClassificationSync(this.client.getEndpoint(), guid, classificationName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeClassificationWithResponseAsync(String guid, String classificationName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeClassification(this.client.getEndpoint(), guid, classificationName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeClassificationWithResponse(String guid, String classificationName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.removeClassificationSync(this.client.getEndpoint(), guid, classificationName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getClassificationsWithResponseAsync(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getClassifications(this.client.getEndpoint(), guid, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getClassificationsWithResponse(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getClassificationsSync(this.client.getEndpoint(), guid, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addClassificationsWithResponseAsync(String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addClassifications(this.client.getEndpoint(), guid, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addClassificationsWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.addClassificationsSync(this.client.getEndpoint(), guid, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateClassificationsWithResponseAsync(String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateClassifications(this.client.getEndpoint(), guid, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateClassificationsWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateClassificationsSync(this.client.getEndpoint(), guid, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getByUniqueAttributeWithResponseAsync(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByUniqueAttribute(this.client.getEndpoint(), typeName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getByUniqueAttributeSync(this.client.getEndpoint(), typeName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateByUniqueAttributeWithResponseAsync(String typeName, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateByUniqueAttribute(this.client.getEndpoint(), typeName, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateByUniqueAttributeWithResponse(String typeName, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateByUniqueAttributeSync(this.client.getEndpoint(), typeName, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteByUniqueAttributeWithResponseAsync(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteByUniqueAttribute(this.client.getEndpoint(), typeName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteByUniqueAttributeSync(this.client.getEndpoint(), typeName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeClassificationByUniqueAttributeWithResponseAsync(String typeName, String classificationName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeClassificationByUniqueAttribute(this.client.getEndpoint(), typeName, classificationName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeClassificationByUniqueAttributeWithResponse(String typeName, String classificationName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.removeClassificationByUniqueAttributeSync(this.client.getEndpoint(), typeName, classificationName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addClassificationsByUniqueAttributeWithResponseAsync(String typeName, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addClassificationsByUniqueAttribute(this.client.getEndpoint(), typeName, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addClassificationsByUniqueAttributeWithResponse(String typeName, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.addClassificationsByUniqueAttributeSync(this.client.getEndpoint(), typeName, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateClassificationsUniqueByAttributeWithResponseAsync(String typeName, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateClassificationsUniqueByAttribute(this.client.getEndpoint(), typeName, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateClassificationsUniqueByAttributeWithResponse(String typeName, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateClassificationsUniqueByAttributeSync(this.client.getEndpoint(), typeName, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> batchSetClassificationsWithResponseAsync(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.batchSetClassifications(this.client.getEndpoint(), "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> batchSetClassificationsWithResponse(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.batchSetClassificationsSync(this.client.getEndpoint(), "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> batchGetByUniqueAttributesWithResponseAsync(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.batchGetByUniqueAttributes(this.client.getEndpoint(), typeName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> batchGetByUniqueAttributesWithResponse(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.batchGetByUniqueAttributesSync(this.client.getEndpoint(), typeName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getHeaderWithResponseAsync(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getHeader(this.client.getEndpoint(), guid, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getHeaderWithResponse(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getHeaderSync(this.client.getEndpoint(), guid, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeBusinessMetadataWithResponseAsync(String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeBusinessMetadata(this.client.getEndpoint(), guid, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeBusinessMetadataWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.removeBusinessMetadataSync(this.client.getEndpoint(), guid, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addOrUpdateBusinessMetadataWithResponseAsync(String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addOrUpdateBusinessMetadata(this.client.getEndpoint(), guid, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addOrUpdateBusinessMetadataWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.addOrUpdateBusinessMetadataSync(this.client.getEndpoint(), guid, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeBusinessMetadataAttributesWithResponseAsync(String businessMetadataName, String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeBusinessMetadataAttributes(this.client.getEndpoint(), businessMetadataName, guid, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeBusinessMetadataAttributesWithResponse(String businessMetadataName, String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.removeBusinessMetadataAttributesSync(this.client.getEndpoint(), businessMetadataName, guid, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addOrUpdateBusinessMetadataAttributesWithResponseAsync(String businessMetadataName, String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addOrUpdateBusinessMetadataAttributes(this.client.getEndpoint(), businessMetadataName, guid, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addOrUpdateBusinessMetadataAttributesWithResponse(String businessMetadataName, String guid, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.addOrUpdateBusinessMetadataAttributesSync(this.client.getEndpoint(), businessMetadataName, guid, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getBusinessMetadataTemplateWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/octet-stream";
        return FluxUtil.withContext(context -> this.service.getBusinessMetadataTemplate(this.client.getEndpoint(), "application/octet-stream", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getBusinessMetadataTemplateWithResponse(RequestOptions requestOptions) {
        String accept = "application/octet-stream";
        return this.service.getBusinessMetadataTemplateSync(this.client.getEndpoint(), "application/octet-stream", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> importBusinessMetadataWithResponseAsync(BinaryData body, RequestOptions requestOptions) {
        String contentType = "multipart/form-data";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.importBusinessMetadata(this.client.getEndpoint(), "multipart/form-data", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> importBusinessMetadataWithResponse(BinaryData body, RequestOptions requestOptions) {
        String contentType = "multipart/form-data";
        String accept = "application/json";
        return this.service.importBusinessMetadataSync(this.client.getEndpoint(), "multipart/form-data", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeLabelsWithResponseAsync(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return FluxUtil.withContext(context -> this.service.removeLabels(this.client.getEndpoint(), guid, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeLabelsWithResponse(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return this.service.removeLabelsSync(this.client.getEndpoint(), guid, "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setLabelsWithResponseAsync(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return FluxUtil.withContext(context -> this.service.setLabels(this.client.getEndpoint(), guid, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setLabelsWithResponse(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return this.service.setLabelsSync(this.client.getEndpoint(), guid, "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addLabelWithResponseAsync(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return FluxUtil.withContext(context -> this.service.addLabel(this.client.getEndpoint(), guid, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addLabelWithResponse(String guid, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return this.service.addLabelSync(this.client.getEndpoint(), guid, "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeLabelsByUniqueAttributeWithResponseAsync(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return FluxUtil.withContext(context -> this.service.removeLabelsByUniqueAttribute(this.client.getEndpoint(), typeName, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeLabelsByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return this.service.removeLabelsByUniqueAttributeSync(this.client.getEndpoint(), typeName, "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setLabelsByUniqueAttributeWithResponseAsync(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return FluxUtil.withContext(context -> this.service.setLabelsByUniqueAttribute(this.client.getEndpoint(), typeName, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setLabelsByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return this.service.setLabelsByUniqueAttributeSync(this.client.getEndpoint(), typeName, "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addLabelsByUniqueAttributeWithResponseAsync(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return FluxUtil.withContext(context -> this.service.addLabelsByUniqueAttribute(this.client.getEndpoint(), typeName, "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addLabelsByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return this.service.addLabelsByUniqueAttributeSync(this.client.getEndpoint(), typeName, "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> moveEntitiesToCollectionWithResponseAsync(String collectionId, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.moveEntitiesToCollection(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), collectionId, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> moveEntitiesToCollectionWithResponse(String collectionId, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.moveEntitiesToCollectionSync(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), collectionId, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @Host(value="{endpoint}/datamap/api")
    @ServiceInterface(name="DataMapClientEntitie")
    public static interface EntitiesService {
        @Post(value="/atlas/v2/entity")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/atlas/v2/entity")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/atlas/v2/entity/bulk")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getByIds(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="guid", multipleQueryParams=true) List<String> var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/atlas/v2/entity/bulk")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getByIdsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="guid", multipleQueryParams=true) List<String> var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/atlas/v2/entity/bulk")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> batchCreateOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/atlas/v2/entity/bulk")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> batchCreateOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Delete(value="/atlas/v2/entity/bulk")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> batchDelete(@HostParam(value="endpoint") String var1, @QueryParam(value="guid", multipleQueryParams=true) List<String> var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/atlas/v2/entity/bulk")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> batchDeleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="guid", multipleQueryParams=true) List<String> var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/atlas/v2/entity/bulk/classification")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> addClassification(@HostParam(value="endpoint") String var1, @HeaderParam(value="Content-Type") String var2, @HeaderParam(value="Accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/atlas/v2/entity/bulk/classification")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> addClassificationSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="Content-Type") String var2, @HeaderParam(value="Accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Get(value="/atlas/v2/entity/guid/{guid}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> get(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/atlas/v2/entity/guid/{guid}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Put(value="/atlas/v2/entity/guid/{guid}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> updateAttributeById(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @QueryParam(value="name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Put(value="/atlas/v2/entity/guid/{guid}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> updateAttributeByIdSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @QueryParam(value="name") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Delete(value="/atlas/v2/entity/guid/{guid}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/atlas/v2/entity/guid/{guid}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/atlas/v2/entity/guid/{guid}/classification/{classificationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getClassification(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @PathParam(value="classificationName") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/atlas/v2/entity/guid/{guid}/classification/{classificationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getClassificationSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @PathParam(value="classificationName") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/atlas/v2/entity/guid/{guid}/classification/{classificationName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeClassification(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @PathParam(value="classificationName") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/atlas/v2/entity/guid/{guid}/classification/{classificationName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeClassificationSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @PathParam(value="classificationName") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/atlas/v2/entity/guid/{guid}/classifications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getClassifications(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/atlas/v2/entity/guid/{guid}/classifications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getClassificationsSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/atlas/v2/entity/guid/{guid}/classifications")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> addClassifications(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/atlas/v2/entity/guid/{guid}/classifications")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> addClassificationsSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Put(value="/atlas/v2/entity/guid/{guid}/classifications")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> updateClassifications(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Put(value="/atlas/v2/entity/guid/{guid}/classifications")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> updateClassificationsSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getByUniqueAttribute(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getByUniqueAttributeSync(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Put(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> updateByUniqueAttribute(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Put(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> updateByUniqueAttributeSync(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Delete(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> deleteByUniqueAttribute(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> deleteByUniqueAttributeSync(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/classification/{classificationName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeClassificationByUniqueAttribute(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @PathParam(value="classificationName") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/classification/{classificationName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeClassificationByUniqueAttributeSync(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @PathParam(value="classificationName") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Post(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/classifications")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> addClassificationsByUniqueAttribute(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/classifications")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> addClassificationsByUniqueAttributeSync(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Put(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/classifications")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> updateClassificationsUniqueByAttribute(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Put(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/classifications")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> updateClassificationsUniqueByAttributeSync(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/atlas/v2/entity/bulk/setClassifications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> batchSetClassifications(@HostParam(value="endpoint") String var1, @HeaderParam(value="Content-Type") String var2, @HeaderParam(value="Accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/atlas/v2/entity/bulk/setClassifications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> batchSetClassificationsSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="Content-Type") String var2, @HeaderParam(value="Accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Get(value="/atlas/v2/entity/bulk/uniqueAttribute/type/{typeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> batchGetByUniqueAttributes(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/atlas/v2/entity/bulk/uniqueAttribute/type/{typeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> batchGetByUniqueAttributesSync(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/atlas/v2/entity/guid/{guid}/header")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getHeader(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/atlas/v2/entity/guid/{guid}/header")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getHeaderSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/atlas/v2/entity/guid/{guid}/businessmetadata")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeBusinessMetadata(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Delete(value="/atlas/v2/entity/guid/{guid}/businessmetadata")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeBusinessMetadataSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/atlas/v2/entity/guid/{guid}/businessmetadata")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> addOrUpdateBusinessMetadata(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/atlas/v2/entity/guid/{guid}/businessmetadata")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> addOrUpdateBusinessMetadataSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Delete(value="/atlas/v2/entity/guid/{guid}/businessmetadata/{businessMetadataName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeBusinessMetadataAttributes(@HostParam(value="endpoint") String var1, @PathParam(value="businessMetadataName") String var2, @PathParam(value="guid") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Delete(value="/atlas/v2/entity/guid/{guid}/businessmetadata/{businessMetadataName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeBusinessMetadataAttributesSync(@HostParam(value="endpoint") String var1, @PathParam(value="businessMetadataName") String var2, @PathParam(value="guid") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/atlas/v2/entity/guid/{guid}/businessmetadata/{businessMetadataName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> addOrUpdateBusinessMetadataAttributes(@HostParam(value="endpoint") String var1, @PathParam(value="businessMetadataName") String var2, @PathParam(value="guid") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/atlas/v2/entity/guid/{guid}/businessmetadata/{businessMetadataName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> addOrUpdateBusinessMetadataAttributesSync(@HostParam(value="endpoint") String var1, @PathParam(value="businessMetadataName") String var2, @PathParam(value="guid") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Get(value="/atlas/v2/entity/businessmetadata/import/template")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getBusinessMetadataTemplate(@HostParam(value="endpoint") String var1, @HeaderParam(value="Accept") String var2, RequestOptions var3, Context var4);

        @Get(value="/atlas/v2/entity/businessmetadata/import/template")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getBusinessMetadataTemplateSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="Accept") String var2, RequestOptions var3, Context var4);

        @Post(value="/atlas/v2/entity/businessmetadata/import")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> importBusinessMetadata(@HostParam(value="endpoint") String var1, @HeaderParam(value="content-type") String var2, @HeaderParam(value="Accept") String var3, @BodyParam(value="multipart/form-data") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/atlas/v2/entity/businessmetadata/import")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> importBusinessMetadataSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="content-type") String var2, @HeaderParam(value="Accept") String var3, @BodyParam(value="multipart/form-data") BinaryData var4, RequestOptions var5, Context var6);

        @Delete(value="/atlas/v2/entity/guid/{guid}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeLabels(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/atlas/v2/entity/guid/{guid}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeLabelsSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/atlas/v2/entity/guid/{guid}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> setLabels(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/atlas/v2/entity/guid/{guid}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> setLabelsSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Put(value="/atlas/v2/entity/guid/{guid}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> addLabel(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Put(value="/atlas/v2/entity/guid/{guid}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> addLabelSync(@HostParam(value="endpoint") String var1, @PathParam(value="guid") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> removeLabelsByUniqueAttribute(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> removeLabelsByUniqueAttributeSync(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> setLabelsByUniqueAttribute(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> setLabelsByUniqueAttributeSync(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Put(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> addLabelsByUniqueAttribute(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Put(value="/atlas/v2/entity/uniqueAttribute/type/{typeName}/labels")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> addLabelsByUniqueAttributeSync(@HostParam(value="endpoint") String var1, @PathParam(value="typeName") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/entity/moveTo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> moveEntitiesToCollection(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="collectionId") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/entity/moveTo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> moveEntitiesToCollectionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="collectionId") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);
    }
}

