/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DataMapClientBuilder;
import com.azure.analytics.purview.datamap.implementation.TypeDefinitionsImpl;
import com.azure.analytics.purview.datamap.models.AtlasBusinessMetadataDef;
import com.azure.analytics.purview.datamap.models.AtlasClassificationDef;
import com.azure.analytics.purview.datamap.models.AtlasEntityDef;
import com.azure.analytics.purview.datamap.models.AtlasEnumDef;
import com.azure.analytics.purview.datamap.models.AtlasRelationshipDef;
import com.azure.analytics.purview.datamap.models.AtlasStructDef;
import com.azure.analytics.purview.datamap.models.AtlasTypeDef;
import com.azure.analytics.purview.datamap.models.AtlasTypeDefHeader;
import com.azure.analytics.purview.datamap.models.AtlasTypesDef;
import com.azure.analytics.purview.datamap.models.TermTemplateDef;
import com.azure.analytics.purview.datamap.models.TypeCategory;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.serializer.TypeReference;
import java.util.List;

@ServiceClient(builder=DataMapClientBuilder.class)
public final class TypeDefinitionClient {
    private final TypeDefinitionsImpl serviceClient;
    private static final TypeReference<List<AtlasTypeDefHeader>> TYPE_REFERENCE_LIST_ATLAS_TYPE_DEF_HEADER = new TypeReference<List<AtlasTypeDefHeader>>(){};

    TypeDefinitionClient(TypeDefinitionsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getBusinessMetadataByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getBusinessMetadataByIdWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getBusinessMetadataByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getBusinessMetadataByNameWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getClassificationByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getClassificationByIdWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getClassificationByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getClassificationByNameWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEntityByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getEntityByIdWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEntityByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getEntityByNameWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEnumByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getEnumByIdWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEnumByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getEnumByNameWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRelationshipByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getRelationshipByIdWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRelationshipByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getRelationshipByNameWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getStructByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getStructByIdWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getStructByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getStructByNameWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getByIdWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getByNameWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.deleteWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> batchCreateWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.batchCreateWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> batchUpdateWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.batchUpdateWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> batchDeleteWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.batchDeleteWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getHeadersWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getHeadersWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTermTemplateByIdWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getTermTemplateByIdWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTermTemplateByNameWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getTermTemplateByNameWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasBusinessMetadataDef getBusinessMetadataById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasBusinessMetadataDef)((BinaryData)this.getBusinessMetadataByIdWithResponse(guid, requestOptions).getValue()).toObject(AtlasBusinessMetadataDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasBusinessMetadataDef getBusinessMetadataByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasBusinessMetadataDef)((BinaryData)this.getBusinessMetadataByNameWithResponse(name, requestOptions).getValue()).toObject(AtlasBusinessMetadataDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasClassificationDef getClassificationById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasClassificationDef)((BinaryData)this.getClassificationByIdWithResponse(guid, requestOptions).getValue()).toObject(AtlasClassificationDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasClassificationDef getClassificationByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasClassificationDef)((BinaryData)this.getClassificationByNameWithResponse(name, requestOptions).getValue()).toObject(AtlasClassificationDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEntityDef getEntityById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasEntityDef)((BinaryData)this.getEntityByIdWithResponse(guid, requestOptions).getValue()).toObject(AtlasEntityDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEntityDef getEntityByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasEntityDef)((BinaryData)this.getEntityByNameWithResponse(name, requestOptions).getValue()).toObject(AtlasEntityDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEnumDef getEnumById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasEnumDef)((BinaryData)this.getEnumByIdWithResponse(guid, requestOptions).getValue()).toObject(AtlasEnumDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEnumDef getEnumByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasEnumDef)((BinaryData)this.getEnumByNameWithResponse(name, requestOptions).getValue()).toObject(AtlasEnumDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasRelationshipDef getRelationshipById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasRelationshipDef)((BinaryData)this.getRelationshipByIdWithResponse(guid, requestOptions).getValue()).toObject(AtlasRelationshipDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasRelationshipDef getRelationshipByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasRelationshipDef)((BinaryData)this.getRelationshipByNameWithResponse(name, requestOptions).getValue()).toObject(AtlasRelationshipDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasStructDef getStructById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasStructDef)((BinaryData)this.getStructByIdWithResponse(guid, requestOptions).getValue()).toObject(AtlasStructDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasStructDef getStructByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasStructDef)((BinaryData)this.getStructByNameWithResponse(name, requestOptions).getValue()).toObject(AtlasStructDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasTypeDef getById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasTypeDef)((BinaryData)this.getByIdWithResponse(guid, requestOptions).getValue()).toObject(AtlasTypeDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasTypeDef getByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasTypeDef)((BinaryData)this.getByNameWithResponse(name, requestOptions).getValue()).toObject(AtlasTypeDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String name) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteWithResponse(name, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasTypesDef get(Boolean includeTermTemplate, TypeCategory type) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermTemplate != null) {
            requestOptions.addQueryParam("includeTermTemplate", String.valueOf(includeTermTemplate), false);
        }
        if (type != null) {
            requestOptions.addQueryParam("type", type.toString(), false);
        }
        return (AtlasTypesDef)((BinaryData)this.getWithResponse(requestOptions).getValue()).toObject(AtlasTypesDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasTypesDef get() {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasTypesDef)((BinaryData)this.getWithResponse(requestOptions).getValue()).toObject(AtlasTypesDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasTypesDef batchCreate(AtlasTypesDef body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasTypesDef)((BinaryData)this.batchCreateWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasTypesDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasTypesDef batchUpdate(AtlasTypesDef body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasTypesDef)((BinaryData)this.batchUpdateWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasTypesDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void batchDelete(AtlasTypesDef body) {
        RequestOptions requestOptions = new RequestOptions();
        this.batchDeleteWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasTypeDefHeader> getHeaders(Boolean includeTermTemplate, TypeCategory type) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermTemplate != null) {
            requestOptions.addQueryParam("includeTermTemplate", String.valueOf(includeTermTemplate), false);
        }
        if (type != null) {
            requestOptions.addQueryParam("type", type.toString(), false);
        }
        return (List)((BinaryData)this.getHeadersWithResponse(requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_TYPE_DEF_HEADER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasTypeDefHeader> getHeaders() {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.getHeadersWithResponse(requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_TYPE_DEF_HEADER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TermTemplateDef getTermTemplateById(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (TermTemplateDef)((BinaryData)this.getTermTemplateByIdWithResponse(guid, requestOptions).getValue()).toObject(TermTemplateDef.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TermTemplateDef getTermTemplateByName(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (TermTemplateDef)((BinaryData)this.getTermTemplateByNameWithResponse(name, requestOptions).getValue()).toObject(TermTemplateDef.class);
    }
}

