/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DataMapClientBuilder;
import com.azure.analytics.purview.datamap.implementation.RelationshipsImpl;
import com.azure.analytics.purview.datamap.models.AtlasRelationship;
import com.azure.analytics.purview.datamap.models.AtlasRelationshipWithExtInfo;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;

@ServiceClient(builder=DataMapClientBuilder.class)
public final class RelationshipClient {
    private final RelationshipsImpl serviceClient;

    RelationshipClient(RelationshipsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.deleteWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasRelationship create(AtlasRelationship body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasRelationship)((BinaryData)this.createWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasRelationship.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasRelationship update(AtlasRelationship body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasRelationship)((BinaryData)this.updateWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasRelationship.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasRelationshipWithExtInfo get(String guid, Boolean extendedInfo) {
        RequestOptions requestOptions = new RequestOptions();
        if (extendedInfo != null) {
            requestOptions.addQueryParam("extendedInfo", String.valueOf(extendedInfo), false);
        }
        return (AtlasRelationshipWithExtInfo)((BinaryData)this.getWithResponse(guid, requestOptions).getValue()).toObject(AtlasRelationshipWithExtInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasRelationshipWithExtInfo get(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasRelationshipWithExtInfo)((BinaryData)this.getWithResponse(guid, requestOptions).getValue()).toObject(AtlasRelationshipWithExtInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteWithResponse(guid, requestOptions).getValue();
    }
}

