/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DataMapClientBuilder;
import com.azure.analytics.purview.datamap.implementation.RelationshipsImpl;
import com.azure.analytics.purview.datamap.models.AtlasRelationship;
import com.azure.analytics.purview.datamap.models.AtlasRelationshipWithExtInfo;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataMapClientBuilder.class, isAsync=true)
public final class RelationshipAsyncClient {
    private final RelationshipsImpl serviceClient;

    RelationshipAsyncClient(RelationshipsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.deleteWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasRelationship> create(AtlasRelationship body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasRelationship)protocolMethodData.toObject(AtlasRelationship.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasRelationship> update(AtlasRelationship body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasRelationship)protocolMethodData.toObject(AtlasRelationship.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasRelationshipWithExtInfo> get(String guid, Boolean extendedInfo) {
        RequestOptions requestOptions = new RequestOptions();
        if (extendedInfo != null) {
            requestOptions.addQueryParam("extendedInfo", String.valueOf(extendedInfo), false);
        }
        return this.getWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasRelationshipWithExtInfo)protocolMethodData.toObject(AtlasRelationshipWithExtInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasRelationshipWithExtInfo> get(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasRelationshipWithExtInfo)protocolMethodData.toObject(AtlasRelationshipWithExtInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono);
    }
}

