/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DataMapClientBuilder;
import com.azure.analytics.purview.datamap.implementation.GlossariesImpl;
import com.azure.analytics.purview.datamap.models.AtlasGlossary;
import com.azure.analytics.purview.datamap.models.AtlasGlossaryCategory;
import com.azure.analytics.purview.datamap.models.AtlasGlossaryExtInfo;
import com.azure.analytics.purview.datamap.models.AtlasGlossaryTerm;
import com.azure.analytics.purview.datamap.models.AtlasRelatedCategoryHeader;
import com.azure.analytics.purview.datamap.models.AtlasRelatedObjectId;
import com.azure.analytics.purview.datamap.models.AtlasRelatedTermHeader;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.serializer.TypeReference;
import java.util.List;
import java.util.Map;

@ServiceClient(builder=DataMapClientBuilder.class)
public final class GlossaryClient {
    private final GlossariesImpl serviceClient;
    private static final TypeReference<List<AtlasGlossary>> TYPE_REFERENCE_LIST_ATLAS_GLOSSARY = new TypeReference<List<AtlasGlossary>>(){};
    private static final TypeReference<List<AtlasRelatedTermHeader>> TYPE_REFERENCE_LIST_ATLAS_RELATED_TERM_HEADER = new TypeReference<List<AtlasRelatedTermHeader>>(){};
    private static final TypeReference<List<AtlasGlossaryTerm>> TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_TERM = new TypeReference<List<AtlasGlossaryTerm>>(){};
    private static final TypeReference<Map<String, List<AtlasRelatedCategoryHeader>>> TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_CATEGORY_HEADER = new TypeReference<Map<String, List<AtlasRelatedCategoryHeader>>>(){};
    private static final TypeReference<List<AtlasRelatedObjectId>> TYPE_REFERENCE_LIST_ATLAS_RELATED_OBJECT_ID = new TypeReference<List<AtlasRelatedObjectId>>(){};
    private static final TypeReference<List<AtlasGlossaryCategory>> TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_CATEGORY = new TypeReference<List<AtlasGlossaryCategory>>(){};
    private static final TypeReference<Map<String, List<AtlasRelatedTermHeader>>> TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_TERM_HEADER = new TypeReference<Map<String, List<AtlasRelatedTermHeader>>>(){};
    private static final TypeReference<List<AtlasRelatedCategoryHeader>> TYPE_REFERENCE_LIST_ATLAS_RELATED_CATEGORY_HEADER = new TypeReference<List<AtlasRelatedCategoryHeader>>(){};

    GlossaryClient(GlossariesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> batchGetWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.batchGetWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createCategoriesWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createCategoriesWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createCategoryWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createCategoryWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCategoryWithResponse(String categoryId, RequestOptions requestOptions) {
        return this.serviceClient.getCategoryWithResponse(categoryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateCategoryWithResponse(String categoryId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateCategoryWithResponse(categoryId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteCategoryWithResponse(String categoryId, RequestOptions requestOptions) {
        return this.serviceClient.deleteCategoryWithResponse(categoryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> partialUpdateCategoryWithResponse(String categoryId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.partialUpdateCategoryWithResponse(categoryId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRelatedCategoriesWithResponse(String categoryId, RequestOptions requestOptions) {
        return this.serviceClient.getRelatedCategoriesWithResponse(categoryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCategoryTermsWithResponse(String categoryId, RequestOptions requestOptions) {
        return this.serviceClient.getCategoryTermsWithResponse(categoryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createTermWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createTermWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTermWithResponse(String termId, RequestOptions requestOptions) {
        return this.serviceClient.getTermWithResponse(termId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateTermWithResponse(String termId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateTermWithResponse(termId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTermWithResponse(String termId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTermWithResponse(termId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> partialUpdateTermWithResponse(String termId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.partialUpdateTermWithResponse(termId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createTermsWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createTermsWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEntitiesAssignedWithTermWithResponse(String termId, RequestOptions requestOptions) {
        return this.serviceClient.getEntitiesAssignedWithTermWithResponse(termId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> assignTermToEntitiesWithResponse(String termId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.assignTermToEntitiesWithResponse(termId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTermAssignmentFromEntitiesWithResponse(String termId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.deleteTermAssignmentFromEntitiesWithResponse(termId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRelatedTermsWithResponse(String termId, RequestOptions requestOptions) {
        return this.serviceClient.getRelatedTermsWithResponse(termId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getWithResponse(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateWithResponse(String glossaryId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateWithResponse(glossaryId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.deleteWithResponse(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCategoriesWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getCategoriesWithResponse(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCategoriesHeadersWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getCategoriesHeadersWithResponse(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDetailedWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getDetailedWithResponse(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> partialUpdateWithResponse(String glossaryId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.partialUpdateWithResponse(glossaryId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTermsWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getTermsWithResponse(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTermHeadersWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getTermHeadersWithResponse(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasGlossary> batchGet(Integer limit, Integer offset, String sort, Boolean ignoreTermsAndCategories) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        if (ignoreTermsAndCategories != null) {
            requestOptions.addQueryParam("ignoreTermsAndCategories", String.valueOf(ignoreTermsAndCategories), false);
        }
        return (List)((BinaryData)this.batchGetWithResponse(requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasGlossary> batchGet() {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.batchGetWithResponse(requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossary create(AtlasGlossary body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossary)((BinaryData)this.createWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasGlossary.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasGlossaryCategory> createCategories(List<AtlasGlossaryCategory> body) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.createCategoriesWithResponse(BinaryData.fromObject(body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_CATEGORY);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryCategory createCategory(AtlasGlossaryCategory body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossaryCategory)((BinaryData)this.createCategoryWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasGlossaryCategory.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryCategory getCategory(String categoryId) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossaryCategory)((BinaryData)this.getCategoryWithResponse(categoryId, requestOptions).getValue()).toObject(AtlasGlossaryCategory.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryCategory updateCategory(String categoryId, AtlasGlossaryCategory body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossaryCategory)((BinaryData)this.updateCategoryWithResponse(categoryId, BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasGlossaryCategory.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteCategory(String categoryId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteCategoryWithResponse(categoryId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryCategory partialUpdateCategory(String categoryId, Map<String, String> body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossaryCategory)((BinaryData)this.partialUpdateCategoryWithResponse(categoryId, BinaryData.fromObject(body), requestOptions).getValue()).toObject(AtlasGlossaryCategory.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, List<AtlasRelatedCategoryHeader>> getRelatedCategories(String categoryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return (Map)((BinaryData)this.getRelatedCategoriesWithResponse(categoryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_CATEGORY_HEADER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, List<AtlasRelatedCategoryHeader>> getRelatedCategories(String categoryId) {
        RequestOptions requestOptions = new RequestOptions();
        return (Map)((BinaryData)this.getRelatedCategoriesWithResponse(categoryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_CATEGORY_HEADER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasRelatedTermHeader> getCategoryTerms(String categoryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return (List)((BinaryData)this.getCategoryTermsWithResponse(categoryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_TERM_HEADER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasRelatedTermHeader> getCategoryTerms(String categoryId) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.getCategoryTermsWithResponse(categoryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_TERM_HEADER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryTerm createTerm(AtlasGlossaryTerm body, Boolean includeTermHierarchy) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermHierarchy != null) {
            requestOptions.addQueryParam("includeTermHierarchy", String.valueOf(includeTermHierarchy), false);
        }
        return (AtlasGlossaryTerm)((BinaryData)this.createTermWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasGlossaryTerm.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryTerm createTerm(AtlasGlossaryTerm body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossaryTerm)((BinaryData)this.createTermWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasGlossaryTerm.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryTerm getTerm(String termId) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossaryTerm)((BinaryData)this.getTermWithResponse(termId, requestOptions).getValue()).toObject(AtlasGlossaryTerm.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryTerm updateTerm(String termId, AtlasGlossaryTerm body, Boolean includeTermHierarchy) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermHierarchy != null) {
            requestOptions.addQueryParam("includeTermHierarchy", String.valueOf(includeTermHierarchy), false);
        }
        return (AtlasGlossaryTerm)((BinaryData)this.updateTermWithResponse(termId, BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasGlossaryTerm.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryTerm updateTerm(String termId, AtlasGlossaryTerm body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossaryTerm)((BinaryData)this.updateTermWithResponse(termId, BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasGlossaryTerm.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTerm(String termId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteTermWithResponse(termId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryTerm partialUpdateTerm(String termId, Map<String, String> body, Boolean includeTermHierarchy) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermHierarchy != null) {
            requestOptions.addQueryParam("includeTermHierarchy", String.valueOf(includeTermHierarchy), false);
        }
        return (AtlasGlossaryTerm)((BinaryData)this.partialUpdateTermWithResponse(termId, BinaryData.fromObject(body), requestOptions).getValue()).toObject(AtlasGlossaryTerm.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryTerm partialUpdateTerm(String termId, Map<String, String> body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossaryTerm)((BinaryData)this.partialUpdateTermWithResponse(termId, BinaryData.fromObject(body), requestOptions).getValue()).toObject(AtlasGlossaryTerm.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasGlossaryTerm> createTerms(List<AtlasGlossaryTerm> body, Boolean includeTermHierarchy) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermHierarchy != null) {
            requestOptions.addQueryParam("includeTermHierarchy", String.valueOf(includeTermHierarchy), false);
        }
        return (List)((BinaryData)this.createTermsWithResponse(BinaryData.fromObject(body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_TERM);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasGlossaryTerm> createTerms(List<AtlasGlossaryTerm> body) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.createTermsWithResponse(BinaryData.fromObject(body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_TERM);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasRelatedObjectId> getEntitiesAssignedWithTerm(String termId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return (List)((BinaryData)this.getEntitiesAssignedWithTermWithResponse(termId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_OBJECT_ID);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasRelatedObjectId> getEntitiesAssignedWithTerm(String termId) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.getEntitiesAssignedWithTermWithResponse(termId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_OBJECT_ID);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void assignTermToEntities(String termId, List<AtlasRelatedObjectId> body) {
        RequestOptions requestOptions = new RequestOptions();
        this.assignTermToEntitiesWithResponse(termId, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTermAssignmentFromEntities(String termId, List<AtlasRelatedObjectId> body) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteTermAssignmentFromEntitiesWithResponse(termId, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, List<AtlasRelatedTermHeader>> getRelatedTerms(String termId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return (Map)((BinaryData)this.getRelatedTermsWithResponse(termId, requestOptions).getValue()).toObject(TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_TERM_HEADER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, List<AtlasRelatedTermHeader>> getRelatedTerms(String termId) {
        RequestOptions requestOptions = new RequestOptions();
        return (Map)((BinaryData)this.getRelatedTermsWithResponse(termId, requestOptions).getValue()).toObject(TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_TERM_HEADER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossary get(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossary)((BinaryData)this.getWithResponse(glossaryId, requestOptions).getValue()).toObject(AtlasGlossary.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossary update(String glossaryId, AtlasGlossary body, Boolean ignoreTermsAndCategories) {
        RequestOptions requestOptions = new RequestOptions();
        if (ignoreTermsAndCategories != null) {
            requestOptions.addQueryParam("ignoreTermsAndCategories", String.valueOf(ignoreTermsAndCategories), false);
        }
        return (AtlasGlossary)((BinaryData)this.updateWithResponse(glossaryId, BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasGlossary.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossary update(String glossaryId, AtlasGlossary body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossary)((BinaryData)this.updateWithResponse(glossaryId, BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AtlasGlossary.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteWithResponse(glossaryId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasGlossaryCategory> getCategories(String glossaryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return (List)((BinaryData)this.getCategoriesWithResponse(glossaryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_CATEGORY);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasGlossaryCategory> getCategories(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.getCategoriesWithResponse(glossaryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_CATEGORY);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasRelatedCategoryHeader> getCategoriesHeaders(String glossaryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return (List)((BinaryData)this.getCategoriesHeadersWithResponse(glossaryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_CATEGORY_HEADER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasRelatedCategoryHeader> getCategoriesHeaders(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.getCategoriesHeadersWithResponse(glossaryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_CATEGORY_HEADER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossaryExtInfo getDetailed(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossaryExtInfo)((BinaryData)this.getDetailedWithResponse(glossaryId, requestOptions).getValue()).toObject(AtlasGlossaryExtInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossary partialUpdate(String glossaryId, Map<String, String> body, Boolean ignoreTermsAndCategories) {
        RequestOptions requestOptions = new RequestOptions();
        if (ignoreTermsAndCategories != null) {
            requestOptions.addQueryParam("ignoreTermsAndCategories", String.valueOf(ignoreTermsAndCategories), false);
        }
        return (AtlasGlossary)((BinaryData)this.partialUpdateWithResponse(glossaryId, BinaryData.fromObject(body), requestOptions).getValue()).toObject(AtlasGlossary.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasGlossary partialUpdate(String glossaryId, Map<String, String> body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasGlossary)((BinaryData)this.partialUpdateWithResponse(glossaryId, BinaryData.fromObject(body), requestOptions).getValue()).toObject(AtlasGlossary.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasGlossaryTerm> getTerms(String glossaryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return (List)((BinaryData)this.getTermsWithResponse(glossaryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_TERM);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasGlossaryTerm> getTerms(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.getTermsWithResponse(glossaryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_TERM);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasRelatedTermHeader> getTermHeaders(String glossaryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return (List)((BinaryData)this.getTermHeadersWithResponse(glossaryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_TERM_HEADER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<AtlasRelatedTermHeader> getTermHeaders(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.getTermHeadersWithResponse(glossaryId, requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_TERM_HEADER);
    }
}

