/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DataMapClientBuilder;
import com.azure.analytics.purview.datamap.implementation.GlossariesImpl;
import com.azure.analytics.purview.datamap.models.AtlasGlossary;
import com.azure.analytics.purview.datamap.models.AtlasGlossaryCategory;
import com.azure.analytics.purview.datamap.models.AtlasGlossaryExtInfo;
import com.azure.analytics.purview.datamap.models.AtlasGlossaryTerm;
import com.azure.analytics.purview.datamap.models.AtlasRelatedCategoryHeader;
import com.azure.analytics.purview.datamap.models.AtlasRelatedObjectId;
import com.azure.analytics.purview.datamap.models.AtlasRelatedTermHeader;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.TypeReference;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataMapClientBuilder.class, isAsync=true)
public final class GlossaryAsyncClient {
    private final GlossariesImpl serviceClient;
    private static final TypeReference<List<AtlasGlossary>> TYPE_REFERENCE_LIST_ATLAS_GLOSSARY = new TypeReference<List<AtlasGlossary>>(){};
    private static final TypeReference<List<AtlasRelatedTermHeader>> TYPE_REFERENCE_LIST_ATLAS_RELATED_TERM_HEADER = new TypeReference<List<AtlasRelatedTermHeader>>(){};
    private static final TypeReference<List<AtlasGlossaryTerm>> TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_TERM = new TypeReference<List<AtlasGlossaryTerm>>(){};
    private static final TypeReference<Map<String, List<AtlasRelatedCategoryHeader>>> TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_CATEGORY_HEADER = new TypeReference<Map<String, List<AtlasRelatedCategoryHeader>>>(){};
    private static final TypeReference<List<AtlasRelatedObjectId>> TYPE_REFERENCE_LIST_ATLAS_RELATED_OBJECT_ID = new TypeReference<List<AtlasRelatedObjectId>>(){};
    private static final TypeReference<List<AtlasGlossaryCategory>> TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_CATEGORY = new TypeReference<List<AtlasGlossaryCategory>>(){};
    private static final TypeReference<Map<String, List<AtlasRelatedTermHeader>>> TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_TERM_HEADER = new TypeReference<Map<String, List<AtlasRelatedTermHeader>>>(){};
    private static final TypeReference<List<AtlasRelatedCategoryHeader>> TYPE_REFERENCE_LIST_ATLAS_RELATED_CATEGORY_HEADER = new TypeReference<List<AtlasRelatedCategoryHeader>>(){};

    GlossaryAsyncClient(GlossariesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> batchGetWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.batchGetWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createCategoriesWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createCategoriesWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createCategoryWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createCategoryWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCategoryWithResponse(String categoryId, RequestOptions requestOptions) {
        return this.serviceClient.getCategoryWithResponseAsync(categoryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateCategoryWithResponse(String categoryId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateCategoryWithResponseAsync(categoryId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCategoryWithResponse(String categoryId, RequestOptions requestOptions) {
        return this.serviceClient.deleteCategoryWithResponseAsync(categoryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> partialUpdateCategoryWithResponse(String categoryId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.partialUpdateCategoryWithResponseAsync(categoryId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRelatedCategoriesWithResponse(String categoryId, RequestOptions requestOptions) {
        return this.serviceClient.getRelatedCategoriesWithResponseAsync(categoryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCategoryTermsWithResponse(String categoryId, RequestOptions requestOptions) {
        return this.serviceClient.getCategoryTermsWithResponseAsync(categoryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createTermWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createTermWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTermWithResponse(String termId, RequestOptions requestOptions) {
        return this.serviceClient.getTermWithResponseAsync(termId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateTermWithResponse(String termId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateTermWithResponseAsync(termId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTermWithResponse(String termId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTermWithResponseAsync(termId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> partialUpdateTermWithResponse(String termId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.partialUpdateTermWithResponseAsync(termId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createTermsWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createTermsWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEntitiesAssignedWithTermWithResponse(String termId, RequestOptions requestOptions) {
        return this.serviceClient.getEntitiesAssignedWithTermWithResponseAsync(termId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> assignTermToEntitiesWithResponse(String termId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.assignTermToEntitiesWithResponseAsync(termId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTermAssignmentFromEntitiesWithResponse(String termId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.deleteTermAssignmentFromEntitiesWithResponseAsync(termId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRelatedTermsWithResponse(String termId, RequestOptions requestOptions) {
        return this.serviceClient.getRelatedTermsWithResponseAsync(termId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getWithResponseAsync(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateWithResponse(String glossaryId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateWithResponseAsync(glossaryId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.deleteWithResponseAsync(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCategoriesWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getCategoriesWithResponseAsync(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCategoriesHeadersWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getCategoriesHeadersWithResponseAsync(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDetailedWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getDetailedWithResponseAsync(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> partialUpdateWithResponse(String glossaryId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.partialUpdateWithResponseAsync(glossaryId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTermsWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getTermsWithResponseAsync(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTermHeadersWithResponse(String glossaryId, RequestOptions requestOptions) {
        return this.serviceClient.getTermHeadersWithResponseAsync(glossaryId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasGlossary>> batchGet(Integer limit, Integer offset, String sort, Boolean ignoreTermsAndCategories) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        if (ignoreTermsAndCategories != null) {
            requestOptions.addQueryParam("ignoreTermsAndCategories", String.valueOf(ignoreTermsAndCategories), false);
        }
        return this.batchGetWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasGlossary>> batchGet() {
        RequestOptions requestOptions = new RequestOptions();
        return this.batchGetWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossary> create(AtlasGlossary body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossary)protocolMethodData.toObject(AtlasGlossary.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasGlossaryCategory>> createCategories(List<AtlasGlossaryCategory> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createCategoriesWithResponse(BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_CATEGORY));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryCategory> createCategory(AtlasGlossaryCategory body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createCategoryWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryCategory)protocolMethodData.toObject(AtlasGlossaryCategory.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryCategory> getCategory(String categoryId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getCategoryWithResponse(categoryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryCategory)protocolMethodData.toObject(AtlasGlossaryCategory.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryCategory> updateCategory(String categoryId, AtlasGlossaryCategory body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateCategoryWithResponse(categoryId, BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryCategory)protocolMethodData.toObject(AtlasGlossaryCategory.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteCategory(String categoryId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteCategoryWithResponse(categoryId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryCategory> partialUpdateCategory(String categoryId, Map<String, String> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.partialUpdateCategoryWithResponse(categoryId, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryCategory)protocolMethodData.toObject(AtlasGlossaryCategory.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, List<AtlasRelatedCategoryHeader>>> getRelatedCategories(String categoryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return this.getRelatedCategoriesWithResponse(categoryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Map)protocolMethodData.toObject(TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_CATEGORY_HEADER));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, List<AtlasRelatedCategoryHeader>>> getRelatedCategories(String categoryId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getRelatedCategoriesWithResponse(categoryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Map)protocolMethodData.toObject(TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_CATEGORY_HEADER));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasRelatedTermHeader>> getCategoryTerms(String categoryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return this.getCategoryTermsWithResponse(categoryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_TERM_HEADER));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasRelatedTermHeader>> getCategoryTerms(String categoryId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getCategoryTermsWithResponse(categoryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_TERM_HEADER));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryTerm> createTerm(AtlasGlossaryTerm body, Boolean includeTermHierarchy) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermHierarchy != null) {
            requestOptions.addQueryParam("includeTermHierarchy", String.valueOf(includeTermHierarchy), false);
        }
        return this.createTermWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryTerm)protocolMethodData.toObject(AtlasGlossaryTerm.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryTerm> createTerm(AtlasGlossaryTerm body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createTermWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryTerm)protocolMethodData.toObject(AtlasGlossaryTerm.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryTerm> getTerm(String termId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTermWithResponse(termId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryTerm)protocolMethodData.toObject(AtlasGlossaryTerm.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryTerm> updateTerm(String termId, AtlasGlossaryTerm body, Boolean includeTermHierarchy) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermHierarchy != null) {
            requestOptions.addQueryParam("includeTermHierarchy", String.valueOf(includeTermHierarchy), false);
        }
        return this.updateTermWithResponse(termId, BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryTerm)protocolMethodData.toObject(AtlasGlossaryTerm.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryTerm> updateTerm(String termId, AtlasGlossaryTerm body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateTermWithResponse(termId, BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryTerm)protocolMethodData.toObject(AtlasGlossaryTerm.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTerm(String termId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteTermWithResponse(termId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryTerm> partialUpdateTerm(String termId, Map<String, String> body, Boolean includeTermHierarchy) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermHierarchy != null) {
            requestOptions.addQueryParam("includeTermHierarchy", String.valueOf(includeTermHierarchy), false);
        }
        return this.partialUpdateTermWithResponse(termId, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryTerm)protocolMethodData.toObject(AtlasGlossaryTerm.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryTerm> partialUpdateTerm(String termId, Map<String, String> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.partialUpdateTermWithResponse(termId, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryTerm)protocolMethodData.toObject(AtlasGlossaryTerm.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasGlossaryTerm>> createTerms(List<AtlasGlossaryTerm> body, Boolean includeTermHierarchy) {
        RequestOptions requestOptions = new RequestOptions();
        if (includeTermHierarchy != null) {
            requestOptions.addQueryParam("includeTermHierarchy", String.valueOf(includeTermHierarchy), false);
        }
        return this.createTermsWithResponse(BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_TERM));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasGlossaryTerm>> createTerms(List<AtlasGlossaryTerm> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createTermsWithResponse(BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_TERM));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasRelatedObjectId>> getEntitiesAssignedWithTerm(String termId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return this.getEntitiesAssignedWithTermWithResponse(termId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_OBJECT_ID));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasRelatedObjectId>> getEntitiesAssignedWithTerm(String termId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getEntitiesAssignedWithTermWithResponse(termId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_OBJECT_ID));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> assignTermToEntities(String termId, List<AtlasRelatedObjectId> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.assignTermToEntitiesWithResponse(termId, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTermAssignmentFromEntities(String termId, List<AtlasRelatedObjectId> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteTermAssignmentFromEntitiesWithResponse(termId, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, List<AtlasRelatedTermHeader>>> getRelatedTerms(String termId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return this.getRelatedTermsWithResponse(termId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Map)protocolMethodData.toObject(TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_TERM_HEADER));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, List<AtlasRelatedTermHeader>>> getRelatedTerms(String termId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getRelatedTermsWithResponse(termId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Map)protocolMethodData.toObject(TYPE_REFERENCE_MAP_STRING_LIST_ATLAS_RELATED_TERM_HEADER));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossary> get(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getWithResponse(glossaryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossary)protocolMethodData.toObject(AtlasGlossary.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossary> update(String glossaryId, AtlasGlossary body, Boolean ignoreTermsAndCategories) {
        RequestOptions requestOptions = new RequestOptions();
        if (ignoreTermsAndCategories != null) {
            requestOptions.addQueryParam("ignoreTermsAndCategories", String.valueOf(ignoreTermsAndCategories), false);
        }
        return this.updateWithResponse(glossaryId, BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossary)protocolMethodData.toObject(AtlasGlossary.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossary> update(String glossaryId, AtlasGlossary body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateWithResponse(glossaryId, BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossary)protocolMethodData.toObject(AtlasGlossary.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteWithResponse(glossaryId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasGlossaryCategory>> getCategories(String glossaryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return this.getCategoriesWithResponse(glossaryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_CATEGORY));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasGlossaryCategory>> getCategories(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getCategoriesWithResponse(glossaryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_CATEGORY));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasRelatedCategoryHeader>> getCategoriesHeaders(String glossaryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return this.getCategoriesHeadersWithResponse(glossaryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_CATEGORY_HEADER));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasRelatedCategoryHeader>> getCategoriesHeaders(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getCategoriesHeadersWithResponse(glossaryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_CATEGORY_HEADER));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossaryExtInfo> getDetailed(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getDetailedWithResponse(glossaryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossaryExtInfo)protocolMethodData.toObject(AtlasGlossaryExtInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossary> partialUpdate(String glossaryId, Map<String, String> body, Boolean ignoreTermsAndCategories) {
        RequestOptions requestOptions = new RequestOptions();
        if (ignoreTermsAndCategories != null) {
            requestOptions.addQueryParam("ignoreTermsAndCategories", String.valueOf(ignoreTermsAndCategories), false);
        }
        return this.partialUpdateWithResponse(glossaryId, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossary)protocolMethodData.toObject(AtlasGlossary.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasGlossary> partialUpdate(String glossaryId, Map<String, String> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.partialUpdateWithResponse(glossaryId, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasGlossary)protocolMethodData.toObject(AtlasGlossary.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasGlossaryTerm>> getTerms(String glossaryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return this.getTermsWithResponse(glossaryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_TERM));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasGlossaryTerm>> getTerms(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTermsWithResponse(glossaryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_GLOSSARY_TERM));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasRelatedTermHeader>> getTermHeaders(String glossaryId, Integer limit, Integer offset, String sort) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (offset != null) {
            requestOptions.addQueryParam("offset", String.valueOf(offset), false);
        }
        if (sort != null) {
            requestOptions.addQueryParam("sort", sort, false);
        }
        return this.getTermHeadersWithResponse(glossaryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_TERM_HEADER));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<AtlasRelatedTermHeader>> getTermHeaders(String glossaryId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTermHeadersWithResponse(glossaryId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_ATLAS_RELATED_TERM_HEADER));
    }
}

