/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DataMapClientBuilder;
import com.azure.analytics.purview.datamap.implementation.EntitiesImpl;
import com.azure.analytics.purview.datamap.implementation.MultipartFormDataHelper;
import com.azure.analytics.purview.datamap.models.AtlasClassification;
import com.azure.analytics.purview.datamap.models.AtlasClassifications;
import com.azure.analytics.purview.datamap.models.AtlasEntitiesWithExtInfo;
import com.azure.analytics.purview.datamap.models.AtlasEntityHeader;
import com.azure.analytics.purview.datamap.models.AtlasEntityHeaders;
import com.azure.analytics.purview.datamap.models.AtlasEntityWithExtInfo;
import com.azure.analytics.purview.datamap.models.BulkImportResult;
import com.azure.analytics.purview.datamap.models.BusinessAttributeUpdateBehavior;
import com.azure.analytics.purview.datamap.models.BusinessMetadataOptions;
import com.azure.analytics.purview.datamap.models.ClassificationAssociateOptions;
import com.azure.analytics.purview.datamap.models.EntityMutationResult;
import com.azure.analytics.purview.datamap.models.MoveEntitiesOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.serializer.TypeReference;
import java.util.List;
import java.util.Map;

@ServiceClient(builder=DataMapClientBuilder.class)
public final class EntityClient {
    private final EntitiesImpl serviceClient;
    private static final TypeReference<List<String>> TYPE_REFERENCE_LIST_STRING = new TypeReference<List<String>>(){};

    EntityClient(EntitiesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getByIdsWithResponse(List<String> guid, RequestOptions requestOptions) {
        return this.serviceClient.getByIdsWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> batchCreateOrUpdateWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.batchCreateOrUpdateWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> batchDeleteWithResponse(List<String> guid, RequestOptions requestOptions) {
        return this.serviceClient.batchDeleteWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addClassificationWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.addClassificationWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateAttributeByIdWithResponse(String guid, String name, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateAttributeByIdWithResponse(guid, name, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.deleteWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getClassificationWithResponse(String guid, String classificationName, RequestOptions requestOptions) {
        return this.serviceClient.getClassificationWithResponse(guid, classificationName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeClassificationWithResponse(String guid, String classificationName, RequestOptions requestOptions) {
        return this.serviceClient.removeClassificationWithResponse(guid, classificationName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getClassificationsWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getClassificationsWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addClassificationsWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.addClassificationsWithResponse(guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateClassificationsWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateClassificationsWithResponse(guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.getByUniqueAttributeWithResponse(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateByUniqueAttributeWithResponse(String typeName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateByUniqueAttributeWithResponse(typeName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> deleteByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.deleteByUniqueAttributeWithResponse(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeClassificationByUniqueAttributeWithResponse(String typeName, String classificationName, RequestOptions requestOptions) {
        return this.serviceClient.removeClassificationByUniqueAttributeWithResponse(typeName, classificationName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addClassificationsByUniqueAttributeWithResponse(String typeName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.addClassificationsByUniqueAttributeWithResponse(typeName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateClassificationsUniqueByAttributeWithResponse(String typeName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateClassificationsUniqueByAttributeWithResponse(typeName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> batchSetClassificationsWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.batchSetClassificationsWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> batchGetByUniqueAttributesWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.batchGetByUniqueAttributesWithResponse(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getHeaderWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getHeaderWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeBusinessMetadataWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.removeBusinessMetadataWithResponse(guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addOrUpdateBusinessMetadataWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.addOrUpdateBusinessMetadataWithResponse(guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeBusinessMetadataAttributesWithResponse(String businessMetadataName, String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.removeBusinessMetadataAttributesWithResponse(businessMetadataName, guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addOrUpdateBusinessMetadataAttributesWithResponse(String businessMetadataName, String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.addOrUpdateBusinessMetadataAttributesWithResponse(businessMetadataName, guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getBusinessMetadataTemplateWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getBusinessMetadataTemplateWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> importBusinessMetadataWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.importBusinessMetadataWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeLabelsWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.removeLabelsWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setLabelsWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.setLabelsWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addLabelWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.addLabelWithResponse(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeLabelsByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.removeLabelsByUniqueAttributeWithResponse(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setLabelsByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.setLabelsByUniqueAttributeWithResponse(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addLabelsByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.addLabelsByUniqueAttributeWithResponse(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> moveEntitiesToCollectionWithResponse(String collectionId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.moveEntitiesToCollectionWithResponse(collectionId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult createOrUpdate(AtlasEntityWithExtInfo body, BusinessAttributeUpdateBehavior businessAttributeUpdateBehavior, String collectionId) {
        RequestOptions requestOptions = new RequestOptions();
        if (businessAttributeUpdateBehavior != null) {
            requestOptions.addQueryParam("businessAttributeUpdateBehavior", businessAttributeUpdateBehavior.toString(), false);
        }
        if (collectionId != null) {
            requestOptions.addQueryParam("collectionId", collectionId, false);
        }
        return (EntityMutationResult)((BinaryData)this.createOrUpdateWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(EntityMutationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult createOrUpdate(AtlasEntityWithExtInfo body) {
        RequestOptions requestOptions = new RequestOptions();
        return (EntityMutationResult)((BinaryData)this.createOrUpdateWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(EntityMutationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEntitiesWithExtInfo getByIds(List<String> guid, Boolean minExtInfo, Boolean ignoreRelationships) {
        RequestOptions requestOptions = new RequestOptions();
        if (minExtInfo != null) {
            requestOptions.addQueryParam("minExtInfo", String.valueOf(minExtInfo), false);
        }
        if (ignoreRelationships != null) {
            requestOptions.addQueryParam("ignoreRelationships", String.valueOf(ignoreRelationships), false);
        }
        return (AtlasEntitiesWithExtInfo)((BinaryData)this.getByIdsWithResponse(guid, requestOptions).getValue()).toObject(AtlasEntitiesWithExtInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEntitiesWithExtInfo getByIds(List<String> guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasEntitiesWithExtInfo)((BinaryData)this.getByIdsWithResponse(guid, requestOptions).getValue()).toObject(AtlasEntitiesWithExtInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult batchCreateOrUpdate(AtlasEntitiesWithExtInfo body, String collectionId, BusinessAttributeUpdateBehavior businessAttributeUpdateBehavior) {
        RequestOptions requestOptions = new RequestOptions();
        if (collectionId != null) {
            requestOptions.addQueryParam("collectionId", collectionId, false);
        }
        if (businessAttributeUpdateBehavior != null) {
            requestOptions.addQueryParam("businessAttributeUpdateBehavior", businessAttributeUpdateBehavior.toString(), false);
        }
        return (EntityMutationResult)((BinaryData)this.batchCreateOrUpdateWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(EntityMutationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult batchCreateOrUpdate(AtlasEntitiesWithExtInfo body) {
        RequestOptions requestOptions = new RequestOptions();
        return (EntityMutationResult)((BinaryData)this.batchCreateOrUpdateWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(EntityMutationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult batchDelete(List<String> guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (EntityMutationResult)((BinaryData)this.batchDeleteWithResponse(guid, requestOptions).getValue()).toObject(EntityMutationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addClassification(ClassificationAssociateOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        this.addClassificationWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEntityWithExtInfo get(String guid, Boolean minExtInfo, Boolean ignoreRelationships) {
        RequestOptions requestOptions = new RequestOptions();
        if (minExtInfo != null) {
            requestOptions.addQueryParam("minExtInfo", String.valueOf(minExtInfo), false);
        }
        if (ignoreRelationships != null) {
            requestOptions.addQueryParam("ignoreRelationships", String.valueOf(ignoreRelationships), false);
        }
        return (AtlasEntityWithExtInfo)((BinaryData)this.getWithResponse(guid, requestOptions).getValue()).toObject(AtlasEntityWithExtInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEntityWithExtInfo get(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasEntityWithExtInfo)((BinaryData)this.getWithResponse(guid, requestOptions).getValue()).toObject(AtlasEntityWithExtInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult updateAttributeById(String guid, String name, BinaryData body) {
        RequestOptions requestOptions = new RequestOptions();
        return (EntityMutationResult)((BinaryData)this.updateAttributeByIdWithResponse(guid, name, body, requestOptions).getValue()).toObject(EntityMutationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult delete(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (EntityMutationResult)((BinaryData)this.deleteWithResponse(guid, requestOptions).getValue()).toObject(EntityMutationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasClassification getClassification(String guid, String classificationName) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasClassification)((BinaryData)this.getClassificationWithResponse(guid, classificationName, requestOptions).getValue()).toObject(AtlasClassification.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeClassification(String guid, String classificationName) {
        RequestOptions requestOptions = new RequestOptions();
        this.removeClassificationWithResponse(guid, classificationName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasClassifications getClassifications(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasClassifications)((BinaryData)this.getClassificationsWithResponse(guid, requestOptions).getValue()).toObject(AtlasClassifications.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addClassifications(String guid, List<AtlasClassification> body) {
        RequestOptions requestOptions = new RequestOptions();
        this.addClassificationsWithResponse(guid, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateClassifications(String guid, List<AtlasClassification> body) {
        RequestOptions requestOptions = new RequestOptions();
        this.updateClassificationsWithResponse(guid, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEntityWithExtInfo getByUniqueAttribute(String typeName, Boolean minExtInfo, Boolean ignoreRelationships, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (minExtInfo != null) {
            requestOptions.addQueryParam("minExtInfo", String.valueOf(minExtInfo), false);
        }
        if (ignoreRelationships != null) {
            requestOptions.addQueryParam("ignoreRelationships", String.valueOf(ignoreRelationships), false);
        }
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        return (AtlasEntityWithExtInfo)((BinaryData)this.getByUniqueAttributeWithResponse(typeName, requestOptions).getValue()).toObject(AtlasEntityWithExtInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEntityWithExtInfo getByUniqueAttribute(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasEntityWithExtInfo)((BinaryData)this.getByUniqueAttributeWithResponse(typeName, requestOptions).getValue()).toObject(AtlasEntityWithExtInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult updateByUniqueAttribute(String typeName, AtlasEntityWithExtInfo body, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        return (EntityMutationResult)((BinaryData)this.updateByUniqueAttributeWithResponse(typeName, BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(EntityMutationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult updateByUniqueAttribute(String typeName, AtlasEntityWithExtInfo body) {
        RequestOptions requestOptions = new RequestOptions();
        return (EntityMutationResult)((BinaryData)this.updateByUniqueAttributeWithResponse(typeName, BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(EntityMutationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult deleteByUniqueAttribute(String typeName, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        return (EntityMutationResult)((BinaryData)this.deleteByUniqueAttributeWithResponse(typeName, requestOptions).getValue()).toObject(EntityMutationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult deleteByUniqueAttribute(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        return (EntityMutationResult)((BinaryData)this.deleteByUniqueAttributeWithResponse(typeName, requestOptions).getValue()).toObject(EntityMutationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeClassificationByUniqueAttribute(String typeName, String classificationName, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        this.removeClassificationByUniqueAttributeWithResponse(typeName, classificationName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeClassificationByUniqueAttribute(String typeName, String classificationName) {
        RequestOptions requestOptions = new RequestOptions();
        this.removeClassificationByUniqueAttributeWithResponse(typeName, classificationName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addClassificationsByUniqueAttribute(String typeName, List<AtlasClassification> body, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        this.addClassificationsByUniqueAttributeWithResponse(typeName, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addClassificationsByUniqueAttribute(String typeName, List<AtlasClassification> body) {
        RequestOptions requestOptions = new RequestOptions();
        this.addClassificationsByUniqueAttributeWithResponse(typeName, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateClassificationsUniqueByAttribute(String typeName, List<AtlasClassification> body, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        this.updateClassificationsUniqueByAttributeWithResponse(typeName, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateClassificationsUniqueByAttribute(String typeName, List<AtlasClassification> body) {
        RequestOptions requestOptions = new RequestOptions();
        this.updateClassificationsUniqueByAttributeWithResponse(typeName, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> batchSetClassifications(AtlasEntityHeaders body) {
        RequestOptions requestOptions = new RequestOptions();
        return (List)((BinaryData)this.batchSetClassificationsWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(TYPE_REFERENCE_LIST_STRING);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEntitiesWithExtInfo batchGetByUniqueAttributes(String typeName, Boolean minExtInfo, Boolean ignoreRelationships, String attrNQualifiedName) {
        RequestOptions requestOptions = new RequestOptions();
        if (minExtInfo != null) {
            requestOptions.addQueryParam("minExtInfo", String.valueOf(minExtInfo), false);
        }
        if (ignoreRelationships != null) {
            requestOptions.addQueryParam("ignoreRelationships", String.valueOf(ignoreRelationships), false);
        }
        if (attrNQualifiedName != null) {
            requestOptions.addQueryParam("attr_N:qualifiedName", attrNQualifiedName, false);
        }
        return (AtlasEntitiesWithExtInfo)((BinaryData)this.batchGetByUniqueAttributesWithResponse(typeName, requestOptions).getValue()).toObject(AtlasEntitiesWithExtInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEntitiesWithExtInfo batchGetByUniqueAttributes(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasEntitiesWithExtInfo)((BinaryData)this.batchGetByUniqueAttributesWithResponse(typeName, requestOptions).getValue()).toObject(AtlasEntitiesWithExtInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AtlasEntityHeader getHeader(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return (AtlasEntityHeader)((BinaryData)this.getHeaderWithResponse(guid, requestOptions).getValue()).toObject(AtlasEntityHeader.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeBusinessMetadata(String guid, Map<String, Map<String, BinaryData>> body) {
        RequestOptions requestOptions = new RequestOptions();
        this.removeBusinessMetadataWithResponse(guid, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addOrUpdateBusinessMetadata(String guid, Map<String, Map<String, BinaryData>> body, Boolean overwrite) {
        RequestOptions requestOptions = new RequestOptions();
        if (overwrite != null) {
            requestOptions.addQueryParam("isOverwrite", String.valueOf(overwrite), false);
        }
        this.addOrUpdateBusinessMetadataWithResponse(guid, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addOrUpdateBusinessMetadata(String guid, Map<String, Map<String, BinaryData>> body) {
        RequestOptions requestOptions = new RequestOptions();
        this.addOrUpdateBusinessMetadataWithResponse(guid, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeBusinessMetadataAttributes(String businessMetadataName, String guid, Map<String, BinaryData> body) {
        RequestOptions requestOptions = new RequestOptions();
        this.removeBusinessMetadataAttributesWithResponse(businessMetadataName, guid, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addOrUpdateBusinessMetadataAttributes(String businessMetadataName, String guid, Map<String, BinaryData> body) {
        RequestOptions requestOptions = new RequestOptions();
        this.addOrUpdateBusinessMetadataAttributesWithResponse(businessMetadataName, guid, BinaryData.fromObject(body), requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getBusinessMetadataTemplate() {
        RequestOptions requestOptions = new RequestOptions();
        return (BinaryData)this.getBusinessMetadataTemplateWithResponse(requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BulkImportResult importBusinessMetadata(BusinessMetadataOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        return (BulkImportResult)((BinaryData)this.importBusinessMetadataWithResponse(new MultipartFormDataHelper(requestOptions).serializeFileField("file", body.getFile().getContent(), body.getFile().getContentType(), body.getFile().getFilename()).end().getRequestBody(), requestOptions).getValue()).toObject(BulkImportResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeLabels(String guid, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        this.removeLabelsWithResponse(guid, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeLabels(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        this.removeLabelsWithResponse(guid, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setLabels(String guid, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        this.setLabelsWithResponse(guid, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setLabels(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        this.setLabelsWithResponse(guid, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addLabel(String guid, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        this.addLabelWithResponse(guid, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addLabel(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        this.addLabelWithResponse(guid, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeLabelsByUniqueAttribute(String typeName, String attribute, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        this.removeLabelsByUniqueAttributeWithResponse(typeName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeLabelsByUniqueAttribute(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        this.removeLabelsByUniqueAttributeWithResponse(typeName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setLabelsByUniqueAttribute(String typeName, String attribute, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        this.setLabelsByUniqueAttributeWithResponse(typeName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setLabelsByUniqueAttribute(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        this.setLabelsByUniqueAttributeWithResponse(typeName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addLabelsByUniqueAttribute(String typeName, String attribute, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        this.addLabelsByUniqueAttributeWithResponse(typeName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addLabelsByUniqueAttribute(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        this.addLabelsByUniqueAttributeWithResponse(typeName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EntityMutationResult moveEntitiesToCollection(String collectionId, MoveEntitiesOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        return (EntityMutationResult)((BinaryData)this.moveEntitiesToCollectionWithResponse(collectionId, BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(EntityMutationResult.class);
    }
}

