/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DataMapClientBuilder;
import com.azure.analytics.purview.datamap.implementation.DiscoveriesImpl;
import com.azure.analytics.purview.datamap.models.AutoCompleteOptions;
import com.azure.analytics.purview.datamap.models.AutoCompleteResult;
import com.azure.analytics.purview.datamap.models.QueryOptions;
import com.azure.analytics.purview.datamap.models.QueryResult;
import com.azure.analytics.purview.datamap.models.SuggestOptions;
import com.azure.analytics.purview.datamap.models.SuggestResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataMapClientBuilder.class, isAsync=true)
public final class DiscoveryAsyncClient {
    private final DiscoveriesImpl serviceClient;

    DiscoveryAsyncClient(DiscoveriesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> queryWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.queryWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> suggestWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.suggestWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> autoCompleteWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.autoCompleteWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueryResult> query(QueryOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.queryWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (QueryResult)protocolMethodData.toObject(QueryResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SuggestResult> suggest(SuggestOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.suggestWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (SuggestResult)protocolMethodData.toObject(SuggestResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AutoCompleteResult> autoComplete(AutoCompleteOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.autoCompleteWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AutoCompleteResult)protocolMethodData.toObject(AutoCompleteResult.class));
    }
}

