/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DiscoveryAsyncClient;
import com.azure.analytics.purview.datamap.DiscoveryClient;
import com.azure.analytics.purview.datamap.EntityAsyncClient;
import com.azure.analytics.purview.datamap.EntityClient;
import com.azure.analytics.purview.datamap.GlossaryAsyncClient;
import com.azure.analytics.purview.datamap.GlossaryClient;
import com.azure.analytics.purview.datamap.LineageAsyncClient;
import com.azure.analytics.purview.datamap.LineageClient;
import com.azure.analytics.purview.datamap.PurviewDataMapServiceVersion;
import com.azure.analytics.purview.datamap.RelationshipAsyncClient;
import com.azure.analytics.purview.datamap.RelationshipClient;
import com.azure.analytics.purview.datamap.TypeDefinitionAsyncClient;
import com.azure.analytics.purview.datamap.TypeDefinitionClient;
import com.azure.analytics.purview.datamap.implementation.DataMapClientImpl;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={EntityClient.class, GlossaryClient.class, DiscoveryClient.class, LineageClient.class, RelationshipClient.class, TypeDefinitionClient.class, EntityAsyncClient.class, GlossaryAsyncClient.class, DiscoveryAsyncClient.class, LineageAsyncClient.class, RelationshipAsyncClient.class, TypeDefinitionAsyncClient.class})
public final class DataMapClientBuilder
implements HttpTrait<DataMapClientBuilder>,
ConfigurationTrait<DataMapClientBuilder>,
TokenCredentialTrait<DataMapClientBuilder>,
EndpointTrait<DataMapClientBuilder> {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String[] DEFAULT_SCOPES = new String[]{"https://purview.azure.net/.default"};
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-analytics-purview-datamap.properties");
    private final List<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpPipeline pipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private ClientOptions clientOptions;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private TokenCredential tokenCredential;
    private String endpoint;
    private PurviewDataMapServiceVersion serviceVersion;
    private RetryPolicy retryPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(DataMapClientBuilder.class);

    public DataMapClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            LOGGER.atInfo().log("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public DataMapClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public DataMapClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public DataMapClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public DataMapClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public DataMapClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null.");
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    public DataMapClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public DataMapClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
        return this;
    }

    public DataMapClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public DataMapClientBuilder serviceVersion(PurviewDataMapServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public DataMapClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    private DataMapClientImpl buildInnerClient() {
        this.validateClient();
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : this.createHttpPipeline();
        PurviewDataMapServiceVersion localServiceVersion = this.serviceVersion != null ? this.serviceVersion : PurviewDataMapServiceVersion.getLatest();
        DataMapClientImpl client = new DataMapClientImpl(localPipeline, JacksonAdapter.createDefaultSerializerAdapter(), this.endpoint, localServiceVersion);
        return client;
    }

    private void validateClient() {
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null.");
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        HttpLogOptions localHttpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions == null ? new ClientOptions() : this.clientOptions;
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)localClientOptions, (HttpLogOptions)localHttpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        HttpHeaders headers = CoreUtils.createHttpHeadersFromClientOptions((ClientOptions)localClientOptions);
        if (headers != null) {
            policies.add(new AddHeadersPolicy(headers));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).forEach(p -> policies.add(p));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)new RetryPolicy()));
        policies.add(new AddDatePolicy());
        if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, DEFAULT_SCOPES));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).forEach(p -> policies.add(p));
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(localHttpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(localClientOptions).build();
        return httpPipeline;
    }

    public EntityAsyncClient buildEntityAsyncClient() {
        return new EntityAsyncClient(this.buildInnerClient().getEntities());
    }

    public GlossaryAsyncClient buildGlossaryAsyncClient() {
        return new GlossaryAsyncClient(this.buildInnerClient().getGlossaries());
    }

    public DiscoveryAsyncClient buildDiscoveryAsyncClient() {
        return new DiscoveryAsyncClient(this.buildInnerClient().getDiscoveries());
    }

    public LineageAsyncClient buildLineageAsyncClient() {
        return new LineageAsyncClient(this.buildInnerClient().getLineages());
    }

    public RelationshipAsyncClient buildRelationshipAsyncClient() {
        return new RelationshipAsyncClient(this.buildInnerClient().getRelationships());
    }

    public TypeDefinitionAsyncClient buildTypeDefinitionAsyncClient() {
        return new TypeDefinitionAsyncClient(this.buildInnerClient().getTypeDefinitions());
    }

    public EntityClient buildEntityClient() {
        return new EntityClient(this.buildInnerClient().getEntities());
    }

    public GlossaryClient buildGlossaryClient() {
        return new GlossaryClient(this.buildInnerClient().getGlossaries());
    }

    public DiscoveryClient buildDiscoveryClient() {
        return new DiscoveryClient(this.buildInnerClient().getDiscoveries());
    }

    public LineageClient buildLineageClient() {
        return new LineageClient(this.buildInnerClient().getLineages());
    }

    public RelationshipClient buildRelationshipClient() {
        return new RelationshipClient(this.buildInnerClient().getRelationships());
    }

    public TypeDefinitionClient buildTypeDefinitionClient() {
        return new TypeDefinitionClient(this.buildInnerClient().getTypeDefinitions());
    }
}

