/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImageMetadata
implements JsonSerializable<ImageMetadata> {
    private final int height;
    private final int width;

    private ImageMetadata(int height, int width) {
        this.height = height;
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("height", this.height);
        jsonWriter.writeIntField("width", this.width);
        return jsonWriter.writeEndObject();
    }

    public static ImageMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (ImageMetadata)jsonReader.readObject(reader -> {
            int height = 0;
            int width = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("height".equals(fieldName)) {
                    height = reader.getInt();
                    continue;
                }
                if ("width".equals(fieldName)) {
                    width = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new ImageMetadata(height, width);
        });
    }
}

