/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.implementation;

import com.azure.ai.vision.imageanalysis.ImageAnalysisServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class ImageAnalysisClientImpl {
    private final ImageAnalysisClientService service;
    private final String endpoint;
    private final ImageAnalysisServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public ImageAnalysisServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ImageAnalysisClientImpl(String endpoint, ImageAnalysisServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public ImageAnalysisClientImpl(HttpPipeline httpPipeline, String endpoint, ImageAnalysisServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public ImageAnalysisClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, ImageAnalysisServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (ImageAnalysisClientService)RestProxy.create(ImageAnalysisClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> analyzeFromImageDataWithResponseAsync(List<String> visualFeatures, BinaryData imageData, RequestOptions requestOptions) {
        String contentType = "application/octet-stream";
        String accept = "application/json";
        String visualFeaturesConverted = visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.analyzeFromImageData(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/octet-stream", visualFeaturesConverted, "application/json", imageData, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> analyzeFromImageDataWithResponse(List<String> visualFeatures, BinaryData imageData, RequestOptions requestOptions) {
        String contentType = "application/octet-stream";
        String accept = "application/json";
        String visualFeaturesConverted = visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeFromImageDataSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/octet-stream", visualFeaturesConverted, "application/json", imageData, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> analyzeFromUrlWithResponseAsync(List<String> visualFeatures, BinaryData imageUrl, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        String visualFeaturesConverted = visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.analyzeFromUrl(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", visualFeaturesConverted, "application/json", imageUrl, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> analyzeFromUrlWithResponse(List<String> visualFeatures, BinaryData imageUrl, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        String visualFeaturesConverted = visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeFromUrlSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", visualFeaturesConverted, "application/json", imageUrl, requestOptions, Context.NONE);
    }

    @Host(value="{endpoint}/computervision")
    @ServiceInterface(name="ImageAnalysisClient")
    public static interface ImageAnalysisClientService {
        @Post(value="/imageanalysis:analyze")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> analyzeFromImageData(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @QueryParam(value="features") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/octet-stream") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/imageanalysis:analyze")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> analyzeFromImageDataSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @QueryParam(value="features") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/octet-stream") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/imageanalysis:analyze")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> analyzeFromUrl(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @QueryParam(value="features") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/imageanalysis:analyze")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> analyzeFromUrlSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="content-type") String var3, @QueryParam(value="features") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);
    }
}

