/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.TargetConfidenceScoreLabel;
import com.azure.ai.textanalytics.implementation.models.TokenSentimentValue;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SentenceAssessment
implements JsonSerializable<SentenceAssessment> {
    private TokenSentimentValue sentiment;
    private TargetConfidenceScoreLabel confidenceScores;
    private int offset;
    private int length;
    private String text;
    private boolean isNegated;

    public TokenSentimentValue getSentiment() {
        return this.sentiment;
    }

    public SentenceAssessment setSentiment(TokenSentimentValue sentiment) {
        this.sentiment = sentiment;
        return this;
    }

    public TargetConfidenceScoreLabel getConfidenceScores() {
        return this.confidenceScores;
    }

    public SentenceAssessment setConfidenceScores(TargetConfidenceScoreLabel confidenceScores) {
        this.confidenceScores = confidenceScores;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public SentenceAssessment setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public SentenceAssessment setLength(int length) {
        this.length = length;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public SentenceAssessment setText(String text) {
        this.text = text;
        return this;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public SentenceAssessment setIsNegated(boolean isNegated) {
        this.isNegated = isNegated;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sentiment", this.sentiment == null ? null : this.sentiment.toString());
        jsonWriter.writeJsonField("confidenceScores", (JsonSerializable)this.confidenceScores);
        jsonWriter.writeIntField("offset", this.offset);
        jsonWriter.writeIntField("length", this.length);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeBooleanField("isNegated", this.isNegated);
        return jsonWriter.writeEndObject();
    }

    public static SentenceAssessment fromJson(JsonReader jsonReader) throws IOException {
        return (SentenceAssessment)jsonReader.readObject(reader -> {
            SentenceAssessment deserializedSentenceAssessment = new SentenceAssessment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sentiment".equals(fieldName)) {
                    deserializedSentenceAssessment.sentiment = TokenSentimentValue.fromString(reader.getString());
                    continue;
                }
                if ("confidenceScores".equals(fieldName)) {
                    deserializedSentenceAssessment.confidenceScores = TargetConfidenceScoreLabel.fromJson(reader);
                    continue;
                }
                if ("offset".equals(fieldName)) {
                    deserializedSentenceAssessment.offset = reader.getInt();
                    continue;
                }
                if ("length".equals(fieldName)) {
                    deserializedSentenceAssessment.length = reader.getInt();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    deserializedSentenceAssessment.text = reader.getString();
                    continue;
                }
                if ("isNegated".equals(fieldName)) {
                    deserializedSentenceAssessment.isNegated = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSentenceAssessment;
        });
    }
}

