/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.HealthcareResultDocumentsItem;
import com.azure.ai.textanalytics.implementation.models.PreBuiltResult;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class HealthcareResult
extends PreBuiltResult {
    private List<HealthcareResultDocumentsItem> documents;

    public List<HealthcareResultDocumentsItem> getDocuments() {
        return this.documents;
    }

    public HealthcareResult setDocuments(List<HealthcareResultDocumentsItem> documents) {
        this.documents = documents;
        return this;
    }

    @Override
    public HealthcareResult setErrors(List<DocumentError> errors) {
        super.setErrors(errors);
        return this;
    }

    @Override
    public HealthcareResult setStatistics(RequestStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public HealthcareResult setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", this.getErrors(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("modelVersion", this.getModelVersion());
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static HealthcareResult fromJson(JsonReader jsonReader) throws IOException {
        return (HealthcareResult)jsonReader.readObject(reader -> {
            HealthcareResult deserializedHealthcareResult = new HealthcareResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    deserializedHealthcareResult.setErrors(errors);
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    deserializedHealthcareResult.setModelVersion(reader.getString());
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedHealthcareResult.setStatistics(RequestStatistics.fromJson(reader));
                    continue;
                }
                if ("documents".equals(fieldName)) {
                    List documents;
                    deserializedHealthcareResult.documents = documents = reader.readArray(reader1 -> HealthcareResultDocumentsItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHealthcareResult;
        });
    }
}

