/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AbstractiveSummarizationLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResultsKind;
import com.azure.ai.textanalytics.implementation.models.CustomEntityRecognitionLROResult;
import com.azure.ai.textanalytics.implementation.models.CustomMultiLabelClassificationLROResult;
import com.azure.ai.textanalytics.implementation.models.CustomSingleLabelClassificationLROResult;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingLROResult;
import com.azure.ai.textanalytics.implementation.models.EntityRecognitionLROResult;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationLROResult;
import com.azure.ai.textanalytics.implementation.models.HealthcareLROResult;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseExtractionLROResult;
import com.azure.ai.textanalytics.implementation.models.PiiEntityRecognitionLROResult;
import com.azure.ai.textanalytics.implementation.models.SentimentLROResult;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.ai.textanalytics.implementation.models.TaskState;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class AnalyzeTextLROResult
extends TaskState {
    private AnalyzeTextLROResultsKind kind = AnalyzeTextLROResultsKind.fromString("AnalyzeTextLROResult");
    private String taskName;

    public AnalyzeTextLROResultsKind getKind() {
        return this.kind;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public AnalyzeTextLROResult setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    @Override
    public AnalyzeTextLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    @Override
    public AnalyzeTextLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastUpdateDateTime", this.getLastUpdateDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getLastUpdateDateTime()));
        jsonWriter.writeStringField("status", this.getStatus() == null ? null : this.getStatus().toString());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("taskName", this.taskName);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeTextLROResult fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeTextLROResult)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                AnalyzeTextLROResult analyzeTextLROResult;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("EntityRecognitionLROResults".equals(discriminatorValue)) {
                    analyzeTextLROResult = EntityRecognitionLROResult.fromJson(readerToUse.reset());
                    return analyzeTextLROResult;
                }
                if ("CustomEntityRecognitionLROResults".equals(discriminatorValue)) {
                    analyzeTextLROResult = CustomEntityRecognitionLROResult.fromJson(readerToUse.reset());
                    return analyzeTextLROResult;
                }
                if ("CustomSingleLabelClassificationLROResults".equals(discriminatorValue)) {
                    analyzeTextLROResult = CustomSingleLabelClassificationLROResult.fromJson(readerToUse.reset());
                    return analyzeTextLROResult;
                }
                if ("CustomMultiLabelClassificationLROResults".equals(discriminatorValue)) {
                    analyzeTextLROResult = CustomMultiLabelClassificationLROResult.fromJson(readerToUse.reset());
                    return analyzeTextLROResult;
                }
                if ("EntityLinkingLROResults".equals(discriminatorValue)) {
                    analyzeTextLROResult = EntityLinkingLROResult.fromJson(readerToUse.reset());
                    return analyzeTextLROResult;
                }
                if ("PiiEntityRecognitionLROResults".equals(discriminatorValue)) {
                    analyzeTextLROResult = PiiEntityRecognitionLROResult.fromJson(readerToUse.reset());
                    return analyzeTextLROResult;
                }
                if ("ExtractiveSummarizationLROResults".equals(discriminatorValue)) {
                    analyzeTextLROResult = ExtractiveSummarizationLROResult.fromJson(readerToUse.reset());
                    return analyzeTextLROResult;
                }
                if ("HealthcareLROResults".equals(discriminatorValue)) {
                    analyzeTextLROResult = HealthcareLROResult.fromJson(readerToUse.reset());
                    return analyzeTextLROResult;
                }
                if ("SentimentAnalysisLROResults".equals(discriminatorValue)) {
                    analyzeTextLROResult = SentimentLROResult.fromJson(readerToUse.reset());
                    return analyzeTextLROResult;
                }
                if ("KeyPhraseExtractionLROResults".equals(discriminatorValue)) {
                    analyzeTextLROResult = KeyPhraseExtractionLROResult.fromJson(readerToUse.reset());
                    return analyzeTextLROResult;
                }
                if ("AbstractiveSummarizationLROResults".equals(discriminatorValue)) {
                    analyzeTextLROResult = AbstractiveSummarizationLROResult.fromJson(readerToUse.reset());
                    return analyzeTextLROResult;
                }
                analyzeTextLROResult = AnalyzeTextLROResult.fromJsonKnownDiscriminator(readerToUse.reset());
                return analyzeTextLROResult;
            }
        });
    }

    static AnalyzeTextLROResult fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (AnalyzeTextLROResult)jsonReader.readObject(reader -> {
            AnalyzeTextLROResult deserializedAnalyzeTextLROResult = new AnalyzeTextLROResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedAnalyzeTextLROResult.setLastUpdateDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAnalyzeTextLROResult.setStatus(State.fromString(reader.getString()));
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedAnalyzeTextLROResult.kind = AnalyzeTextLROResultsKind.fromString(reader.getString());
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedAnalyzeTextLROResult.taskName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnalyzeTextLROResult;
        });
    }
}

