/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.PreBuiltResult;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.SentimentResponseDocumentsItem;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class SentimentResponse
extends PreBuiltResult {
    private List<SentimentResponseDocumentsItem> documents;

    public List<SentimentResponseDocumentsItem> getDocuments() {
        return this.documents;
    }

    public SentimentResponse setDocuments(List<SentimentResponseDocumentsItem> documents) {
        this.documents = documents;
        return this;
    }

    @Override
    public SentimentResponse setErrors(List<DocumentError> errors) {
        super.setErrors(errors);
        return this;
    }

    @Override
    public SentimentResponse setStatistics(RequestStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public SentimentResponse setModelVersion(String modelVersion) {
        super.setModelVersion(modelVersion);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", this.getErrors(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("modelVersion", this.getModelVersion());
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SentimentResponse fromJson(JsonReader jsonReader) throws IOException {
        return (SentimentResponse)jsonReader.readObject(reader -> {
            SentimentResponse deserializedSentimentResponse = new SentimentResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> DocumentError.fromJson(reader1));
                    deserializedSentimentResponse.setErrors(errors);
                    continue;
                }
                if ("modelVersion".equals(fieldName)) {
                    deserializedSentimentResponse.setModelVersion(reader.getString());
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedSentimentResponse.setStatistics(RequestStatistics.fromJson(reader));
                    continue;
                }
                if ("documents".equals(fieldName)) {
                    List documents;
                    deserializedSentimentResponse.documents = documents = reader.readArray(reader1 -> SentimentResponseDocumentsItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSentimentResponse;
        });
    }
}

