/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResultsKind;
import com.azure.ai.textanalytics.implementation.models.HealthcareResult;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class HealthcareLROResult
extends AnalyzeTextLROResult {
    private AnalyzeTextLROResultsKind kind = AnalyzeTextLROResultsKind.HEALTHCARE_LRORESULTS;
    private HealthcareResult results;

    @Override
    public AnalyzeTextLROResultsKind getKind() {
        return this.kind;
    }

    public HealthcareResult getResults() {
        return this.results;
    }

    public HealthcareLROResult setResults(HealthcareResult results) {
        this.results = results;
        return this;
    }

    @Override
    public HealthcareLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public HealthcareLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    @Override
    public HealthcareLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastUpdateDateTime", this.getLastUpdateDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getLastUpdateDateTime()));
        jsonWriter.writeStringField("status", this.getStatus() == null ? null : this.getStatus().toString());
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static HealthcareLROResult fromJson(JsonReader jsonReader) throws IOException {
        return (HealthcareLROResult)jsonReader.readObject(reader -> {
            HealthcareLROResult deserializedHealthcareLROResult = new HealthcareLROResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedHealthcareLROResult.setLastUpdateDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedHealthcareLROResult.setStatus(State.fromString(reader.getString()));
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedHealthcareLROResult.setTaskName(reader.getString());
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedHealthcareLROResult.results = HealthcareResult.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedHealthcareLROResult.kind = AnalyzeTextLROResultsKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHealthcareLROResult;
        });
    }
}

