/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation;

import com.azure.ai.textanalytics.implementation.AnalyzeTextsImpl;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResult;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class MicrosoftCognitiveLanguageServiceTextAnalysisImpl {
    private final MicrosoftCognitiveLanguageServiceTextAnalysisService service;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final AnalyzeTextsImpl analyzeTexts;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public AnalyzeTextsImpl getAnalyzeTexts() {
        return this.analyzeTexts;
    }

    MicrosoftCognitiveLanguageServiceTextAnalysisImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    MicrosoftCognitiveLanguageServiceTextAnalysisImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    MicrosoftCognitiveLanguageServiceTextAnalysisImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.analyzeTexts = new AnalyzeTextsImpl(this);
        this.service = (MicrosoftCognitiveLanguageServiceTextAnalysisService)RestProxy.create(MicrosoftCognitiveLanguageServiceTextAnalysisService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeTextTaskResult>> analyzeTextWithResponseAsync(AnalyzeTextTask body, Boolean showStats) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.analyzeText(this.getEndpoint(), this.getApiVersion(), showStats, body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeTextTaskResult>> analyzeTextWithResponseAsync(AnalyzeTextTask body, Boolean showStats, Context context) {
        String accept = "application/json";
        return this.service.analyzeText(this.getEndpoint(), this.getApiVersion(), showStats, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeTextTaskResult> analyzeTextAsync(AnalyzeTextTask body, Boolean showStats) {
        return this.analyzeTextWithResponseAsync(body, showStats).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeTextTaskResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeTextTaskResult> analyzeTextAsync(AnalyzeTextTask body, Boolean showStats, Context context) {
        return this.analyzeTextWithResponseAsync(body, showStats, context).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeTextTaskResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeTextTaskResult> analyzeTextWithResponse(AnalyzeTextTask body, Boolean showStats, Context context) {
        String accept = "application/json";
        return this.service.analyzeTextSync(this.getEndpoint(), this.getApiVersion(), showStats, body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeTextTaskResult analyzeText(AnalyzeTextTask body, Boolean showStats) {
        return (AnalyzeTextTaskResult)this.analyzeTextWithResponse(body, showStats, Context.NONE).getValue();
    }

    @Host(value="{Endpoint}/language")
    @ServiceInterface(name="MicrosoftCognitiveLa")
    public static interface MicrosoftCognitiveLanguageServiceTextAnalysisService {
        @Post(value="/:analyze-text")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeTextTaskResult>> analyzeText(@HostParam(value="Endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="showStats") Boolean var3, @BodyParam(value="application/json") AnalyzeTextTask var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/:analyze-text")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<AnalyzeTextTaskResult> analyzeTextSync(@HostParam(value="Endpoint") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="showStats") Boolean var3, @BodyParam(value="application/json") AnalyzeTextTask var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

