/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.Match;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class LinkedEntity
implements JsonSerializable<LinkedEntity> {
    private String name;
    private List<Match> matches;
    private String language;
    private String id;
    private String url;
    private String dataSource;
    private String bingId;

    public String getName() {
        return this.name;
    }

    public LinkedEntity setName(String name) {
        this.name = name;
        return this;
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    public LinkedEntity setMatches(List<Match> matches) {
        this.matches = matches;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public LinkedEntity setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public LinkedEntity setId(String id) {
        this.id = id;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public LinkedEntity setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public LinkedEntity setDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public String getBingId() {
        return this.bingId;
    }

    public LinkedEntity setBingId(String bingId) {
        this.bingId = bingId;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("matches", this.matches, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("dataSource", this.dataSource);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("bingId", this.bingId);
        return jsonWriter.writeEndObject();
    }

    public static LinkedEntity fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedEntity)jsonReader.readObject(reader -> {
            LinkedEntity deserializedLinkedEntity = new LinkedEntity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedLinkedEntity.name = reader.getString();
                    continue;
                }
                if ("matches".equals(fieldName)) {
                    List matches;
                    deserializedLinkedEntity.matches = matches = reader.readArray(reader1 -> Match.fromJson(reader1));
                    continue;
                }
                if ("language".equals(fieldName)) {
                    deserializedLinkedEntity.language = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedLinkedEntity.url = reader.getString();
                    continue;
                }
                if ("dataSource".equals(fieldName)) {
                    deserializedLinkedEntity.dataSource = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedLinkedEntity.id = reader.getString();
                    continue;
                }
                if ("bingId".equals(fieldName)) {
                    deserializedLinkedEntity.bingId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedEntity;
        });
    }
}

