/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentResult;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.HealthcareEntity;
import com.azure.ai.textanalytics.implementation.models.HealthcareRelation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class HealthcareEntitiesDocumentResult
extends DocumentResult {
    private List<HealthcareEntity> entities;
    private List<HealthcareRelation> relations;

    public List<HealthcareEntity> getEntities() {
        return this.entities;
    }

    public HealthcareEntitiesDocumentResult setEntities(List<HealthcareEntity> entities) {
        this.entities = entities;
        return this;
    }

    public List<HealthcareRelation> getRelations() {
        return this.relations;
    }

    public HealthcareEntitiesDocumentResult setRelations(List<HealthcareRelation> relations) {
        this.relations = relations;
        return this;
    }

    @Override
    public HealthcareEntitiesDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public HealthcareEntitiesDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    @Override
    public HealthcareEntitiesDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("entities", this.entities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("relations", this.relations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static HealthcareEntitiesDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return (HealthcareEntitiesDocumentResult)jsonReader.readObject(reader -> {
            HealthcareEntitiesDocumentResult deserializedHealthcareEntitiesDocumentResult = new HealthcareEntitiesDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedHealthcareEntitiesDocumentResult.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedHealthcareEntitiesDocumentResult.setWarnings(warnings);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedHealthcareEntitiesDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                if ("entities".equals(fieldName)) {
                    List entities;
                    deserializedHealthcareEntitiesDocumentResult.entities = entities = reader.readArray(reader1 -> HealthcareEntity.fromJson(reader1));
                    continue;
                }
                if ("relations".equals(fieldName)) {
                    List relations;
                    deserializedHealthcareEntitiesDocumentResult.relations = relations = reader.readArray(reader1 -> HealthcareRelation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHealthcareEntitiesDocumentResult;
        });
    }
}

