/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.AnalyzeTextsImpl;
import com.azure.ai.textanalytics.implementation.ExtractiveSummaryOperationDetailPropertiesHelper;
import com.azure.ai.textanalytics.implementation.ExtractiveSummaryResultCollectionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TextAnalyticsExceptionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobState;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobsInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsCancelJobHeaders;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsSubmitJobHeaders;
import com.azure.ai.textanalytics.implementation.models.Error;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationLROResult;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationLROTask;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationResult;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationTaskParameters;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.models.ExtractiveSummaryOperationDetail;
import com.azure.ai.textanalytics.models.ExtractiveSummaryOptions;
import com.azure.ai.textanalytics.models.ExtractiveSummarySentencesOrder;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsException;
import com.azure.ai.textanalytics.models.TextDocumentBatchStatistics;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.ExtractiveSummaryPagedFlux;
import com.azure.ai.textanalytics.util.ExtractiveSummaryPagedIterable;
import com.azure.ai.textanalytics.util.ExtractiveSummaryResultCollection;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class ExtractiveSummaryUtilClient {
    private final AnalyzeTextsImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;
    private static final ClientLogger LOGGER = new ClientLogger(ExtractiveSummaryUtilClient.class);

    ExtractiveSummaryUtilClient(AnalyzeTextsImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    PollerFlux<ExtractiveSummaryOperationDetail, ExtractiveSummaryPagedFlux> extractiveSummaryAsync(Iterable<TextDocumentInput> documents, ExtractiveSummaryOptions options, Context context) {
        try {
            this.checkUnsupportedServiceVersionForExtractiveSummary();
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullExtractiveSummaryOptions(options);
            Context finalContext = Utility.getNotNullContext(context);
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            ExtractiveSummarySentencesOrder orderBy = options.getOrderBy();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<ExtractiveSummaryOperationDetail>)this.service.submitJobWithResponseAsync(new AnalyzeTextJobsInput().setDisplayName(options.getDisplayName()).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(Arrays.asList(new ExtractiveSummarizationLROTask().setParameters(new ExtractiveSummarizationTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setSortBy(orderBy == null ? null : ExtractiveSummarySentencesOrder.fromString(orderBy.toString())).setSentenceCount(options.getMaxSentenceCount()).setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())))), finalContext).map(responseBase -> {
                ExtractiveSummaryOperationDetail operationDetail = new ExtractiveSummaryOperationDetail();
                ExtractiveSummaryOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)responseBase.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperation(operationId -> this.service.jobStatusWithResponseAsync((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperation(operationId -> this.service.cancelJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperation(operationId -> Mono.just((Object)((Object)this.getExtractiveSummaryPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext)))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    SyncPoller<ExtractiveSummaryOperationDetail, ExtractiveSummaryPagedIterable> extractiveSummaryPagedIterable(Iterable<TextDocumentInput> documents, ExtractiveSummaryOptions options, Context context) {
        try {
            this.checkUnsupportedServiceVersionForExtractiveSummary();
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullExtractiveSummaryOptions(options);
            Context finalContext = Utility.enableSyncRestProxy(Utility.getNotNullContext(context));
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            String displayName = options.getDisplayName();
            ExtractiveSummarySentencesOrder orderBy = options.getOrderBy();
            ExtractiveSummarizationLROTask task = new ExtractiveSummarizationLROTask().setParameters(new ExtractiveSummarizationTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setSortBy(orderBy == null ? null : ExtractiveSummarySentencesOrder.fromString(orderBy.toString())).setSentenceCount(options.getMaxSentenceCount()).setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled()));
            return SyncPoller.createPoller((Duration)Utility.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.activationOperationSync(documents, task, displayName, finalContext).apply((PollingContext<ExtractiveSummaryOperationDetail>)cxt)), this.pollingOperationSync(operationId -> this.service.jobStatusWithResponse((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperationSync(operationId -> this.service.cancelJobWithResponse((UUID)operationId, finalContext)), this.fetchingOperationIterable(operationId -> this.getExtractiveSummaryPagedIterable((UUID)operationId, null, null, finalIncludeStatistics, finalContext)));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
        }
    }

    ExtractiveSummaryPagedFlux getExtractiveSummaryPagedFlux(UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        return new ExtractiveSummaryPagedFlux(() -> (continuationToken, pageSize) -> this.getPagedResult((String)continuationToken, operationId, top, skip, showStats, context).flux());
    }

    ExtractiveSummaryPagedIterable getExtractiveSummaryPagedIterable(UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        return new ExtractiveSummaryPagedIterable(() -> (continuationToken, pageSize) -> this.getPagedResultSync((String)continuationToken, operationId, top, skip, showStats, context));
    }

    Mono<PagedResponse<ExtractiveSummaryResultCollection>> getPagedResult(String continuationToken, UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        try {
            if (continuationToken != null) {
                Map<String, Object> continuationTokenMap = Utility.parseNextLink(continuationToken);
                top = Utility.getTopContinuesToken(continuationTokenMap);
                skip = Utility.getSkipContinuesToken(continuationTokenMap);
                showStats = Utility.getShowStatsContinuesToken(continuationTokenMap);
            }
            return this.service.jobStatusWithResponseAsync(operationId, showStats, top, skip, context).map(this::toExtractiveSummaryResultCollectionPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedResponse<ExtractiveSummaryResultCollection> getPagedResultSync(String continuationToken, UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        if (continuationToken != null) {
            Map<String, Object> continuationTokenMap = Utility.parseNextLink(continuationToken);
            top = Utility.getTopContinuesToken(continuationTokenMap);
            skip = Utility.getSkipContinuesToken(continuationTokenMap);
            showStats = Utility.getShowStatsContinuesToken(continuationTokenMap);
        }
        return this.toExtractiveSummaryResultCollectionPagedResponse(this.service.jobStatusWithResponse(operationId, showStats, top, skip, context));
    }

    private PagedResponse<ExtractiveSummaryResultCollection> toExtractiveSummaryResultCollectionPagedResponse(Response<AnalyzeTextJobState> response) {
        List<Error> errors;
        AnalyzeTextJobState jobState = (AnalyzeTextJobState)response.getValue();
        List<AnalyzeTextLROResult> lroResults = jobState.getTasks().getItems();
        AnalyzeTextLROResult lroResult = lroResults.get(0);
        if (!(lroResult instanceof ExtractiveSummarizationLROResult)) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Invalid class type returned: " + lroResult.getClass().getName()));
        }
        ExtractiveSummarizationLROResult extractiveSummarizationLROResult = (ExtractiveSummarizationLROResult)lroResults.get(0);
        ExtractiveSummarizationResult extractiveSummarizationResult = extractiveSummarizationLROResult.getResults();
        ExtractiveSummaryResultCollection extractiveSummaryResultCollection = Utility.toExtractiveSummaryResultCollection(extractiveSummarizationResult);
        RequestStatistics requestStatistics = extractiveSummarizationResult.getStatistics();
        if (requestStatistics != null) {
            TextDocumentBatchStatistics batchStatistic = new TextDocumentBatchStatistics(requestStatistics.getDocumentsCount(), requestStatistics.getValidDocumentsCount(), requestStatistics.getErroneousDocumentsCount(), requestStatistics.getTransactionsCount());
            ExtractiveSummaryResultCollectionPropertiesHelper.setStatistics(extractiveSummaryResultCollection, batchStatistic);
        }
        if (!CoreUtils.isNullOrEmpty(errors = jobState.getErrors())) {
            TextAnalyticsException textAnalyticsException = new TextAnalyticsException("Extract summary operation failed", null, null);
            IterableStream textAnalyticsErrors = IterableStream.of((Iterable)errors.stream().map(Utility::toTextAnalyticsError).collect(Collectors.toList()));
            TextAnalyticsExceptionPropertiesHelper.setErrors(textAnalyticsException, (IterableStream<TextAnalyticsError>)textAnalyticsErrors);
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)textAnalyticsException));
        }
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Arrays.asList(extractiveSummaryResultCollection), jobState.getNextLink(), null);
    }

    private Function<PollingContext<ExtractiveSummaryOperationDetail>, Mono<ExtractiveSummaryOperationDetail>> activationOperation(Mono<ExtractiveSummaryOperationDetail> operationResult) {
        return pollingContext -> {
            try {
                return operationResult.onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<ExtractiveSummaryOperationDetail>, ExtractiveSummaryOperationDetail> activationOperationSync(Iterable<TextDocumentInput> documents, AnalyzeTextLROTask task, String displayName, Context context) {
        return pollingContext -> {
            ResponseBase<AnalyzeTextsSubmitJobHeaders, Void> analyzeResponse = this.service.submitJobWithResponse(new AnalyzeTextJobsInput().setDisplayName(displayName).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(Arrays.asList(task)), context);
            ExtractiveSummaryOperationDetail operationDetail = new ExtractiveSummaryOperationDetail();
            ExtractiveSummaryOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)analyzeResponse.getDeserializedHeaders()).getOperationLocation()));
            return operationDetail;
        };
    }

    private Function<PollingContext<ExtractiveSummaryOperationDetail>, Mono<PollResponse<ExtractiveSummaryOperationDetail>>> pollingOperation(Function<UUID, Mono<Response<AnalyzeTextJobState>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID operationId = UUID.fromString(((ExtractiveSummaryOperationDetail)operationResultPollResponse.getValue()).getOperationId());
                return ((Mono)pollingFunction.apply(operationId)).flatMap(modelResponse -> Mono.just(this.processAnalyzeTextModelResponse((Response<AnalyzeTextJobState>)modelResponse, (PollResponse<ExtractiveSummaryOperationDetail>)operationResultPollResponse))).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<ExtractiveSummaryOperationDetail>, PollResponse<ExtractiveSummaryOperationDetail>> pollingOperationSync(Function<UUID, Response<AnalyzeTextJobState>> pollingFunction) {
        return pollingContext -> {
            PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
            UUID operationId = UUID.fromString(((ExtractiveSummaryOperationDetail)operationResultPollResponse.getValue()).getOperationId());
            return this.processAnalyzeTextModelResponse((Response<AnalyzeTextJobState>)((Response)pollingFunction.apply(operationId)), (PollResponse<ExtractiveSummaryOperationDetail>)operationResultPollResponse);
        };
    }

    private Function<PollingContext<ExtractiveSummaryOperationDetail>, Mono<ExtractiveSummaryPagedFlux>> fetchingOperation(Function<UUID, Mono<ExtractiveSummaryPagedFlux>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((ExtractiveSummaryOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<ExtractiveSummaryOperationDetail>, ExtractiveSummaryPagedIterable> fetchingOperationIterable(Function<UUID, ExtractiveSummaryPagedIterable> fetchingFunction) {
        return pollingContext -> {
            UUID resultUuid = UUID.fromString(((ExtractiveSummaryOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
            return (ExtractiveSummaryPagedIterable)((Object)((Object)fetchingFunction.apply(resultUuid)));
        };
    }

    private BiFunction<PollingContext<ExtractiveSummaryOperationDetail>, PollResponse<ExtractiveSummaryOperationDetail>, Mono<ExtractiveSummaryOperationDetail>> cancelOperation(Function<UUID, Mono<ResponseBase<AnalyzeTextsCancelJobHeaders, Void>>> cancelFunction) {
        return (activationResponse, pollingContext) -> {
            UUID resultUuid = UUID.fromString(((ExtractiveSummaryOperationDetail)pollingContext.getValue()).getOperationId());
            try {
                return ((Mono)cancelFunction.apply(resultUuid)).map(cancelJobResponse -> {
                    ExtractiveSummaryOperationDetail operationResult = new ExtractiveSummaryOperationDetail();
                    ExtractiveSummaryOperationDetailPropertiesHelper.setOperationId(operationResult, Utility.parseOperationId(((AnalyzeTextsCancelJobHeaders)cancelJobResponse.getDeserializedHeaders()).getOperationLocation()));
                    return operationResult;
                }).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private BiFunction<PollingContext<ExtractiveSummaryOperationDetail>, PollResponse<ExtractiveSummaryOperationDetail>, ExtractiveSummaryOperationDetail> cancelOperationSync(Function<UUID, ResponseBase<AnalyzeTextsCancelJobHeaders, Void>> cancelFunction) {
        return (activationResponse, pollingContext) -> {
            UUID resultUuid = UUID.fromString(((ExtractiveSummaryOperationDetail)pollingContext.getValue()).getOperationId());
            ResponseBase cancelJobResponse = (ResponseBase)cancelFunction.apply(resultUuid);
            ExtractiveSummaryOperationDetail operationResult = new ExtractiveSummaryOperationDetail();
            ExtractiveSummaryOperationDetailPropertiesHelper.setOperationId(operationResult, Utility.parseOperationId(((AnalyzeTextsCancelJobHeaders)cancelJobResponse.getDeserializedHeaders()).getOperationLocation()));
            return operationResult;
        };
    }

    private PollResponse<ExtractiveSummaryOperationDetail> processAnalyzeTextModelResponse(Response<AnalyzeTextJobState> analyzeOperationResultResponse, PollResponse<ExtractiveSummaryOperationDetail> operationResultPollResponse) {
        State state = ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getStatus();
        LongRunningOperationStatus status = State.NOT_STARTED.equals((Object)state) || State.RUNNING.equals((Object)state) ? LongRunningOperationStatus.IN_PROGRESS : (State.SUCCEEDED.equals((Object)state) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : (State.CANCELLED.equals((Object)state) ? LongRunningOperationStatus.USER_CANCELLED : LongRunningOperationStatus.fromString((String)((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getStatus().toString(), (boolean)true)));
        ExtractiveSummaryOperationDetailPropertiesHelper.setDisplayName((ExtractiveSummaryOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getDisplayName());
        ExtractiveSummaryOperationDetailPropertiesHelper.setCreatedAt((ExtractiveSummaryOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getCreatedDateTime());
        ExtractiveSummaryOperationDetailPropertiesHelper.setLastModifiedAt((ExtractiveSummaryOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getLastUpdatedDateTime());
        ExtractiveSummaryOperationDetailPropertiesHelper.setExpiresAt((ExtractiveSummaryOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getExpirationDateTime());
        return new PollResponse(status, (Object)((ExtractiveSummaryOperationDetail)operationResultPollResponse.getValue()));
    }

    private ExtractiveSummaryOptions getNotNullExtractiveSummaryOptions(ExtractiveSummaryOptions options) {
        return options == null ? new ExtractiveSummaryOptions() : options;
    }

    private void checkUnsupportedServiceVersionForExtractiveSummary() {
        Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0, TextAnalyticsServiceVersion.V3_1, TextAnalyticsServiceVersion.V2022_05_01), Utility.getUnsupportedServiceApiVersionMessage("Extractive Summarization", this.serviceVersion, TextAnalyticsServiceVersion.V2023_04_01));
    }
}

