/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLanguageDetectionInput;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.ai.textanalytics.implementation.models.LanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.LanguageDetectionAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.LanguageDetectionTaskParameters;
import com.azure.ai.textanalytics.models.DetectLanguageInput;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.util.DetectLanguageResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import reactor.core.publisher.Mono;

class DetectLanguageUtilClient {
    private static final ClientLogger LOGGER = new ClientLogger(DetectLanguageUtilClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final MicrosoftCognitiveLanguageServiceTextAnalysisImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;

    DetectLanguageUtilClient(TextAnalyticsClientImpl legacyService, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = legacyService;
        this.service = null;
        this.serviceVersion = serviceVersion;
    }

    DetectLanguageUtilClient(MicrosoftCognitiveLanguageServiceTextAnalysisImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = null;
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    Mono<Response<DetectLanguageResultCollection>> detectLanguageBatch(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options) {
        try {
            return FluxUtil.withContext(context -> this.getDetectedLanguageResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<Response<DetectLanguageResultCollection>> getDetectedLanguageResponse(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options, Context context) {
        this.throwIfCallingNotAvailableFeatureInOptions(options);
        Utility.inputDocumentsValidation(documents);
        TextAnalyticsRequestOptions textAnalyticsRequestOptions = options = options == null ? new TextAnalyticsRequestOptions() : options;
        if (this.service != null) {
            return this.service.analyzeTextWithResponseAsync(new AnalyzeTextLanguageDetectionInput().setParameters(new LanguageDetectionTaskParameters().setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())).setAnalysisInput(new LanguageDetectionAnalysisInput().setDocuments(Utility.toLanguageInput(documents))), options.isIncludeStatistics(), Utility.getNotNullContext(context)).doOnSubscribe(ignoredValue -> LOGGER.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> LOGGER.info("Detected languages for a batch of documents - {}", new Object[]{response.getValue()})).doOnError(error -> LOGGER.warning("Failed to detect language - {}", new Object[]{error})).map(Utility::toDetectLanguageResultCollectionLanguageApi).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        return this.legacyService.languagesWithResponseAsync(new LanguageBatchInput().setDocuments(Utility.toLanguageInput(documents)), options.getModelVersion(), options.isIncludeStatistics(), options.isServiceLogsDisabled(), Utility.getNotNullContext(context)).doOnSubscribe(ignoredValue -> LOGGER.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> LOGGER.info("Detected languages for a batch of documents - {}", new Object[]{response.getValue()})).doOnError(error -> LOGGER.warning("Failed to detect language - {}", new Object[]{error})).map(Utility::toDetectLanguageResultCollectionLegacyApi).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }

    Response<DetectLanguageResultCollection> getDetectedLanguageResponseSync(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options, Context context) {
        this.throwIfCallingNotAvailableFeatureInOptions(options);
        Utility.inputDocumentsValidation(documents);
        context = Utility.enableSyncRestProxy(Utility.getNotNullContext(context));
        options = options == null ? new TextAnalyticsRequestOptions() : options;
        try {
            return this.service != null ? Utility.toDetectLanguageResultCollectionLanguageApi(this.service.analyzeTextWithResponse(new AnalyzeTextLanguageDetectionInput().setParameters(new LanguageDetectionTaskParameters().setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())).setAnalysisInput(new LanguageDetectionAnalysisInput().setDocuments(Utility.toLanguageInput(documents))), options.isIncludeStatistics(), context)) : Utility.toDetectLanguageResultCollectionLegacyApi(this.legacyService.languagesWithResponseSync(new LanguageBatchInput().setDocuments(Utility.toLanguageInput(documents)), options.getModelVersion(), options.isIncludeStatistics(), options.isServiceLogsDisabled(), context));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
        }
    }

    private void throwIfCallingNotAvailableFeatureInOptions(TextAnalyticsRequestOptions options) {
        if (options != null && options.isServiceLogsDisabled()) {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0), Utility.getUnsupportedServiceApiVersionMessage("TextAnalyticsRequestOptions.disableServiceLogs", this.serviceVersion, TextAnalyticsServiceVersion.V3_1));
        }
    }
}

