/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceTextAnalysisImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextKeyPhraseExtractionInput;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseTaskParameters;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.models.ExtractKeyPhraseResult;
import com.azure.ai.textanalytics.models.KeyPhrasesCollection;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.ExtractKeyPhrasesResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import reactor.core.publisher.Mono;

class ExtractKeyPhraseUtilClient {
    private static final ClientLogger LOGGER = new ClientLogger(ExtractKeyPhraseUtilClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final MicrosoftCognitiveLanguageServiceTextAnalysisImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;

    ExtractKeyPhraseUtilClient(TextAnalyticsClientImpl legacyService, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = legacyService;
        this.service = null;
        this.serviceVersion = serviceVersion;
    }

    ExtractKeyPhraseUtilClient(MicrosoftCognitiveLanguageServiceTextAnalysisImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.legacyService = null;
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    Mono<KeyPhrasesCollection> extractKeyPhrasesSingleText(String document, String language) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            TextDocumentInput textDocumentInput = new TextDocumentInput("0", document);
            textDocumentInput.setLanguage(language);
            return this.extractKeyPhrasesWithResponse(Collections.singletonList(textDocumentInput), null).map(resultCollectionResponse -> {
                KeyPhrasesCollection keyPhrasesCollection = null;
                Iterator i$ = ((ExtractKeyPhrasesResultCollection)((Object)((Object)resultCollectionResponse.getValue()))).iterator();
                while (i$.hasNext()) {
                    ExtractKeyPhraseResult keyPhraseResult = (ExtractKeyPhraseResult)i$.next();
                    if (keyPhraseResult.isError()) {
                        throw LOGGER.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(keyPhraseResult.getError())));
                    }
                    keyPhrasesCollection = new KeyPhrasesCollection(keyPhraseResult.getKeyPhrases(), keyPhraseResult.getKeyPhrases().getWarnings());
                }
                return keyPhrasesCollection;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ExtractKeyPhrasesResultCollection>> extractKeyPhrasesWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        try {
            return FluxUtil.withContext(context -> this.getExtractedKeyPhrasesResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<Response<ExtractKeyPhrasesResultCollection>> getExtractedKeyPhrasesResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        this.throwIfCallingNotAvailableFeatureInOptions(options);
        Utility.inputDocumentsValidation(documents);
        TextAnalyticsRequestOptions textAnalyticsRequestOptions = options = options == null ? new TextAnalyticsRequestOptions() : options;
        if (this.service != null) {
            return this.service.analyzeTextWithResponseAsync(new AnalyzeTextKeyPhraseExtractionInput().setParameters(new KeyPhraseTaskParameters().setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))), options.isIncludeStatistics(), Utility.getNotNullContext(context)).doOnSubscribe(ignoredValue -> LOGGER.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> LOGGER.info("A batch of key phrases output - {}", new Object[]{response.getValue()})).doOnError(error -> LOGGER.warning("Failed to extract key phrases - {}", new Object[]{error})).map(Utility::toResultCollectionResponseLanguageApi).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        return this.legacyService.keyPhrasesWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), options.getModelVersion(), options.isIncludeStatistics(), options.isServiceLogsDisabled(), Utility.getNotNullContext(context)).doOnSubscribe(ignoredValue -> LOGGER.info("A batch of document with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> LOGGER.info("A batch of key phrases output - {}", new Object[]{response.getValue()})).doOnError(error -> LOGGER.warning("Failed to extract key phrases - {}", new Object[]{error})).map(Utility::toResultCollectionResponseLegacyApi).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }

    Response<ExtractKeyPhrasesResultCollection> getExtractedKeyPhrasesResponseSync(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        this.throwIfCallingNotAvailableFeatureInOptions(options);
        Utility.inputDocumentsValidation(documents);
        options = options == null ? new TextAnalyticsRequestOptions() : options;
        context = Utility.enableSyncRestProxy(Utility.getNotNullContext(context));
        try {
            return this.service != null ? Utility.toResultCollectionResponseLanguageApi(this.service.analyzeTextWithResponse(new AnalyzeTextKeyPhraseExtractionInput().setParameters(new KeyPhraseTaskParameters().setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))), options.isIncludeStatistics(), context)) : Utility.toResultCollectionResponseLegacyApi(this.legacyService.keyPhrasesWithResponseSync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), options.getModelVersion(), options.isIncludeStatistics(), options.isServiceLogsDisabled(), context));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
        }
    }

    private void throwIfCallingNotAvailableFeatureInOptions(TextAnalyticsRequestOptions options) {
        if (options != null && options.isServiceLogsDisabled()) {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0), Utility.getUnsupportedServiceApiVersionMessage("TextAnalyticsRequestOptions.disableServiceLogs", this.serviceVersion, TextAnalyticsServiceVersion.V3_1));
        }
    }
}

