/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.models.AnalyzeSentimentAction;
import com.azure.ai.textanalytics.models.ExtractKeyPhrasesAction;
import com.azure.ai.textanalytics.models.RecognizeEntitiesAction;
import com.azure.ai.textanalytics.models.RecognizeLinkedEntitiesAction;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesAction;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;

public final class TextAnalyticsActions {
    private final ClientLogger logger = new ClientLogger(TextAnalyticsActions.class);
    private String displayName;
    private Iterable<RecognizeEntitiesAction> recognizeEntitiesActions;
    private Iterable<RecognizeLinkedEntitiesAction> recognizeLinkedEntitiesActions;
    private Iterable<RecognizePiiEntitiesAction> recognizePiiEntitiesActions;
    private Iterable<ExtractKeyPhrasesAction> extractKeyPhrasesActions;
    private Iterable<AnalyzeSentimentAction> analyzeSentimentActions;

    public String getDisplayName() {
        return this.displayName;
    }

    public TextAnalyticsActions setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Iterable<RecognizeEntitiesAction> getRecognizeEntitiesActions() {
        return this.recognizeEntitiesActions;
    }

    public TextAnalyticsActions setRecognizeEntitiesActions(RecognizeEntitiesAction ... recognizeEntitiesActions) {
        this.validateActionsNumber(recognizeEntitiesActions, RecognizeEntitiesAction.class.getName());
        this.recognizeEntitiesActions = recognizeEntitiesActions == null ? null : Arrays.asList(recognizeEntitiesActions);
        return this;
    }

    public Iterable<RecognizeLinkedEntitiesAction> getRecognizeLinkedEntitiesActions() {
        return this.recognizeLinkedEntitiesActions;
    }

    public TextAnalyticsActions setRecognizeLinkedEntitiesActions(RecognizeLinkedEntitiesAction ... recognizeLinkedEntitiesActions) {
        this.validateActionsNumber(recognizeLinkedEntitiesActions, RecognizeLinkedEntitiesAction.class.getName());
        this.recognizeLinkedEntitiesActions = recognizeLinkedEntitiesActions == null ? null : Arrays.asList(recognizeLinkedEntitiesActions);
        return this;
    }

    public Iterable<RecognizePiiEntitiesAction> getRecognizePiiEntitiesActions() {
        return this.recognizePiiEntitiesActions;
    }

    public TextAnalyticsActions setRecognizePiiEntitiesActions(RecognizePiiEntitiesAction ... recognizePiiEntitiesActions) {
        this.validateActionsNumber(recognizePiiEntitiesActions, RecognizePiiEntitiesAction.class.getName());
        this.recognizePiiEntitiesActions = recognizePiiEntitiesActions == null ? null : Arrays.asList(recognizePiiEntitiesActions);
        return this;
    }

    public Iterable<ExtractKeyPhrasesAction> getExtractKeyPhrasesActions() {
        return this.extractKeyPhrasesActions;
    }

    public TextAnalyticsActions setExtractKeyPhrasesActions(ExtractKeyPhrasesAction ... extractKeyPhrasesActions) {
        this.validateActionsNumber(extractKeyPhrasesActions, ExtractKeyPhrasesAction.class.getName());
        this.extractKeyPhrasesActions = extractKeyPhrasesActions == null ? null : Arrays.asList(extractKeyPhrasesActions);
        return this;
    }

    public Iterable<AnalyzeSentimentAction> getAnalyzeSentimentActions() {
        return this.analyzeSentimentActions;
    }

    public TextAnalyticsActions setAnalyzeSentimentActions(AnalyzeSentimentAction ... analyzeSentimentActions) {
        this.validateActionsNumber(analyzeSentimentActions, AnalyzeSentimentAction.class.getName());
        this.analyzeSentimentActions = analyzeSentimentActions == null ? null : Arrays.asList(analyzeSentimentActions);
        return this;
    }

    private void validateActionsNumber(Object[] actions, String actionType) {
        if (actions != null && actions.length > 1) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Currently, the service can accept up to one %s. Multiple actions of the same type are not supported.", actionType)));
        }
    }
}

