/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.implementation.TextAnalyticsActionResultPropertiesHelper;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsException;
import com.azure.core.util.logging.ClientLogger;
import java.time.OffsetDateTime;
import java.util.Locale;

public class TextAnalyticsActionResult {
    private final ClientLogger logger = new ClientLogger(TextAnalyticsActionResult.class);
    private OffsetDateTime completedAt;
    private TextAnalyticsError error;
    private boolean isError;

    public OffsetDateTime getCompletedAt() {
        return this.completedAt;
    }

    public TextAnalyticsError getError() {
        return this.error;
    }

    public boolean isError() {
        return this.isError;
    }

    private void setCompletedAt(OffsetDateTime completedAt) {
        this.completedAt = completedAt;
    }

    private void setError(TextAnalyticsError error) {
        this.error = error;
    }

    private void setIsError(boolean isError) {
        this.isError = isError;
    }

    void throwExceptionIfError() {
        if (this.isError()) {
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new TextAnalyticsException(String.format(Locale.ROOT, "Error in accessing the property on action result, when %s returned with an error: %s", this.getClass().getSimpleName(), this.error.getMessage()), this.error.getErrorCode(), null)));
        }
    }

    static {
        TextAnalyticsActionResultPropertiesHelper.setAccessor(new TextAnalyticsActionResultPropertiesHelper.TextAnalyticsActionResultAccessor(){

            @Override
            public void setCompletedAt(TextAnalyticsActionResult actionResult, OffsetDateTime completedAt) {
                actionResult.setCompletedAt(completedAt);
            }

            @Override
            public void setError(TextAnalyticsActionResult actionResult, TextAnalyticsError error) {
                actionResult.setError(error);
            }

            @Override
            public void setIsError(TextAnalyticsActionResult actionResult, boolean isError) {
                actionResult.setIsError(isError);
            }
        });
    }
}

