/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation;

import com.azure.ai.textanalytics.implementation.AnalyzeHealthcareEntitiesResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AssessmentSentimentPropertiesHelper;
import com.azure.ai.textanalytics.implementation.CategorizedEntityPropertiesHelper;
import com.azure.ai.textanalytics.implementation.EntityDataSourcePropertiesHelper;
import com.azure.ai.textanalytics.implementation.HealthcareEntityAssertionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.HealthcareEntityPropertiesHelper;
import com.azure.ai.textanalytics.implementation.HealthcareEntityRelationPropertiesHelper;
import com.azure.ai.textanalytics.implementation.HealthcareEntityRelationRolePropertiesHelper;
import com.azure.ai.textanalytics.implementation.LinkedEntityMatchPropertiesHelper;
import com.azure.ai.textanalytics.implementation.LinkedEntityPropertiesHelper;
import com.azure.ai.textanalytics.implementation.PiiEntityPropertiesHelper;
import com.azure.ai.textanalytics.implementation.SentenceOpinionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.SentenceSentimentPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TargetSentimentPropertiesHelper;
import com.azure.ai.textanalytics.implementation.models.Association;
import com.azure.ai.textanalytics.implementation.models.Certainty;
import com.azure.ai.textanalytics.implementation.models.Conditionality;
import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.DocumentKeyPhrases;
import com.azure.ai.textanalytics.implementation.models.DocumentSentiment;
import com.azure.ai.textanalytics.implementation.models.DocumentSentimentValue;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.EntitiesResult;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingResult;
import com.azure.ai.textanalytics.implementation.models.ErrorCodeValue;
import com.azure.ai.textanalytics.implementation.models.ErrorResponse;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.ai.textanalytics.implementation.models.HealthcareAssertion;
import com.azure.ai.textanalytics.implementation.models.HealthcareResult;
import com.azure.ai.textanalytics.implementation.models.InnerError;
import com.azure.ai.textanalytics.implementation.models.InnerErrorCodeValue;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseResult;
import com.azure.ai.textanalytics.implementation.models.LanguageInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageInput;
import com.azure.ai.textanalytics.implementation.models.PiiCategory;
import com.azure.ai.textanalytics.implementation.models.PiiResult;
import com.azure.ai.textanalytics.implementation.models.RelationType;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.SentenceAssessment;
import com.azure.ai.textanalytics.implementation.models.SentenceSentiment;
import com.azure.ai.textanalytics.implementation.models.SentenceSentimentValue;
import com.azure.ai.textanalytics.implementation.models.SentenceTarget;
import com.azure.ai.textanalytics.implementation.models.SentimentConfidenceScorePerLabel;
import com.azure.ai.textanalytics.implementation.models.SentimentResponse;
import com.azure.ai.textanalytics.implementation.models.TargetConfidenceScoreLabel;
import com.azure.ai.textanalytics.implementation.models.TargetRelationType;
import com.azure.ai.textanalytics.implementation.models.TextAnalyticsError;
import com.azure.ai.textanalytics.implementation.models.WarningCodeValue;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesResult;
import com.azure.ai.textanalytics.models.AnalyzeSentimentResult;
import com.azure.ai.textanalytics.models.AssessmentSentiment;
import com.azure.ai.textanalytics.models.CategorizedEntity;
import com.azure.ai.textanalytics.models.CategorizedEntityCollection;
import com.azure.ai.textanalytics.models.DetectLanguageInput;
import com.azure.ai.textanalytics.models.EntityAssociation;
import com.azure.ai.textanalytics.models.EntityCategory;
import com.azure.ai.textanalytics.models.EntityCertainty;
import com.azure.ai.textanalytics.models.EntityConditionality;
import com.azure.ai.textanalytics.models.EntityDataSource;
import com.azure.ai.textanalytics.models.ExtractKeyPhraseResult;
import com.azure.ai.textanalytics.models.HealthcareEntity;
import com.azure.ai.textanalytics.models.HealthcareEntityAssertion;
import com.azure.ai.textanalytics.models.HealthcareEntityCategory;
import com.azure.ai.textanalytics.models.HealthcareEntityRelation;
import com.azure.ai.textanalytics.models.HealthcareEntityRelationRole;
import com.azure.ai.textanalytics.models.HealthcareEntityRelationType;
import com.azure.ai.textanalytics.models.KeyPhrasesCollection;
import com.azure.ai.textanalytics.models.LinkedEntity;
import com.azure.ai.textanalytics.models.LinkedEntityCollection;
import com.azure.ai.textanalytics.models.LinkedEntityMatch;
import com.azure.ai.textanalytics.models.PiiEntity;
import com.azure.ai.textanalytics.models.PiiEntityCategory;
import com.azure.ai.textanalytics.models.PiiEntityCollection;
import com.azure.ai.textanalytics.models.RecognizeEntitiesResult;
import com.azure.ai.textanalytics.models.RecognizeLinkedEntitiesResult;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesResult;
import com.azure.ai.textanalytics.models.SentenceOpinion;
import com.azure.ai.textanalytics.models.SentimentConfidenceScores;
import com.azure.ai.textanalytics.models.TargetSentiment;
import com.azure.ai.textanalytics.models.TextAnalyticsErrorCode;
import com.azure.ai.textanalytics.models.TextAnalyticsException;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentBatchStatistics;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.models.TextDocumentStatistics;
import com.azure.ai.textanalytics.models.TextSentiment;
import com.azure.ai.textanalytics.models.WarningCode;
import com.azure.ai.textanalytics.util.AnalyzeSentimentResultCollection;
import com.azure.ai.textanalytics.util.ExtractKeyPhrasesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeLinkedEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizePiiEntitiesResultCollection;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class Utility {
    public static final Duration DEFAULT_POLL_INTERVAL = Duration.ofSeconds(5L);
    private static final ClientLogger LOGGER = new ClientLogger(Utility.class);
    private static final int NEUTRAL_SCORE_ZERO = 0;
    private static final String DOCUMENT_SENTENCES_ASSESSMENTS_REG_EXP = "#/documents/(\\d+)/sentences/(\\d+)/assessments/(\\d+)";
    private static final Pattern PATTERN = Pattern.compile("#/documents/(\\d+)/sentences/(\\d+)/assessments/(\\d+)");

    private Utility() {
    }

    public static void inputDocumentsValidation(Iterable<?> documents) {
        Objects.requireNonNull(documents, "'documents' cannot be null.");
        Iterator<?> iterator = documents.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("'documents' cannot be empty.");
        }
    }

    public static Throwable mapToHttpResponseExceptionIfExists(Throwable throwable) {
        if (throwable instanceof ErrorResponseException) {
            ErrorResponseException errorException = (ErrorResponseException)((Object)throwable);
            ErrorResponse errorResponse = errorException.getValue();
            com.azure.ai.textanalytics.models.TextAnalyticsError textAnalyticsError = null;
            if (errorResponse != null && errorResponse.getError() != null) {
                textAnalyticsError = Utility.toTextAnalyticsError(errorResponse.getError());
            }
            return new HttpResponseException(errorException.getMessage(), errorException.getResponse(), (Object)textAnalyticsError);
        }
        return throwable;
    }

    public static <T> List<T> mapByIndex(Iterable<String> documents, BiFunction<String, String, T> mappingFunction) {
        Objects.requireNonNull(documents, "'documents' cannot be null.");
        AtomicInteger i = new AtomicInteger(0);
        ArrayList result = new ArrayList();
        documents.forEach(document -> result.add(mappingFunction.apply(String.valueOf(i.getAndIncrement()), (String)document)));
        return result;
    }

    public static TextDocumentStatistics toTextDocumentStatistics(DocumentStatistics statistics) {
        return new TextDocumentStatistics(statistics.getCharactersCount(), statistics.getTransactionsCount());
    }

    public static TextDocumentBatchStatistics toBatchStatistics(RequestStatistics statistics) {
        return new TextDocumentBatchStatistics(statistics.getDocumentsCount(), statistics.getValidDocumentsCount(), statistics.getErroneousDocumentsCount(), statistics.getTransactionsCount());
    }

    public static com.azure.ai.textanalytics.models.TextAnalyticsError toTextAnalyticsError(TextAnalyticsError textAnalyticsError) {
        InnerError innerError = textAnalyticsError.getInnererror();
        if (innerError == null) {
            ErrorCodeValue errorCodeValue = textAnalyticsError.getCode();
            return new com.azure.ai.textanalytics.models.TextAnalyticsError(TextAnalyticsErrorCode.fromString(errorCodeValue == null ? null : errorCodeValue.toString()), textAnalyticsError.getMessage(), textAnalyticsError.getTarget());
        }
        InnerErrorCodeValue innerErrorCodeValue = innerError.getCode();
        return new com.azure.ai.textanalytics.models.TextAnalyticsError(TextAnalyticsErrorCode.fromString(innerErrorCodeValue == null ? null : innerErrorCodeValue.toString()), innerError.getMessage(), innerError.getTarget());
    }

    public static List<MultiLanguageInput> toMultiLanguageInput(Iterable<TextDocumentInput> documents) {
        ArrayList<MultiLanguageInput> multiLanguageInputs = new ArrayList<MultiLanguageInput>();
        for (TextDocumentInput textDocumentInput : documents) {
            multiLanguageInputs.add(new MultiLanguageInput().setId(textDocumentInput.getId()).setText(textDocumentInput.getText()).setLanguage(textDocumentInput.getLanguage()));
        }
        return multiLanguageInputs;
    }

    public static TextAnalyticsException toTextAnalyticsException(com.azure.ai.textanalytics.models.TextAnalyticsError error) {
        return new TextAnalyticsException(error.getMessage(), error.getErrorCode(), error.getTarget());
    }

    public static List<LanguageInput> toLanguageInput(Iterable<DetectLanguageInput> documents) {
        ArrayList<LanguageInput> multiLanguageInputs = new ArrayList<LanguageInput>();
        documents.forEach(textDocumentInput -> multiLanguageInputs.add(new LanguageInput().setId(textDocumentInput.getId()).setText(textDocumentInput.getText()).setCountryHint(textDocumentInput.getCountryHint())));
        return multiLanguageInputs;
    }

    public static String parseOperationId(String operationLocation) {
        int lastIndex;
        if (!CoreUtils.isNullOrEmpty((CharSequence)operationLocation) && (lastIndex = operationLocation.lastIndexOf(47)) != -1) {
            return operationLocation.substring(lastIndex + 1);
        }
        throw LOGGER.logExceptionAsError(new RuntimeException("Failed to parse operation header for operation Id from: " + operationLocation));
    }

    public static Map<String, Object> parseNextLink(String nextLink) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)nextLink)) {
            String[] parameters;
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            String[] strings = nextLink.split("\\?", 2);
            for (String parameter : parameters = strings[1].split("&")) {
                String[] parameterPair = parameter.split("=");
                String key = parameterPair[0];
                String value = parameterPair[1];
                if ("showStats".equals(key)) {
                    parameterMap.put(key, value);
                    continue;
                }
                if (!"$skip".equals(key) && !"$top".equals(key)) continue;
                parameterMap.put(key, Integer.valueOf(value));
            }
            return parameterMap;
        }
        return new HashMap<String, Object>();
    }

    public static RecognizeEntitiesResultCollection toRecognizeEntitiesResultCollectionResponse(EntitiesResult entitiesResult) {
        ArrayList<RecognizeEntitiesResult> recognizeEntitiesResults = new ArrayList<RecognizeEntitiesResult>();
        entitiesResult.getDocuments().forEach(documentEntities -> recognizeEntitiesResults.add(new RecognizeEntitiesResult(documentEntities.getId(), documentEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentEntities.getStatistics()), null, new CategorizedEntityCollection((IterableStream<CategorizedEntity>)new IterableStream((Iterable)documentEntities.getEntities().stream().map(entity -> {
            CategorizedEntity categorizedEntity = new CategorizedEntity(entity.getText(), EntityCategory.fromString(entity.getCategory()), entity.getSubcategory(), entity.getConfidenceScore());
            CategorizedEntityPropertiesHelper.setLength(categorizedEntity, entity.getLength());
            CategorizedEntityPropertiesHelper.setOffset(categorizedEntity, entity.getOffset());
            return categorizedEntity;
        }).collect(Collectors.toList())), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentEntities.getWarnings().stream().map(warning -> {
            WarningCodeValue warningCodeValue = warning.getCode();
            return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
        }).collect(Collectors.toList()))))));
        for (DocumentError documentError : entitiesResult.getErrors()) {
            recognizeEntitiesResults.add(new RecognizeEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new RecognizeEntitiesResultCollection(recognizeEntitiesResults, entitiesResult.getModelVersion(), entitiesResult.getStatistics() == null ? null : Utility.toBatchStatistics(entitiesResult.getStatistics()));
    }

    public static RecognizePiiEntitiesResultCollection toRecognizePiiEntitiesResultCollection(PiiResult piiEntitiesResult) {
        ArrayList<RecognizePiiEntitiesResult> recognizeEntitiesResults = new ArrayList<RecognizePiiEntitiesResult>();
        piiEntitiesResult.getDocuments().forEach(documentEntities -> {
            List piiEntities = documentEntities.getEntities().stream().map(entity -> {
                PiiEntity piiEntity = new PiiEntity();
                PiiEntityPropertiesHelper.setText(piiEntity, entity.getText());
                PiiEntityPropertiesHelper.setCategory(piiEntity, PiiEntityCategory.fromString(entity.getCategory()));
                PiiEntityPropertiesHelper.setSubcategory(piiEntity, entity.getSubcategory());
                PiiEntityPropertiesHelper.setConfidenceScore(piiEntity, entity.getConfidenceScore());
                PiiEntityPropertiesHelper.setOffset(piiEntity, entity.getOffset());
                return piiEntity;
            }).collect(Collectors.toList());
            List warnings = documentEntities.getWarnings().stream().map(warning -> {
                WarningCodeValue warningCodeValue = warning.getCode();
                return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
            }).collect(Collectors.toList());
            recognizeEntitiesResults.add(new RecognizePiiEntitiesResult(documentEntities.getId(), documentEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentEntities.getStatistics()), null, new PiiEntityCollection((IterableStream<PiiEntity>)new IterableStream(piiEntities), documentEntities.getRedactedText(), (IterableStream<TextAnalyticsWarning>)new IterableStream(warnings))));
        });
        for (DocumentError documentError : piiEntitiesResult.getErrors()) {
            recognizeEntitiesResults.add(new RecognizePiiEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new RecognizePiiEntitiesResultCollection(recognizeEntitiesResults, piiEntitiesResult.getModelVersion(), piiEntitiesResult.getStatistics() == null ? null : Utility.toBatchStatistics(piiEntitiesResult.getStatistics()));
    }

    public static ExtractKeyPhrasesResultCollection toExtractKeyPhrasesResultCollection(KeyPhraseResult keyPhraseResult) {
        ArrayList<ExtractKeyPhraseResult> keyPhraseResultList = new ArrayList<ExtractKeyPhraseResult>();
        for (DocumentKeyPhrases documentKeyPhrases : keyPhraseResult.getDocuments()) {
            String documentId = documentKeyPhrases.getId();
            keyPhraseResultList.add(new ExtractKeyPhraseResult(documentId, documentKeyPhrases.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentKeyPhrases.getStatistics()), null, new KeyPhrasesCollection((IterableStream<String>)new IterableStream(documentKeyPhrases.getKeyPhrases()), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentKeyPhrases.getWarnings().stream().map(warning -> {
                WarningCodeValue warningCodeValue = warning.getCode();
                return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
            }).collect(Collectors.toList())))));
        }
        for (DocumentError documentError : keyPhraseResult.getErrors()) {
            keyPhraseResultList.add(new ExtractKeyPhraseResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new ExtractKeyPhrasesResultCollection(keyPhraseResultList, keyPhraseResult.getModelVersion(), keyPhraseResult.getStatistics() == null ? null : Utility.toBatchStatistics(keyPhraseResult.getStatistics()));
    }

    public static Response<RecognizeLinkedEntitiesResultCollection> toRecognizeLinkedEntitiesResultCollectionResponse(Response<EntityLinkingResult> response) {
        EntityLinkingResult entityLinkingResult = (EntityLinkingResult)response.getValue();
        return new SimpleResponse(response, (Object)new RecognizeLinkedEntitiesResultCollection((Iterable<RecognizeLinkedEntitiesResult>)((Object)Utility.toRecognizeLinkedEntitiesResultCollection(entityLinkingResult)), entityLinkingResult.getModelVersion(), entityLinkingResult.getStatistics() == null ? null : Utility.toBatchStatistics(entityLinkingResult.getStatistics())));
    }

    public static RecognizeLinkedEntitiesResultCollection toRecognizeLinkedEntitiesResultCollection(EntityLinkingResult entityLinkingResult) {
        List<RecognizeLinkedEntitiesResult> linkedEntitiesResults = entityLinkingResult.getDocuments().stream().map(documentLinkedEntities -> new RecognizeLinkedEntitiesResult(documentLinkedEntities.getId(), documentLinkedEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentLinkedEntities.getStatistics()), null, new LinkedEntityCollection((IterableStream<LinkedEntity>)new IterableStream((Iterable)documentLinkedEntities.getEntities().stream().map(linkedEntity -> {
            LinkedEntity entity = new LinkedEntity(linkedEntity.getName(), (IterableStream<LinkedEntityMatch>)new IterableStream((Iterable)linkedEntity.getMatches().stream().map(match -> {
                LinkedEntityMatch linkedEntityMatch = new LinkedEntityMatch(match.getText(), match.getConfidenceScore());
                LinkedEntityMatchPropertiesHelper.setOffset(linkedEntityMatch, match.getOffset());
                LinkedEntityMatchPropertiesHelper.setLength(linkedEntityMatch, match.getLength());
                return linkedEntityMatch;
            }).collect(Collectors.toList())), linkedEntity.getLanguage(), linkedEntity.getId(), linkedEntity.getUrl(), linkedEntity.getDataSource());
            LinkedEntityPropertiesHelper.setBingEntitySearchApiId(entity, linkedEntity.getBingId());
            return entity;
        }).collect(Collectors.toList())), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentLinkedEntities.getWarnings().stream().map(warning -> {
            WarningCodeValue warningCodeValue = warning.getCode();
            return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
        }).collect(Collectors.toList()))))).collect(Collectors.toList());
        for (DocumentError documentError : entityLinkingResult.getErrors()) {
            linkedEntitiesResults.add(new RecognizeLinkedEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new RecognizeLinkedEntitiesResultCollection(linkedEntitiesResults, entityLinkingResult.getModelVersion(), entityLinkingResult.getStatistics() == null ? null : Utility.toBatchStatistics(entityLinkingResult.getStatistics()));
    }

    public static IterableStream<AnalyzeHealthcareEntitiesResult> toRecognizeHealthcareEntitiesResults(HealthcareResult healthcareResult) {
        ArrayList analyzeHealthcareEntitiesResults = new ArrayList();
        healthcareResult.getDocuments().forEach(documentEntities -> {
            AnalyzeHealthcareEntitiesResult analyzeHealthcareEntitiesResult = new AnalyzeHealthcareEntitiesResult(documentEntities.getId(), documentEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentEntities.getStatistics()), null);
            List warnings = documentEntities.getWarnings().stream().map(textAnalyticsWarning -> new TextAnalyticsWarning(Optional.ofNullable(textAnalyticsWarning.getCode()).map(warningCodeValue -> WarningCode.fromString(warningCodeValue.toString())).orElse(null), textAnalyticsWarning.getMessage())).collect(Collectors.toList());
            AnalyzeHealthcareEntitiesResultPropertiesHelper.setWarnings(analyzeHealthcareEntitiesResult, (IterableStream<TextAnalyticsWarning>)IterableStream.of(warnings));
            List healthcareEntities = documentEntities.getEntities().stream().map(entity -> {
                HealthcareEntity healthcareEntity = new HealthcareEntity();
                HealthcareEntityPropertiesHelper.setText(healthcareEntity, entity.getText());
                HealthcareEntityPropertiesHelper.setNormalizedText(healthcareEntity, entity.getName());
                if (entity.getCategory() != null) {
                    HealthcareEntityPropertiesHelper.setCategory(healthcareEntity, HealthcareEntityCategory.fromString(entity.getCategory().toString()));
                }
                HealthcareEntityPropertiesHelper.setConfidenceScore(healthcareEntity, entity.getConfidenceScore());
                HealthcareEntityPropertiesHelper.setOffset(healthcareEntity, entity.getOffset());
                HealthcareEntityPropertiesHelper.setLength(healthcareEntity, entity.getLength());
                List entityDataSources = Optional.ofNullable(entity.getLinks()).map(links -> links.stream().map(link -> {
                    EntityDataSource dataSource = new EntityDataSource();
                    EntityDataSourcePropertiesHelper.setName(dataSource, link.getDataSource());
                    EntityDataSourcePropertiesHelper.setEntityId(dataSource, link.getId());
                    return dataSource;
                }).collect(Collectors.toList())).orElse(new ArrayList());
                HealthcareEntityPropertiesHelper.setDataSources(healthcareEntity, (IterableStream<EntityDataSource>)IterableStream.of((Iterable)entityDataSources));
                HealthcareAssertion assertion = entity.getAssertion();
                if (assertion != null) {
                    HealthcareEntityPropertiesHelper.setAssertion(healthcareEntity, Utility.toHealthcareEntityAssertion(assertion));
                }
                return healthcareEntity;
            }).collect(Collectors.toList());
            AnalyzeHealthcareEntitiesResultPropertiesHelper.setEntities(analyzeHealthcareEntitiesResult, (IterableStream<HealthcareEntity>)IterableStream.of(healthcareEntities));
            List healthcareEntityRelations = documentEntities.getRelations().stream().map(healthcareRelation -> {
                HealthcareEntityRelation entityRelation = new HealthcareEntityRelation();
                RelationType relationType = healthcareRelation.getRelationType();
                if (relationType != null) {
                    HealthcareEntityRelationPropertiesHelper.setRelationType(entityRelation, HealthcareEntityRelationType.fromString(relationType.toString()));
                }
                List relationRoles = healthcareRelation.getEntities().stream().map(relationEntity -> {
                    HealthcareEntityRelationRole relationRole = new HealthcareEntityRelationRole();
                    HealthcareEntityRelationRolePropertiesHelper.setName(relationRole, relationEntity.getRole());
                    HealthcareEntityRelationRolePropertiesHelper.setEntity(relationRole, (HealthcareEntity)healthcareEntities.get(Utility.getHealthcareEntityIndex(relationEntity.getRef())));
                    return relationRole;
                }).collect(Collectors.toList());
                HealthcareEntityRelationPropertiesHelper.setRoles(entityRelation, (IterableStream<HealthcareEntityRelationRole>)IterableStream.of(relationRoles));
                return entityRelation;
            }).collect(Collectors.toList());
            AnalyzeHealthcareEntitiesResultPropertiesHelper.setEntityRelations(analyzeHealthcareEntitiesResult, (IterableStream<HealthcareEntityRelation>)IterableStream.of(healthcareEntityRelations));
            analyzeHealthcareEntitiesResults.add(analyzeHealthcareEntitiesResult);
        });
        healthcareResult.getErrors().forEach(documentError -> analyzeHealthcareEntitiesResults.add(new AnalyzeHealthcareEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()))));
        return IterableStream.of(analyzeHealthcareEntitiesResults);
    }

    public static HealthcareEntityAssertion toHealthcareEntityAssertion(HealthcareAssertion healthcareAssertion) {
        Association association = healthcareAssertion.getAssociation();
        Certainty certainty = healthcareAssertion.getCertainty();
        Conditionality conditionality = healthcareAssertion.getConditionality();
        HealthcareEntityAssertion entityAssertion = new HealthcareEntityAssertion();
        if (association != null) {
            HealthcareEntityAssertionPropertiesHelper.setAssociation(entityAssertion, EntityAssociation.fromString(association.toString()));
        }
        if (certainty != null) {
            HealthcareEntityAssertionPropertiesHelper.setCertainty(entityAssertion, Utility.toCertainty(certainty));
        }
        if (conditionality != null) {
            HealthcareEntityAssertionPropertiesHelper.setConditionality(entityAssertion, Utility.toConditionality(conditionality));
        }
        return entityAssertion;
    }

    private static EntityCertainty toCertainty(Certainty certainty) {
        EntityCertainty entityCertainty1 = null;
        switch (certainty) {
            case POSITIVE: {
                entityCertainty1 = EntityCertainty.POSITIVE;
                break;
            }
            case POSITIVE_POSSIBLE: {
                entityCertainty1 = EntityCertainty.POSITIVE_POSSIBLE;
                break;
            }
            case NEUTRAL_POSSIBLE: {
                entityCertainty1 = EntityCertainty.NEUTRAL_POSSIBLE;
                break;
            }
            case NEGATIVE_POSSIBLE: {
                entityCertainty1 = EntityCertainty.NEGATIVE_POSSIBLE;
                break;
            }
            case NEGATIVE: {
                entityCertainty1 = EntityCertainty.NEGATIVE;
                break;
            }
        }
        return entityCertainty1;
    }

    private static EntityConditionality toConditionality(Conditionality conditionality) {
        EntityConditionality conditionality1 = null;
        switch (conditionality) {
            case HYPOTHETICAL: {
                conditionality1 = EntityConditionality.HYPOTHETICAL;
                break;
            }
            case CONDITIONAL: {
                conditionality1 = EntityConditionality.CONDITIONAL;
                break;
            }
        }
        return conditionality1;
    }

    private static Integer getHealthcareEntityIndex(String entityReference) {
        int lastIndex;
        if (!CoreUtils.isNullOrEmpty((CharSequence)entityReference) && (lastIndex = entityReference.lastIndexOf(47)) != -1) {
            return Integer.parseInt(entityReference.substring(lastIndex + 1));
        }
        throw LOGGER.logExceptionAsError(new RuntimeException("Failed to parse healthcare entity index from: " + entityReference));
    }

    public static Context getNotNullContext(Context context) {
        return context == null ? Context.NONE : context;
    }

    public static int getDocumentCount(Iterable<?> documents) {
        if (documents instanceof Collection) {
            return ((Collection)documents).size();
        }
        int[] count = new int[]{0};
        documents.forEach(ignored -> {
            count[0] = count[0] + 1;
        });
        return count[0];
    }

    public static List<PiiCategory> toCategoriesFilter(Iterable<PiiEntityCategory> categoriesFilter) {
        if (categoriesFilter == null) {
            return null;
        }
        ArrayList<PiiCategory> piiCategories = new ArrayList<PiiCategory>();
        categoriesFilter.forEach(category -> piiCategories.add(PiiCategory.fromString(category.toString())));
        return piiCategories;
    }

    public static AnalyzeSentimentResultCollection toAnalyzeSentimentResultCollection(SentimentResponse sentimentResponse) {
        ArrayList<AnalyzeSentimentResult> analyzeSentimentResults = new ArrayList<AnalyzeSentimentResult>();
        List<DocumentSentiment> documentSentiments = sentimentResponse.getDocuments();
        for (DocumentSentiment documentSentiment : documentSentiments) {
            analyzeSentimentResults.add(Utility.convertToAnalyzeSentimentResult(documentSentiment, documentSentiments));
        }
        for (DocumentError documentError : sentimentResponse.getErrors()) {
            analyzeSentimentResults.add(new AnalyzeSentimentResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new AnalyzeSentimentResultCollection(analyzeSentimentResults, sentimentResponse.getModelVersion(), sentimentResponse.getStatistics() == null ? null : Utility.toBatchStatistics(sentimentResponse.getStatistics()));
    }

    private static AnalyzeSentimentResult convertToAnalyzeSentimentResult(DocumentSentiment documentSentiment, List<DocumentSentiment> documentSentimentList) {
        SentimentConfidenceScorePerLabel confidenceScorePerLabel = documentSentiment.getConfidenceScores();
        List sentenceSentiments = documentSentiment.getSentences().stream().map(sentenceSentiment -> {
            SentimentConfidenceScorePerLabel confidenceScorePerSentence = sentenceSentiment.getConfidenceScores();
            SentenceSentimentValue sentenceSentimentValue = sentenceSentiment.getSentiment();
            com.azure.ai.textanalytics.models.SentenceSentiment sentenceSentiment1 = new com.azure.ai.textanalytics.models.SentenceSentiment(sentenceSentiment.getText(), TextSentiment.fromString(sentenceSentimentValue == null ? null : sentenceSentimentValue.toString()), new SentimentConfidenceScores(confidenceScorePerSentence.getNegative(), confidenceScorePerSentence.getNeutral(), confidenceScorePerSentence.getPositive()));
            SentenceSentimentPropertiesHelper.setOpinions(sentenceSentiment1, Utility.toSentenceOpinionList(sentenceSentiment, documentSentimentList));
            SentenceSentimentPropertiesHelper.setOffset(sentenceSentiment1, sentenceSentiment.getOffset());
            SentenceSentimentPropertiesHelper.setLength(sentenceSentiment1, sentenceSentiment.getLength());
            return sentenceSentiment1;
        }).collect(Collectors.toList());
        List warnings = documentSentiment.getWarnings().stream().map(warning -> {
            WarningCodeValue warningCodeValue = warning.getCode();
            return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
        }).collect(Collectors.toList());
        DocumentSentimentValue documentSentimentValue = documentSentiment.getSentiment();
        return new AnalyzeSentimentResult(documentSentiment.getId(), documentSentiment.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentSentiment.getStatistics()), null, new com.azure.ai.textanalytics.models.DocumentSentiment(TextSentiment.fromString(documentSentimentValue == null ? null : documentSentimentValue.toString()), new SentimentConfidenceScores(confidenceScorePerLabel.getNegative(), confidenceScorePerLabel.getNeutral(), confidenceScorePerLabel.getPositive()), (IterableStream<com.azure.ai.textanalytics.models.SentenceSentiment>)new IterableStream(sentenceSentiments), (IterableStream<TextAnalyticsWarning>)new IterableStream(warnings)));
    }

    private static IterableStream<SentenceOpinion> toSentenceOpinionList(SentenceSentiment sentenceSentiment, List<DocumentSentiment> documentSentimentList) {
        List<SentenceTarget> sentenceTargets = sentenceSentiment.getTargets();
        if (sentenceTargets == null) {
            return null;
        }
        ArrayList sentenceOpinions = new ArrayList();
        sentenceTargets.forEach(sentenceTarget -> {
            ArrayList assessmentSentiments = new ArrayList();
            sentenceTarget.getRelations().forEach(targetRelation -> {
                TargetRelationType targetRelationType = targetRelation.getRelationType();
                String opinionPointer = targetRelation.getRef();
                if (TargetRelationType.ASSESSMENT == targetRelationType) {
                    assessmentSentiments.add(Utility.toAssessmentSentiment(Utility.findSentimentAssessment(opinionPointer, documentSentimentList)));
                }
            });
            TargetSentiment targetSentiment = new TargetSentiment();
            TargetSentimentPropertiesHelper.setText(targetSentiment, sentenceTarget.getText());
            TargetSentimentPropertiesHelper.setSentiment(targetSentiment, TextSentiment.fromString(sentenceTarget.getSentiment().toString()));
            TargetSentimentPropertiesHelper.setConfidenceScores(targetSentiment, Utility.toSentimentConfidenceScores(sentenceTarget.getConfidenceScores()));
            TargetSentimentPropertiesHelper.setOffset(targetSentiment, sentenceTarget.getOffset());
            TargetSentimentPropertiesHelper.setLength(targetSentiment, sentenceTarget.getLength());
            SentenceOpinion sentenceOpinion = new SentenceOpinion();
            SentenceOpinionPropertiesHelper.setTarget(sentenceOpinion, targetSentiment);
            SentenceOpinionPropertiesHelper.setAssessments(sentenceOpinion, (IterableStream<AssessmentSentiment>)new IterableStream(assessmentSentiments));
            sentenceOpinions.add(sentenceOpinion);
        });
        return new IterableStream(sentenceOpinions);
    }

    private static SentimentConfidenceScores toSentimentConfidenceScores(TargetConfidenceScoreLabel targetConfidenceScoreLabel) {
        return new SentimentConfidenceScores(targetConfidenceScoreLabel.getNegative(), 0.0, targetConfidenceScoreLabel.getPositive());
    }

    private static AssessmentSentiment toAssessmentSentiment(SentenceAssessment sentenceAssessment) {
        AssessmentSentiment assessmentSentiment = new AssessmentSentiment();
        AssessmentSentimentPropertiesHelper.setText(assessmentSentiment, sentenceAssessment.getText());
        AssessmentSentimentPropertiesHelper.setSentiment(assessmentSentiment, TextSentiment.fromString(sentenceAssessment.getSentiment().toString()));
        AssessmentSentimentPropertiesHelper.setConfidenceScores(assessmentSentiment, Utility.toSentimentConfidenceScores(sentenceAssessment.getConfidenceScores()));
        AssessmentSentimentPropertiesHelper.setNegated(assessmentSentiment, sentenceAssessment.isNegated());
        AssessmentSentimentPropertiesHelper.setOffset(assessmentSentiment, sentenceAssessment.getOffset());
        AssessmentSentimentPropertiesHelper.setLength(assessmentSentiment, sentenceAssessment.getLength());
        return assessmentSentiment;
    }

    public static int[] parseRefPointerToIndexArray(String assessmentPointer) {
        Matcher matcher = PATTERN.matcher(assessmentPointer);
        boolean isMatched = matcher.find();
        int[] result = new int[3];
        if (!isMatched) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("'%s' is not a valid assessment pointer.", assessmentPointer)));
        }
        result[0] = Integer.parseInt(matcher.group(1));
        result[1] = Integer.parseInt(matcher.group(2));
        result[2] = Integer.parseInt(matcher.group(3));
        return result;
    }

    public static SentenceAssessment findSentimentAssessment(String assessmentPointer, List<DocumentSentiment> documentSentiments) {
        int[] assessmentIndexes = Utility.parseRefPointerToIndexArray(assessmentPointer);
        int documentIndex = assessmentIndexes[0];
        int sentenceIndex = assessmentIndexes[1];
        int assessmentIndex = assessmentIndexes[2];
        if (documentIndex >= documentSentiments.size()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Invalid document index '%s' in '%s'.", documentIndex, assessmentPointer)));
        }
        DocumentSentiment documentsentiment = documentSentiments.get(documentIndex);
        List<SentenceSentiment> sentenceSentiments = documentsentiment.getSentences();
        if (sentenceIndex >= sentenceSentiments.size()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Invalid sentence index '%s' in '%s'.", sentenceIndex, assessmentPointer)));
        }
        List<SentenceAssessment> assessments = sentenceSentiments.get(sentenceIndex).getAssessments();
        if (assessmentIndex >= assessments.size()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Invalid assessment index '%s' in '%s'.", assessmentIndex, assessmentPointer)));
        }
        return assessments.get(assessmentIndex);
    }
}

