/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.implementation.PiiEntityPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.PiiResult;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.implementation.models.WarningCodeValue;
import com.azure.ai.textanalytics.models.PiiEntity;
import com.azure.ai.textanalytics.models.PiiEntityCategory;
import com.azure.ai.textanalytics.models.PiiEntityCollection;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesOptions;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesResult;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.models.WarningCode;
import com.azure.ai.textanalytics.util.RecognizePiiEntitiesResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class RecognizePiiEntityAsyncClient {
    private final ClientLogger logger = new ClientLogger(RecognizePiiEntityAsyncClient.class);
    private final TextAnalyticsClientImpl service;

    RecognizePiiEntityAsyncClient(TextAnalyticsClientImpl service) {
        this.service = service;
    }

    Mono<PiiEntityCollection> recognizePiiEntities(String document, String language, RecognizePiiEntitiesOptions options) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            return this.recognizePiiEntitiesBatch(Collections.singletonList(new TextDocumentInput("0", document).setLanguage(language)), options).map(resultCollectionResponse -> {
                PiiEntityCollection entityCollection = null;
                Iterator iterator = ((RecognizePiiEntitiesResultCollection)((Object)((Object)resultCollectionResponse.getValue()))).iterator();
                while (iterator.hasNext()) {
                    RecognizePiiEntitiesResult entitiesResult = (RecognizePiiEntitiesResult)iterator.next();
                    if (entitiesResult.isError()) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(entitiesResult.getError())));
                    }
                    entityCollection = new PiiEntityCollection(entitiesResult.getEntities(), entitiesResult.getEntities().getRedactedText(), entitiesResult.getEntities().getWarnings());
                }
                return entityCollection;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RecognizePiiEntitiesResultCollection>> recognizePiiEntitiesBatch(Iterable<TextDocumentInput> documents, RecognizePiiEntitiesOptions options) {
        try {
            Utility.inputDocumentsValidation(documents);
            return FluxUtil.withContext(context -> this.getRecognizePiiEntitiesResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RecognizePiiEntitiesResultCollection>> recognizePiiEntitiesBatchWithContext(Iterable<TextDocumentInput> documents, RecognizePiiEntitiesOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            return this.getRecognizePiiEntitiesResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Response<RecognizePiiEntitiesResultCollection> toRecognizePiiEntitiesResultCollectionResponse(Response<PiiResult> response) {
        PiiResult piiEntitiesResult = (PiiResult)response.getValue();
        ArrayList<RecognizePiiEntitiesResult> recognizeEntitiesResults = new ArrayList<RecognizePiiEntitiesResult>();
        piiEntitiesResult.getDocuments().forEach(documentEntities -> {
            List piiEntities = documentEntities.getEntities().stream().map(entity -> {
                PiiEntity piiEntity = new PiiEntity();
                PiiEntityPropertiesHelper.setText(piiEntity, entity.getText());
                PiiEntityPropertiesHelper.setCategory(piiEntity, PiiEntityCategory.fromString(entity.getCategory()));
                PiiEntityPropertiesHelper.setSubcategory(piiEntity, entity.getSubcategory());
                PiiEntityPropertiesHelper.setConfidenceScore(piiEntity, entity.getConfidenceScore());
                PiiEntityPropertiesHelper.setOffset(piiEntity, entity.getOffset());
                PiiEntityPropertiesHelper.setLength(piiEntity, entity.getLength());
                return piiEntity;
            }).collect(Collectors.toList());
            List warnings = documentEntities.getWarnings().stream().map(warning -> {
                WarningCodeValue warningCodeValue = warning.getCode();
                return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
            }).collect(Collectors.toList());
            recognizeEntitiesResults.add(new RecognizePiiEntitiesResult(documentEntities.getId(), documentEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentEntities.getStatistics()), null, new PiiEntityCollection((IterableStream<PiiEntity>)new IterableStream(piiEntities), documentEntities.getRedactedText(), (IterableStream<TextAnalyticsWarning>)new IterableStream(warnings))));
        });
        for (DocumentError documentError : piiEntitiesResult.getErrors()) {
            recognizeEntitiesResults.add(new RecognizePiiEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new SimpleResponse(response, (Object)new RecognizePiiEntitiesResultCollection(recognizeEntitiesResults, piiEntitiesResult.getModelVersion(), piiEntitiesResult.getStatistics() == null ? null : Utility.toBatchStatistics(piiEntitiesResult.getStatistics())));
    }

    private Mono<Response<RecognizePiiEntitiesResultCollection>> getRecognizePiiEntitiesResponse(Iterable<TextDocumentInput> documents, RecognizePiiEntitiesOptions options, Context context) {
        options = options == null ? new RecognizePiiEntitiesOptions() : options;
        return this.service.entitiesRecognitionPiiWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), options.getModelVersion(), options.isIncludeStatistics(), options.isServiceLogsDisabled(), options.getDomainFilter() != null ? options.getDomainFilter().toString() : null, StringIndexType.UTF16CODE_UNIT, Utility.toCategoriesFilter(options.getCategoriesFilter()), Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices")).doOnSubscribe(ignoredValue -> this.logger.info("Start recognizing Personally Identifiable Information entities for a batch of documents.")).doOnSuccess(response -> this.logger.info("Successfully recognized Personally Identifiable Information entities for a batch of documents.")).doOnError(error -> this.logger.warning("Failed to recognize Personally Identifiable Information entities - {}", new Object[]{error})).map(this::toRecognizePiiEntitiesResultCollectionResponse).onErrorMap(throwable -> Utility.mapToHttpResponseExceptionIfExists(throwable));
    }
}

