/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.implementation.AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeHealthcareEntitiesResultCollectionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsExceptionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.CancelHealthJobHeaders;
import com.azure.ai.textanalytics.implementation.models.CancelHealthJobResponse;
import com.azure.ai.textanalytics.implementation.models.HealthHeaders;
import com.azure.ai.textanalytics.implementation.models.HealthcareJobState;
import com.azure.ai.textanalytics.implementation.models.HealthcareResult;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.implementation.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOptions;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesResult;
import com.azure.ai.textanalytics.models.TextAnalyticsException;
import com.azure.ai.textanalytics.models.TextDocumentBatchStatistics;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AnalyzeHealthcareEntitiesPagedFlux;
import com.azure.ai.textanalytics.util.AnalyzeHealthcareEntitiesPagedIterable;
import com.azure.ai.textanalytics.util.AnalyzeHealthcareEntitiesResultCollection;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class AnalyzeHealthcareEntityAsyncClient {
    private final ClientLogger logger = new ClientLogger(AnalyzeHealthcareEntityAsyncClient.class);
    private final TextAnalyticsClientImpl service;

    AnalyzeHealthcareEntityAsyncClient(TextAnalyticsClientImpl service) {
        this.service = service;
    }

    PollerFlux<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedFlux> beginAnalyzeHealthcareEntities(Iterable<TextDocumentInput> documents, AnalyzeHealthcareEntitiesOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullAnalyzeHealthcareEntitiesOptions(options);
            Context finalContext = Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeHealthcareEntitiesOperationDetail>)this.service.healthWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), options.getModelVersion(), StringIndexType.UTF16CODE_UNIT, options.isServiceLogsDisabled(), finalContext).map(healthResponse -> {
                AnalyzeHealthcareEntitiesOperationDetail operationDetail = new AnalyzeHealthcareEntitiesOperationDetail();
                AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((HealthHeaders)healthResponse.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperation(operationId -> this.service.healthStatusWithResponseAsync((UUID)operationId, null, null, finalIncludeStatistics, finalContext)), this.cancelOperation(operationId -> this.service.cancelHealthJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperation(operationId -> Mono.just((Object)((Object)this.getHealthcareEntitiesPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext)))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    PollerFlux<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedIterable> beginAnalyzeHealthcarePagedIterable(Iterable<TextDocumentInput> documents, AnalyzeHealthcareEntitiesOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullAnalyzeHealthcareEntitiesOptions(options);
            Context finalContext = Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeHealthcareEntitiesOperationDetail>)this.service.healthWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), options.getModelVersion(), StringIndexType.UTF16CODE_UNIT, options.isServiceLogsDisabled(), finalContext).map(healthResponse -> {
                AnalyzeHealthcareEntitiesOperationDetail operationDetail = new AnalyzeHealthcareEntitiesOperationDetail();
                AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((HealthHeaders)healthResponse.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperation(operationId -> this.service.healthStatusWithResponseAsync((UUID)operationId, null, null, finalIncludeStatistics, finalContext)), this.cancelOperation(operationId -> this.service.cancelHealthJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperationIterable(operationId -> Mono.just((Object)((Object)new AnalyzeHealthcareEntitiesPagedIterable(this.getHealthcareEntitiesPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext))))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    AnalyzeHealthcareEntitiesPagedFlux getHealthcareEntitiesPagedFlux(UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        return new AnalyzeHealthcareEntitiesPagedFlux(() -> (continuationToken, pageSize) -> this.getPagedResult((String)continuationToken, operationId, top, skip, showStats, context).flux());
    }

    Mono<PagedResponse<AnalyzeHealthcareEntitiesResultCollection>> getPagedResult(String continuationToken, UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        try {
            if (continuationToken != null) {
                Map<String, Object> continuationTokenMap = Utility.parseNextLink(continuationToken);
                Integer topValue = continuationTokenMap.getOrDefault("$top", null);
                Integer skipValue = continuationTokenMap.getOrDefault("$skip", null);
                Boolean showStatsValue = (Boolean)continuationTokenMap.getOrDefault(showStats, false);
                return this.service.healthStatusWithResponseAsync(operationId, topValue, skipValue, showStatsValue, context).map(this::toTextAnalyticsPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            return this.service.healthStatusWithResponseAsync(operationId, top, skip, showStats, context).map(this::toTextAnalyticsPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private PagedResponse<AnalyzeHealthcareEntitiesResultCollection> toTextAnalyticsPagedResponse(Response<HealthcareJobState> response) {
        List<TextAnalyticsError> errors;
        HealthcareJobState healthcareJobState = (HealthcareJobState)response.getValue();
        HealthcareResult healthcareResult = healthcareJobState.getResults();
        IterableStream<AnalyzeHealthcareEntitiesResult> recognizeHealthcareEntitiesResults = Utility.toRecognizeHealthcareEntitiesResults(healthcareResult);
        AnalyzeHealthcareEntitiesResultCollection analyzeHealthcareEntitiesResultCollection = new AnalyzeHealthcareEntitiesResultCollection((Iterable<AnalyzeHealthcareEntitiesResult>)recognizeHealthcareEntitiesResults);
        AnalyzeHealthcareEntitiesResultCollectionPropertiesHelper.setModelVersion(analyzeHealthcareEntitiesResultCollection, healthcareResult.getModelVersion());
        RequestStatistics requestStatistics = healthcareResult.getStatistics();
        if (requestStatistics != null) {
            TextDocumentBatchStatistics batchStatistic = new TextDocumentBatchStatistics(requestStatistics.getDocumentsCount(), requestStatistics.getValidDocumentsCount(), requestStatistics.getErroneousDocumentsCount(), requestStatistics.getTransactionsCount());
            AnalyzeHealthcareEntitiesResultCollectionPropertiesHelper.setStatistics(analyzeHealthcareEntitiesResultCollection, batchStatistic);
        }
        if (!CoreUtils.isNullOrEmpty(errors = healthcareJobState.getErrors())) {
            TextAnalyticsException textAnalyticsException = new TextAnalyticsException("Analyze healthcare operation failed", null, null);
            IterableStream textAnalyticsErrors = IterableStream.of((Iterable)errors.stream().map(Utility::toTextAnalyticsError).collect(Collectors.toList()));
            TextAnalyticsExceptionPropertiesHelper.setErrors(textAnalyticsException, (IterableStream<com.azure.ai.textanalytics.models.TextAnalyticsError>)textAnalyticsErrors);
            throw this.logger.logExceptionAsError((RuntimeException)((Object)textAnalyticsException));
        }
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Arrays.asList(analyzeHealthcareEntitiesResultCollection), healthcareJobState.getNextLink(), null);
    }

    private Function<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, Mono<AnalyzeHealthcareEntitiesOperationDetail>> activationOperation(Mono<AnalyzeHealthcareEntitiesOperationDetail> operationResult) {
        return pollingContext -> {
            try {
                return operationResult.onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, Mono<PollResponse<AnalyzeHealthcareEntitiesOperationDetail>>> pollingOperation(Function<UUID, Mono<Response<HealthcareJobState>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID resultUuid = UUID.fromString(((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue()).getOperationId());
                return ((Mono)pollingFunction.apply(resultUuid)).flatMap(modelResponse -> this.processAnalyzeModelResponse((Response<HealthcareJobState>)modelResponse, (PollResponse<AnalyzeHealthcareEntitiesOperationDetail>)operationResultPollResponse)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, Mono<AnalyzeHealthcareEntitiesPagedFlux>> fetchingOperation(Function<UUID, Mono<AnalyzeHealthcareEntitiesPagedFlux>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((AnalyzeHealthcareEntitiesOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private BiFunction<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, PollResponse<AnalyzeHealthcareEntitiesOperationDetail>, Mono<AnalyzeHealthcareEntitiesOperationDetail>> cancelOperation(Function<UUID, Mono<CancelHealthJobResponse>> cancelFunction) {
        return (activationResponse, pollingContext) -> {
            UUID resultUuid = UUID.fromString(((AnalyzeHealthcareEntitiesOperationDetail)pollingContext.getValue()).getOperationId());
            try {
                return ((Mono)cancelFunction.apply(resultUuid)).map(cancelHealthJobResponse -> {
                    AnalyzeHealthcareEntitiesOperationDetail operationResult = new AnalyzeHealthcareEntitiesOperationDetail();
                    AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setOperationId(operationResult, Utility.parseOperationId(((CancelHealthJobHeaders)cancelHealthJobResponse.getDeserializedHeaders()).getOperationLocation()));
                    return operationResult;
                }).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeHealthcareEntitiesOperationDetail>, Mono<AnalyzeHealthcareEntitiesPagedIterable>> fetchingOperationIterable(Function<UUID, Mono<AnalyzeHealthcareEntitiesPagedIterable>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((AnalyzeHealthcareEntitiesOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PollResponse<AnalyzeHealthcareEntitiesOperationDetail>> processAnalyzeModelResponse(Response<HealthcareJobState> analyzeOperationResultResponse, PollResponse<AnalyzeHealthcareEntitiesOperationDetail> operationResultPollResponse) {
        LongRunningOperationStatus status;
        switch (((HealthcareJobState)analyzeOperationResultResponse.getValue()).getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case CANCELLED: {
                status = LongRunningOperationStatus.USER_CANCELLED;
                break;
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((HealthcareJobState)analyzeOperationResultResponse.getValue()).getStatus().toString(), (boolean)true);
            }
        }
        AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setCreatedAt((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue(), ((HealthcareJobState)analyzeOperationResultResponse.getValue()).getCreatedDateTime());
        AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setLastModifiedAt((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue(), ((HealthcareJobState)analyzeOperationResultResponse.getValue()).getLastUpdateDateTime());
        AnalyzeHealthcareEntitiesOperationDetailPropertiesHelper.setExpiresAt((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue(), ((HealthcareJobState)analyzeOperationResultResponse.getValue()).getExpirationDateTime());
        return Mono.just((Object)new PollResponse(status, (Object)((AnalyzeHealthcareEntitiesOperationDetail)operationResultPollResponse.getValue())));
    }

    private AnalyzeHealthcareEntitiesOptions getNotNullAnalyzeHealthcareEntitiesOptions(AnalyzeHealthcareEntitiesOptions options) {
        return options == null ? new AnalyzeHealthcareEntitiesOptions() : options;
    }
}

