/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Sku
implements JsonSerializable<Sku> {
    private final long capacity;
    private final String family;
    private final String name;
    private final String size;
    private final String tier;

    private Sku(long capacity, String family, String name, String size, String tier) {
        this.capacity = capacity;
        this.family = family;
        this.name = name;
        this.size = size;
        this.tier = tier;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public String getFamily() {
        return this.family;
    }

    public String getName() {
        return this.name;
    }

    public String getSize() {
        return this.size;
    }

    public String getTier() {
        return this.tier;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("capacity", this.capacity);
        jsonWriter.writeStringField("family", this.family);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("size", this.size);
        jsonWriter.writeStringField("tier", this.tier);
        return jsonWriter.writeEndObject();
    }

    public static Sku fromJson(JsonReader jsonReader) throws IOException {
        return (Sku)jsonReader.readObject(reader -> {
            long capacity = 0L;
            String family = null;
            String name = null;
            String size = null;
            String tier = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("capacity".equals(fieldName)) {
                    capacity = reader.getLong();
                    continue;
                }
                if ("family".equals(fieldName)) {
                    family = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    size = reader.getString();
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    tier = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new Sku(capacity, family, name, size, tier);
        });
    }
}

