/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.AttackStrategy;
import com.azure.ai.projects.models.RiskCategory;
import com.azure.ai.projects.models.TargetConfig;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class RedTeam
implements JsonSerializable<RedTeam> {
    private String name;
    private String displayName;
    private Integer numTurns;
    private List<AttackStrategy> attackStrategies;
    private Boolean simulationOnly;
    private List<RiskCategory> riskCategories;
    private String applicationScenario;
    private Map<String, String> tags;
    private Map<String, String> properties;
    private String status;
    private final TargetConfig target;

    public RedTeam(TargetConfig target) {
        this.target = target;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public RedTeam setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Integer getNumTurns() {
        return this.numTurns;
    }

    public RedTeam setNumTurns(Integer numTurns) {
        this.numTurns = numTurns;
        return this;
    }

    public List<AttackStrategy> getAttackStrategies() {
        return this.attackStrategies;
    }

    public RedTeam setAttackStrategies(List<AttackStrategy> attackStrategies) {
        this.attackStrategies = attackStrategies;
        return this;
    }

    public Boolean isSimulationOnly() {
        return this.simulationOnly;
    }

    public RedTeam setSimulationOnly(Boolean simulationOnly) {
        this.simulationOnly = simulationOnly;
        return this;
    }

    public List<RiskCategory> getRiskCategories() {
        return this.riskCategories;
    }

    public RedTeam setRiskCategories(List<RiskCategory> riskCategories) {
        this.riskCategories = riskCategories;
        return this;
    }

    public String getApplicationScenario() {
        return this.applicationScenario;
    }

    public RedTeam setApplicationScenario(String applicationScenario) {
        this.applicationScenario = applicationScenario;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public RedTeam setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public RedTeam setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public TargetConfig getTarget() {
        return this.target;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("target", (JsonSerializable)this.target);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeNumberField("numTurns", (Number)this.numTurns);
        jsonWriter.writeArrayField("attackStrategies", this.attackStrategies, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeBooleanField("simulationOnly", this.simulationOnly);
        jsonWriter.writeArrayField("riskCategories", this.riskCategories, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("applicationScenario", this.applicationScenario);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static RedTeam fromJson(JsonReader jsonReader) throws IOException {
        return (RedTeam)jsonReader.readObject(reader -> {
            String name = null;
            TargetConfig target = null;
            String displayName = null;
            Integer numTurns = null;
            List attackStrategies = null;
            Boolean simulationOnly = null;
            List riskCategories = null;
            String applicationScenario = null;
            Map tags = null;
            Map properties = null;
            String status = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    target = TargetConfig.fromJson(reader);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("numTurns".equals(fieldName)) {
                    numTurns = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("attackStrategies".equals(fieldName)) {
                    attackStrategies = reader.readArray(reader1 -> AttackStrategy.fromString(reader1.getString()));
                    continue;
                }
                if ("simulationOnly".equals(fieldName)) {
                    simulationOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("riskCategories".equals(fieldName)) {
                    riskCategories = reader.readArray(reader1 -> RiskCategory.fromString(reader1.getString()));
                    continue;
                }
                if ("applicationScenario".equals(fieldName)) {
                    applicationScenario = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    properties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            RedTeam deserializedRedTeam = new RedTeam(target);
            deserializedRedTeam.name = name;
            deserializedRedTeam.displayName = displayName;
            deserializedRedTeam.numTurns = numTurns;
            deserializedRedTeam.attackStrategies = attackStrategies;
            deserializedRedTeam.simulationOnly = simulationOnly;
            deserializedRedTeam.riskCategories = riskCategories;
            deserializedRedTeam.applicationScenario = applicationScenario;
            deserializedRedTeam.tags = tags;
            deserializedRedTeam.properties = properties;
            deserializedRedTeam.status = status;
            return deserializedRedTeam;
        });
    }
}

